/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository;

import java.io.Serializable;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.BeanWrapper;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.repository.MongoEntityInformation;
import org.springframework.data.repository.core.support.AbstractEntityInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingMongoEntityInformation<T, ID extends Serializable>
extends AbstractEntityInformation<T, ID>
implements MongoEntityInformation<T, ID> {
    private final MongoPersistentEntity<T> entityMetadata;
    private final String customCollectionName;

    public MappingMongoEntityInformation(MongoPersistentEntity<T> entity) {
        this(entity, null);
    }

    public MappingMongoEntityInformation(MongoPersistentEntity<T> entity, String customCollectionName) {
        super(entity.getType());
        this.entityMetadata = entity;
        this.customCollectionName = customCollectionName;
    }

    public ID getId(T entity) {
        MongoPersistentProperty idProperty = (MongoPersistentProperty)this.entityMetadata.getIdProperty();
        try {
            return (ID)((Serializable)BeanWrapper.create(entity, null).getProperty((PersistentProperty)idProperty));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Class<ID> getIdType() {
        return ((MongoPersistentProperty)this.entityMetadata.getIdProperty()).getType();
    }

    @Override
    public String getCollectionName() {
        return this.customCollectionName == null ? this.entityMetadata.getCollection() : this.customCollectionName;
    }

    @Override
    public String getIdAttribute() {
        return ((MongoPersistentProperty)this.entityMetadata.getIdProperty()).getName();
    }
}

