/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.mongodb.core.geo.GeoPage;
import org.springframework.data.mongodb.core.geo.GeoResult;
import org.springframework.data.mongodb.core.geo.GeoResults;
import org.springframework.data.mongodb.repository.MongoEntityInformation;
import org.springframework.data.mongodb.repository.MongoParameters;
import org.springframework.data.mongodb.repository.MongoRepositoryFactoryBean;
import org.springframework.data.mongodb.repository.Query;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.util.ClassUtils;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MongoQueryMethod
extends QueryMethod {
    private static final List<Class<?>> GEO_NEAR_RESULTS = Arrays.asList(GeoResult.class, GeoResults.class, GeoPage.class);
    private final Method method;
    private final MongoEntityInformation<?, ?> entityInformation;

    public MongoQueryMethod(Method method, RepositoryMetadata metadata, MongoRepositoryFactoryBean.EntityInformationCreator entityInformationCreator) {
        super(method, metadata);
        Assert.notNull((Object)entityInformationCreator, (String)"EntityInformationCreator must not be null!");
        this.method = method;
        this.entityInformation = entityInformationCreator.getEntityInformation(ClassUtils.getReturnedDomainClass((Method)method), this.getDomainClass());
    }

    protected Parameters createParameters(Method method) {
        return new MongoParameters(method, this.isGeoNearQuery(method));
    }

    boolean hasAnnotatedQuery() {
        return this.getAnnotatedQuery() != null;
    }

    String getAnnotatedQuery() {
        String query = (String)AnnotationUtils.getValue((Annotation)this.getQueryAnnotation());
        return StringUtils.hasText((String)query) ? query : null;
    }

    String getFieldSpecification() {
        String value = (String)AnnotationUtils.getValue((Annotation)this.getQueryAnnotation(), (String)"fields");
        return StringUtils.hasText((String)value) ? value : null;
    }

    public MongoEntityInformation<?, ?> getEntityInformation() {
        return this.entityInformation;
    }

    public MongoParameters getParameters() {
        return (MongoParameters)super.getParameters();
    }

    public boolean isGeoNearQuery() {
        return this.isGeoNearQuery(this.method);
    }

    private boolean isGeoNearQuery(Method method) {
        if (GEO_NEAR_RESULTS.contains(method.getReturnType())) {
            return true;
        }
        if (Iterable.class.isAssignableFrom(method.getReturnType())) {
            TypeInformation from = ClassTypeInformation.fromReturnTypeOf((Method)method);
            return GeoResult.class.equals((Object)from.getComponentType().getType());
        }
        return false;
    }

    private Query getQueryAnnotation() {
        return this.method.getAnnotation(Query.class);
    }

    TypeInformation<?> getReturnType() {
        return ClassTypeInformation.fromReturnTypeOf((Method)this.method);
    }
}

