/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoPropertyDescriptors;
import org.springframework.data.mongodb.core.index.Index;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.query.Order;
import org.springframework.data.mongodb.repository.MappingMongoEntityInformation;
import org.springframework.data.mongodb.repository.MongoEntityInformation;
import org.springframework.data.mongodb.repository.MongoQueryMethod;
import org.springframework.data.mongodb.repository.PartTreeMongoQuery;
import org.springframework.data.mongodb.repository.QueryDslMongoRepository;
import org.springframework.data.mongodb.repository.QueryUtils;
import org.springframework.data.mongodb.repository.SimpleMongoRepository;
import org.springframework.data.mongodb.repository.StringBasedMongoQuery;
import org.springframework.data.querydsl.QueryDslPredicateExecutor;
import org.springframework.data.querydsl.QueryDslUtils;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.QueryCreationListener;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoRepositoryFactoryBean<T extends Repository<S, ID>, S, ID extends Serializable>
extends RepositoryFactoryBeanSupport<T, S, ID> {
    private MongoTemplate template;
    private boolean createIndexesForQueryMethods = false;

    public void setTemplate(MongoTemplate template) {
        this.template = template;
    }

    public void setCreateIndexesForQueryMethods(boolean createIndexesForQueryMethods) {
        this.createIndexesForQueryMethods = createIndexesForQueryMethods;
    }

    protected final RepositoryFactorySupport createRepositoryFactory() {
        RepositoryFactorySupport factory = this.getFactoryInstance(this.template);
        if (this.createIndexesForQueryMethods) {
            factory.addQueryCreationListener((QueryCreationListener)new IndexEnsuringQueryCreationListener(this.template));
        }
        return factory;
    }

    protected RepositoryFactorySupport getFactoryInstance(MongoTemplate template) {
        return new MongoRepositoryFactory(template);
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.template, (String)"MongoTemplate must not be null!");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IndexEnsuringQueryCreationListener
    implements QueryCreationListener<PartTreeMongoQuery> {
        private static final Set<Part.Type> GEOSPATIAL_TYPES = new HashSet<Part.Type>(Arrays.asList(Part.Type.NEAR, Part.Type.WITHIN));
        private static final Log LOG = LogFactory.getLog(IndexEnsuringQueryCreationListener.class);
        private final MongoOperations operations;

        public IndexEnsuringQueryCreationListener(MongoOperations operations) {
            this.operations = operations;
        }

        public void onCreation(PartTreeMongoQuery query) {
            PartTree tree = query.getTree();
            Index index = new Index();
            index.named(query.getQueryMethod().getName());
            Sort sort = tree.getSort();
            for (Part part : tree.getParts()) {
                if (GEOSPATIAL_TYPES.contains(part.getType())) {
                    return;
                }
                String property = part.getProperty().toDotPath();
                Order order = IndexEnsuringQueryCreationListener.toOrder(sort, property);
                index.on(property, order);
            }
            if (sort != null) {
                for (Sort.Order order : sort) {
                    index.on(order.getProperty(), QueryUtils.toOrder(order));
                }
            }
            MongoEntityInformation<?, ?> metadata = query.getQueryMethod().getEntityInformation();
            this.operations.ensureIndex((IndexDefinition)index, metadata.getCollectionName());
            LOG.debug((Object)String.format("Created %s!", index));
        }

        private static Order toOrder(Sort sort, String property) {
            if (sort == null) {
                return Order.DESCENDING;
            }
            Sort.Order order = sort.getOrderFor(property);
            return order == null ? Order.DESCENDING : (order.isAscending() ? Order.ASCENDING : Order.DESCENDING);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EntityInformationCreator {
        private final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;

        public EntityInformationCreator(MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
            Assert.notNull(mappingContext);
            this.mappingContext = mappingContext;
        }

        public <T, ID extends Serializable> MongoEntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
            return this.getEntityInformation(domainClass, null);
        }

        public <T, ID extends Serializable> MongoEntityInformation<T, ID> getEntityInformation(Class<T> domainClass, Class<?> collectionClass) {
            MongoPersistentEntity persistentEntity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(domainClass);
            String customCollectionName = collectionClass == null ? null : ((MongoPersistentEntity)this.mappingContext.getPersistentEntity(collectionClass)).getCollection();
            return new MappingMongoEntityInformation(persistentEntity, customCollectionName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MongoRepositoryFactory
    extends RepositoryFactorySupport {
        private final MongoTemplate template;
        private final EntityInformationCreator entityInformationCreator;

        public MongoRepositoryFactory(MongoTemplate template) {
            Assert.notNull((Object)template);
            this.template = template;
            this.entityInformationCreator = new EntityInformationCreator(template.getConverter().getMappingContext());
        }

        protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
            return MongoRepositoryFactory.isQueryDslRepository(metadata.getRepositoryInterface()) ? QueryDslMongoRepository.class : SimpleMongoRepository.class;
        }

        protected Object getTargetRepository(RepositoryMetadata metadata) {
            Class repositoryInterface = metadata.getRepositoryInterface();
            EntityInformation entityInformation = this.getEntityInformation(metadata.getDomainClass());
            if (MongoRepositoryFactory.isQueryDslRepository(repositoryInterface)) {
                return new QueryDslMongoRepository(entityInformation, this.template);
            }
            return new SimpleMongoRepository(entityInformation, this.template);
        }

        private static boolean isQueryDslRepository(Class<?> repositoryInterface) {
            return QueryDslUtils.QUERY_DSL_PRESENT && QueryDslPredicateExecutor.class.isAssignableFrom(repositoryInterface);
        }

        protected QueryLookupStrategy getQueryLookupStrategy(QueryLookupStrategy.Key key) {
            return new MongoQueryLookupStrategy();
        }

        protected void validate(RepositoryMetadata metadata) {
            Class idClass = metadata.getIdClass();
            if (!MongoPropertyDescriptors.MongoPropertyDescriptor.SUPPORTED_ID_CLASSES.contains(idClass)) {
                throw new IllegalArgumentException(String.format("Unsupported id class! Only %s are supported!", StringUtils.collectionToCommaDelimitedString(MongoPropertyDescriptors.MongoPropertyDescriptor.SUPPORTED_ID_CLASSES)));
            }
        }

        public <T, ID extends Serializable> MongoEntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
            return this.entityInformationCreator.getEntityInformation(domainClass);
        }

        private class MongoQueryLookupStrategy
        implements QueryLookupStrategy {
            private MongoQueryLookupStrategy() {
            }

            public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, NamedQueries namedQueries) {
                MongoQueryMethod queryMethod = new MongoQueryMethod(method, metadata, MongoRepositoryFactory.this.entityInformationCreator);
                String namedQueryName = queryMethod.getNamedQueryName();
                if (namedQueries.hasQuery(namedQueryName)) {
                    String namedQuery = namedQueries.getQuery(namedQueryName);
                    return new StringBasedMongoQuery(namedQuery, queryMethod, MongoRepositoryFactory.this.template);
                }
                if (queryMethod.hasAnnotatedQuery()) {
                    return new StringBasedMongoQuery(queryMethod, MongoRepositoryFactory.this.template);
                }
                return new PartTreeMongoQuery(queryMethod, MongoRepositoryFactory.this.template);
            }
        }
    }
}

