/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MapReduceCommand;
import com.mongodb.MapReduceOutput;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import com.mongodb.util.JSON;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.BSONObject;
import org.bson.types.ObjectId;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.authentication.UserCredentials;
import org.springframework.data.convert.EntityReader;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.BeanWrapper;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.CollectionCallback;
import org.springframework.data.mongodb.core.CollectionOptions;
import org.springframework.data.mongodb.core.CursorPreparer;
import org.springframework.data.mongodb.core.DbCallback;
import org.springframework.data.mongodb.core.DefaultIndexOperations;
import org.springframework.data.mongodb.core.DocumentCallbackHandler;
import org.springframework.data.mongodb.core.FindAndModifyOptions;
import org.springframework.data.mongodb.core.IndexOperations;
import org.springframework.data.mongodb.core.MongoAction;
import org.springframework.data.mongodb.core.MongoActionOperation;
import org.springframework.data.mongodb.core.MongoExceptionTranslator;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.QueryMapper;
import org.springframework.data.mongodb.core.SerializationUtils;
import org.springframework.data.mongodb.core.SimpleMongoDbFactory;
import org.springframework.data.mongodb.core.WriteConcernResolver;
import org.springframework.data.mongodb.core.WriteResultChecking;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.MongoWriter;
import org.springframework.data.mongodb.core.geo.Distance;
import org.springframework.data.mongodb.core.geo.GeoResult;
import org.springframework.data.mongodb.core.geo.GeoResults;
import org.springframework.data.mongodb.core.geo.Metric;
import org.springframework.data.mongodb.core.index.MongoMappingEventPublisher;
import org.springframework.data.mongodb.core.index.MongoPersistentEntityIndexCreator;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.mapping.MongoSimpleTypes;
import org.springframework.data.mongodb.core.mapping.event.AfterConvertEvent;
import org.springframework.data.mongodb.core.mapping.event.AfterLoadEvent;
import org.springframework.data.mongodb.core.mapping.event.AfterSaveEvent;
import org.springframework.data.mongodb.core.mapping.event.BeforeConvertEvent;
import org.springframework.data.mongodb.core.mapping.event.BeforeSaveEvent;
import org.springframework.data.mongodb.core.mapping.event.MongoMappingEvent;
import org.springframework.data.mongodb.core.mapreduce.GroupBy;
import org.springframework.data.mongodb.core.mapreduce.GroupByResults;
import org.springframework.data.mongodb.core.mapreduce.MapReduceOptions;
import org.springframework.data.mongodb.core.mapreduce.MapReduceResults;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.NearQuery;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.util.Assert;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoTemplate
implements MongoOperations,
ApplicationContextAware {
    private static final Log LOGGER = LogFactory.getLog(MongoTemplate.class);
    private static final String ID = "_id";
    private static final WriteResultChecking DEFAULT_WRITE_RESULT_CHECKING = WriteResultChecking.NONE;
    private static final List<String> ITERABLE_CLASSES = new ArrayList<String>(){
        {
            this.add(List.class.getName());
            this.add(Collection.class.getName());
            this.add(Iterator.class.getName());
        }
    };
    private WriteConcern writeConcern = null;
    private WriteConcernResolver writeConcernResolver = new DefaultWriteConcernResolver();
    private WriteResultChecking writeResultChecking = WriteResultChecking.NONE;
    private ReadPreference readPreference = null;
    private final MongoConverter mongoConverter;
    private final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;
    private final MongoDbFactory mongoDbFactory;
    private final MongoExceptionTranslator exceptionTranslator = new MongoExceptionTranslator();
    private final QueryMapper mapper;
    private ApplicationEventPublisher eventPublisher;
    private ResourceLoader resourceLoader;
    private MongoPersistentEntityIndexCreator indexCreator;

    public MongoTemplate(Mongo mongo, String databaseName) {
        this(new SimpleMongoDbFactory(mongo, databaseName), null);
    }

    public MongoTemplate(Mongo mongo, String databaseName, UserCredentials userCredentials) {
        this(new SimpleMongoDbFactory(mongo, databaseName, userCredentials));
    }

    public MongoTemplate(MongoDbFactory mongoDbFactory) {
        this(mongoDbFactory, null);
    }

    public MongoTemplate(MongoDbFactory mongoDbFactory, MongoConverter mongoConverter) {
        Assert.notNull((Object)mongoDbFactory);
        this.mongoDbFactory = mongoDbFactory;
        this.mongoConverter = mongoConverter == null ? MongoTemplate.getDefaultMongoConverter(mongoDbFactory) : mongoConverter;
        this.mapper = new QueryMapper(this.mongoConverter);
        this.mappingContext = this.mongoConverter.getMappingContext();
        if (null != this.mappingContext && this.mappingContext instanceof MongoMappingContext) {
            this.indexCreator = new MongoPersistentEntityIndexCreator((MongoMappingContext)this.mappingContext, mongoDbFactory);
            this.eventPublisher = new MongoMappingEventPublisher(this.indexCreator);
            if (this.mappingContext instanceof ApplicationEventPublisherAware) {
                ((ApplicationEventPublisherAware)this.mappingContext).setApplicationEventPublisher(this.eventPublisher);
            }
        }
    }

    public void setWriteResultChecking(WriteResultChecking resultChecking) {
        this.writeResultChecking = resultChecking == null ? DEFAULT_WRITE_RESULT_CHECKING : resultChecking;
    }

    public void setWriteConcern(WriteConcern writeConcern) {
        this.writeConcern = writeConcern;
    }

    public void setWriteConcernResolver(WriteConcernResolver writeConcernResolver) {
        this.writeConcernResolver = writeConcernResolver;
    }

    public void setReadPreference(ReadPreference readPreference) {
        this.readPreference = readPreference;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        String[] beans = applicationContext.getBeanNamesForType(MongoPersistentEntityIndexCreator.class);
        if ((null == beans || beans.length == 0) && applicationContext instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext)applicationContext).addApplicationListener((ApplicationListener)this.indexCreator);
        }
        this.eventPublisher = applicationContext;
        if (this.mappingContext instanceof ApplicationEventPublisherAware) {
            ((ApplicationEventPublisherAware)this.mappingContext).setApplicationEventPublisher(this.eventPublisher);
        }
        this.resourceLoader = applicationContext;
    }

    @Override
    public MongoConverter getConverter() {
        return this.mongoConverter;
    }

    @Override
    public String getCollectionName(Class<?> entityClass) {
        return this.determineCollectionName(entityClass);
    }

    @Override
    public CommandResult executeCommand(String jsonCommand) {
        return this.executeCommand((DBObject)JSON.parse((String)jsonCommand));
    }

    @Override
    public CommandResult executeCommand(final DBObject command) {
        CommandResult result = this.execute(new DbCallback<CommandResult>(){

            @Override
            public CommandResult doInDB(DB db) throws MongoException, DataAccessException {
                return db.command(command);
            }
        });
        this.logCommandExecutionError(command, result);
        return result;
    }

    @Override
    public CommandResult executeCommand(final DBObject command, final int options) {
        CommandResult result = this.execute(new DbCallback<CommandResult>(){

            @Override
            public CommandResult doInDB(DB db) throws MongoException, DataAccessException {
                return db.command(command, options);
            }
        });
        this.logCommandExecutionError(command, result);
        return result;
    }

    protected void logCommandExecutionError(DBObject command, CommandResult result) {
        String error = result.getErrorMessage();
        if (error != null) {
            LOGGER.warn((Object)("Command execution of " + command.toString() + " failed: " + error));
        }
    }

    @Override
    public void executeQuery(Query query, String collectionName, DocumentCallbackHandler dch) {
        this.executeQuery(query, collectionName, dch, new QueryCursorPreparer(query));
    }

    protected void executeQuery(Query query, String collectionName, DocumentCallbackHandler dch, CursorPreparer preparer) {
        Assert.notNull((Object)query);
        DBObject queryObject = query.getQueryObject();
        DBObject sortObject = query.getSortObject();
        DBObject fieldsObject = query.getFieldsObject();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("Executing query: %s sort: %s fields: %s in collection: $s", SerializationUtils.serializeToJsonSafely(queryObject), sortObject, fieldsObject, collectionName));
        }
        this.executeQueryInternal(new FindCallback(queryObject, fieldsObject), preparer, dch, collectionName);
    }

    @Override
    public <T> T execute(DbCallback<T> action) {
        Assert.notNull(action);
        try {
            DB db = this.getDb();
            return action.doInDB(db);
        }
        catch (RuntimeException e) {
            throw this.potentiallyConvertRuntimeException(e);
        }
    }

    @Override
    public <T> T execute(Class<?> entityClass, CollectionCallback<T> callback) {
        return this.execute(this.determineCollectionName(entityClass), callback);
    }

    @Override
    public <T> T execute(String collectionName, CollectionCallback<T> callback) {
        Assert.notNull(callback);
        try {
            DBCollection collection = this.getAndPrepareCollection(this.getDb(), collectionName);
            return callback.doInCollection(collection);
        }
        catch (RuntimeException e) {
            throw this.potentiallyConvertRuntimeException(e);
        }
    }

    @Override
    public <T> T executeInSession(final DbCallback<T> action) {
        return this.execute(new DbCallback<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T doInDB(DB db) throws MongoException, DataAccessException {
                try {
                    db.requestStart();
                    Object t = action.doInDB(db);
                    return t;
                }
                finally {
                    db.requestDone();
                }
            }
        });
    }

    @Override
    public <T> DBCollection createCollection(Class<T> entityClass) {
        return this.createCollection(this.determineCollectionName(entityClass));
    }

    @Override
    public <T> DBCollection createCollection(Class<T> entityClass, CollectionOptions collectionOptions) {
        return this.createCollection(this.determineCollectionName(entityClass), collectionOptions);
    }

    @Override
    public DBCollection createCollection(String collectionName) {
        return this.doCreateCollection(collectionName, (DBObject)new BasicDBObject());
    }

    @Override
    public DBCollection createCollection(String collectionName, CollectionOptions collectionOptions) {
        return this.doCreateCollection(collectionName, this.convertToDbObject(collectionOptions));
    }

    @Override
    public DBCollection getCollection(final String collectionName) {
        return this.execute(new DbCallback<DBCollection>(){

            @Override
            public DBCollection doInDB(DB db) throws MongoException, DataAccessException {
                return db.getCollection(collectionName);
            }
        });
    }

    @Override
    public <T> boolean collectionExists(Class<T> entityClass) {
        return this.collectionExists(this.determineCollectionName(entityClass));
    }

    @Override
    public boolean collectionExists(final String collectionName) {
        return this.execute(new DbCallback<Boolean>(){

            @Override
            public Boolean doInDB(DB db) throws MongoException, DataAccessException {
                return db.collectionExists(collectionName);
            }
        });
    }

    @Override
    public <T> void dropCollection(Class<T> entityClass) {
        this.dropCollection(this.determineCollectionName(entityClass));
    }

    @Override
    public void dropCollection(String collectionName) {
        this.execute(collectionName, new CollectionCallback<Void>(){

            @Override
            public Void doInCollection(DBCollection collection) throws MongoException, DataAccessException {
                collection.drop();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Dropped collection [" + collection.getFullName() + "]"));
                }
                return null;
            }
        });
    }

    @Override
    public IndexOperations indexOps(String collectionName) {
        return new DefaultIndexOperations(this, collectionName);
    }

    @Override
    public IndexOperations indexOps(Class<?> entityClass) {
        return new DefaultIndexOperations(this, this.determineCollectionName(entityClass));
    }

    @Override
    public <T> T findOne(Query query, Class<T> entityClass) {
        return this.findOne(query, entityClass, this.determineCollectionName(entityClass));
    }

    @Override
    public <T> T findOne(Query query, Class<T> entityClass, String collectionName) {
        if (query.getSortObject() == null) {
            return this.doFindOne(collectionName, query.getQueryObject(), query.getFieldsObject(), entityClass);
        }
        query.limit(1);
        List<T> results = this.find(query, entityClass, collectionName);
        return results.isEmpty() ? null : (T)results.get(0);
    }

    @Override
    public <T> List<T> find(Query query, Class<T> entityClass) {
        return this.find(query, entityClass, this.determineCollectionName(entityClass));
    }

    @Override
    public <T> List<T> find(Query query, Class<T> entityClass, String collectionName) {
        QueryCursorPreparer cursorPreparer = query == null ? null : new QueryCursorPreparer(query);
        return this.doFind(collectionName, query.getQueryObject(), query.getFieldsObject(), entityClass, cursorPreparer);
    }

    @Override
    public <T> T findById(Object id, Class<T> entityClass) {
        MongoPersistentEntity persistentEntity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(entityClass);
        return this.findById(id, entityClass, persistentEntity.getCollection());
    }

    @Override
    public <T> T findById(Object id, Class<T> entityClass, String collectionName) {
        MongoPersistentEntity persistentEntity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(entityClass);
        MongoPersistentProperty idProperty = (MongoPersistentProperty)persistentEntity.getIdProperty();
        String idKey = idProperty == null ? ID : idProperty.getName();
        return this.doFindOne(collectionName, (DBObject)new BasicDBObject(idKey, id), null, entityClass);
    }

    @Override
    public <T> GeoResults<T> geoNear(NearQuery near, Class<T> entityClass) {
        return this.geoNear(near, entityClass, this.determineCollectionName(entityClass));
    }

    @Override
    public <T> GeoResults<T> geoNear(NearQuery near, Class<T> entityClass, String collectionName) {
        if (near == null) {
            throw new InvalidDataAccessApiUsageException("NearQuery must not be null!");
        }
        if (entityClass == null) {
            throw new InvalidDataAccessApiUsageException("Entity class must not be null!");
        }
        String collection = StringUtils.hasText((String)collectionName) ? collectionName : this.determineCollectionName(entityClass);
        BasicDBObject command = new BasicDBObject("geoNear", (Object)collection);
        command.putAll((BSONObject)near.toDBObject());
        CommandResult commandResult = this.executeCommand((DBObject)command);
        List results = (List)commandResult.get("results");
        results = results == null ? Collections.emptyList() : results;
        GeoNearResultDbObjectCallback<Object> callback = new GeoNearResultDbObjectCallback<Object>(new ReadDbObjectCallback<Object>(this.mongoConverter, entityClass), near.getMetric());
        ArrayList result = new ArrayList(results.size());
        for (Object element : results) {
            result.add(callback.doWith((DBObject)element));
        }
        DBObject stats = (DBObject)commandResult.get("stats");
        double averageDistance = stats == null ? 0.0 : (Double)stats.get("avgDistance");
        return new GeoResults(result, new Distance(averageDistance, near.getMetric()));
    }

    @Override
    public <T> T findAndModify(Query query, Update update, Class<T> entityClass) {
        return this.findAndModify(query, update, new FindAndModifyOptions(), entityClass, this.determineCollectionName(entityClass));
    }

    @Override
    public <T> T findAndModify(Query query, Update update, Class<T> entityClass, String collectionName) {
        return this.findAndModify(query, update, new FindAndModifyOptions(), entityClass, collectionName);
    }

    @Override
    public <T> T findAndModify(Query query, Update update, FindAndModifyOptions options, Class<T> entityClass) {
        return this.findAndModify(query, update, options, entityClass, this.determineCollectionName(entityClass));
    }

    @Override
    public <T> T findAndModify(Query query, Update update, FindAndModifyOptions options, Class<T> entityClass, String collectionName) {
        return this.doFindAndModify(collectionName, query.getQueryObject(), query.getFieldsObject(), query.getSortObject(), entityClass, update, options);
    }

    @Override
    public <T> T findAndRemove(Query query, Class<T> entityClass) {
        return this.findAndRemove(query, entityClass, this.determineCollectionName(entityClass));
    }

    @Override
    public <T> T findAndRemove(Query query, Class<T> entityClass, String collectionName) {
        return this.doFindAndRemove(collectionName, query.getQueryObject(), query.getFieldsObject(), query.getSortObject(), entityClass);
    }

    @Override
    public long count(Query query, Class<?> entityClass) {
        Assert.notNull(entityClass);
        return this.count(query, entityClass, this.determineCollectionName(entityClass));
    }

    @Override
    public long count(Query query, String collectionName) {
        return this.count(query, null, collectionName);
    }

    private long count(Query query, Class<?> entityClass, String collectionName) {
        Assert.hasText((String)collectionName);
        final DBObject dbObject = query == null ? null : this.mapper.getMappedObject(query.getQueryObject(), entityClass == null ? null : (MongoPersistentEntity)this.mappingContext.getPersistentEntity(entityClass));
        return this.execute(collectionName, new CollectionCallback<Long>(){

            @Override
            public Long doInCollection(DBCollection collection) throws MongoException, DataAccessException {
                return collection.count(dbObject);
            }
        });
    }

    @Override
    public void insert(Object objectToSave) {
        this.ensureNotIterable(objectToSave);
        this.insert(objectToSave, this.determineEntityCollectionName(objectToSave));
    }

    @Override
    public void insert(Object objectToSave, String collectionName) {
        this.ensureNotIterable(objectToSave);
        this.doInsert(collectionName, objectToSave, this.mongoConverter);
    }

    protected void ensureNotIterable(Object o) {
        if (null != o && (o.getClass().isArray() || ITERABLE_CLASSES.contains(o.getClass().getName()))) {
            throw new IllegalArgumentException("Cannot use a collection here.");
        }
    }

    protected void prepareCollection(DBCollection collection) {
        if (this.readPreference != null) {
            collection.setReadPreference(this.readPreference);
        }
    }

    protected WriteConcern prepareWriteConcern(MongoAction mongoAction) {
        return this.writeConcernResolver.resolve(mongoAction);
    }

    protected <T> void doInsert(String collectionName, T objectToSave, MongoWriter<T> writer) {
        this.assertUpdateableIdIfNotSet(objectToSave);
        BasicDBObject dbDoc = new BasicDBObject();
        this.maybeEmitEvent(new BeforeConvertEvent<T>(objectToSave));
        writer.write(objectToSave, dbDoc);
        this.maybeEmitEvent(new BeforeSaveEvent<T>(objectToSave, (DBObject)dbDoc));
        Object id = this.insertDBObject(collectionName, (DBObject)dbDoc, objectToSave.getClass());
        this.populateIdIfNecessary(objectToSave, id);
        this.maybeEmitEvent(new AfterSaveEvent<T>(objectToSave, (DBObject)dbDoc));
    }

    @Override
    public void insert(Collection<? extends Object> batchToSave, Class<?> entityClass) {
        this.doInsertBatch(this.determineCollectionName(entityClass), batchToSave, this.mongoConverter);
    }

    @Override
    public void insert(Collection<? extends Object> batchToSave, String collectionName) {
        this.doInsertBatch(collectionName, batchToSave, this.mongoConverter);
    }

    @Override
    public void insertAll(Collection<? extends Object> objectsToSave) {
        this.doInsertAll(objectsToSave, this.mongoConverter);
    }

    protected <T> void doInsertAll(Collection<? extends T> listToSave, MongoWriter<T> writer) {
        HashMap<String, ArrayList<T>> objs = new HashMap<String, ArrayList<T>>();
        for (T t : listToSave) {
            MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(t.getClass());
            if (entity == null) {
                throw new InvalidDataAccessApiUsageException("No Persitent Entity information found for the class " + t.getClass().getName());
            }
            String collection = entity.getCollection();
            ArrayList<T> objList = (ArrayList<T>)objs.get(collection);
            if (null == objList) {
                objList = new ArrayList<T>();
                objs.put(collection, objList);
            }
            objList.add(t);
        }
        for (Map.Entry entry : objs.entrySet()) {
            this.doInsertBatch((String)entry.getKey(), (Collection)entry.getValue(), this.mongoConverter);
        }
    }

    protected <T> void doInsertBatch(String collectionName, Collection<? extends T> batchToSave, MongoWriter<T> writer) {
        Assert.notNull(writer);
        ArrayList<DBObject> dbObjectList = new ArrayList<DBObject>();
        for (T o : batchToSave) {
            BasicDBObject dbDoc = new BasicDBObject();
            this.maybeEmitEvent(new BeforeConvertEvent<T>(o));
            writer.write(o, dbDoc);
            this.maybeEmitEvent(new BeforeSaveEvent<T>(o, (DBObject)dbDoc));
            dbObjectList.add((DBObject)dbDoc);
        }
        List<ObjectId> ids = this.insertDBObjectList(collectionName, dbObjectList);
        int i = 0;
        for (T obj : batchToSave) {
            if (i < ids.size()) {
                this.populateIdIfNecessary(obj, ids.get(i));
                this.maybeEmitEvent(new AfterSaveEvent<T>(obj, (DBObject)dbObjectList.get(i)));
            }
            ++i;
        }
    }

    @Override
    public void save(Object objectToSave) {
        this.save(objectToSave, this.determineEntityCollectionName(objectToSave));
    }

    @Override
    public void save(Object objectToSave, String collectionName) {
        this.doSave(collectionName, objectToSave, this.mongoConverter);
    }

    protected <T> void doSave(String collectionName, T objectToSave, MongoWriter<T> writer) {
        this.assertUpdateableIdIfNotSet(objectToSave);
        BasicDBObject dbDoc = new BasicDBObject();
        this.maybeEmitEvent(new BeforeConvertEvent<T>(objectToSave));
        writer.write(objectToSave, dbDoc);
        this.maybeEmitEvent(new BeforeSaveEvent<T>(objectToSave, (DBObject)dbDoc));
        Object id = this.saveDBObject(collectionName, (DBObject)dbDoc, objectToSave.getClass());
        this.populateIdIfNecessary(objectToSave, id);
        this.maybeEmitEvent(new AfterSaveEvent<T>(objectToSave, (DBObject)dbDoc));
    }

    protected Object insertDBObject(final String collectionName, final DBObject dbDoc, final Class<?> entityClass) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("insert DBObject containing fields: " + dbDoc.keySet() + " in collection: " + collectionName));
        }
        return this.execute(collectionName, new CollectionCallback<Object>(){

            @Override
            public Object doInCollection(DBCollection collection) throws MongoException, DataAccessException {
                MongoAction mongoAction = new MongoAction(MongoTemplate.this.writeConcern, MongoActionOperation.INSERT, collectionName, entityClass, dbDoc, null);
                WriteConcern writeConcernToUse = MongoTemplate.this.prepareWriteConcern(mongoAction);
                WriteResult wr = writeConcernToUse == null ? collection.insert(new DBObject[]{dbDoc}) : collection.insert(dbDoc, writeConcernToUse);
                MongoTemplate.this.handleAnyWriteResultErrors(wr, dbDoc, "insert");
                return dbDoc.get(MongoTemplate.ID);
            }
        });
    }

    protected List<ObjectId> insertDBObjectList(final String collectionName, final List<DBObject> dbDocList) {
        if (dbDocList.isEmpty()) {
            return Collections.emptyList();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("insert list of DBObjects containing " + dbDocList.size() + " items"));
        }
        this.execute(collectionName, new CollectionCallback<Void>(){

            @Override
            public Void doInCollection(DBCollection collection) throws MongoException, DataAccessException {
                MongoAction mongoAction = new MongoAction(MongoTemplate.this.writeConcern, MongoActionOperation.INSERT_LIST, collectionName, null, null, null);
                WriteConcern writeConcernToUse = MongoTemplate.this.prepareWriteConcern(mongoAction);
                WriteResult wr = writeConcernToUse == null ? collection.insert(dbDocList) : collection.insert(dbDocList.toArray((DBObject[])new BasicDBObject[dbDocList.size()]), writeConcernToUse);
                MongoTemplate.this.handleAnyWriteResultErrors(wr, null, "insert_list");
                return null;
            }
        });
        ArrayList<ObjectId> ids = new ArrayList<ObjectId>();
        for (DBObject dbo : dbDocList) {
            Object id = dbo.get(ID);
            if (id instanceof ObjectId) {
                ids.add((ObjectId)id);
                continue;
            }
            ids.add(null);
        }
        return ids;
    }

    protected Object saveDBObject(final String collectionName, final DBObject dbDoc, final Class<?> entityClass) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("save DBObject containing fields: " + dbDoc.keySet()));
        }
        return this.execute(collectionName, new CollectionCallback<Object>(){

            @Override
            public Object doInCollection(DBCollection collection) throws MongoException, DataAccessException {
                MongoAction mongoAction = new MongoAction(MongoTemplate.this.writeConcern, MongoActionOperation.SAVE, collectionName, entityClass, dbDoc, null);
                WriteConcern writeConcernToUse = MongoTemplate.this.prepareWriteConcern(mongoAction);
                WriteResult wr = writeConcernToUse == null ? collection.save(dbDoc) : collection.save(dbDoc, writeConcernToUse);
                MongoTemplate.this.handleAnyWriteResultErrors(wr, dbDoc, "save");
                return dbDoc.get(MongoTemplate.ID);
            }
        });
    }

    @Override
    public WriteResult upsert(Query query, Update update, Class<?> entityClass) {
        return this.doUpdate(this.determineCollectionName(entityClass), query, update, entityClass, true, false);
    }

    @Override
    public WriteResult upsert(Query query, Update update, String collectionName) {
        return this.doUpdate(collectionName, query, update, null, true, false);
    }

    @Override
    public WriteResult updateFirst(Query query, Update update, Class<?> entityClass) {
        return this.doUpdate(this.determineCollectionName(entityClass), query, update, entityClass, false, false);
    }

    @Override
    public WriteResult updateFirst(Query query, Update update, String collectionName) {
        return this.doUpdate(collectionName, query, update, null, false, false);
    }

    @Override
    public WriteResult updateMulti(Query query, Update update, Class<?> entityClass) {
        return this.doUpdate(this.determineCollectionName(entityClass), query, update, entityClass, false, true);
    }

    @Override
    public WriteResult updateMulti(Query query, Update update, String collectionName) {
        return this.doUpdate(collectionName, query, update, null, false, true);
    }

    protected WriteResult doUpdate(final String collectionName, final Query query, final Update update, final Class<?> entityClass, final boolean upsert, final boolean multi) {
        return this.execute(collectionName, new CollectionCallback<WriteResult>(){

            @Override
            public WriteResult doInCollection(DBCollection collection) throws MongoException, DataAccessException {
                MongoAction mongoAction;
                WriteConcern writeConcernToUse;
                MongoPersistentEntity entity = entityClass == null ? null : MongoTemplate.this.getPersistentEntity(entityClass);
                BasicDBObject queryObj = query == null ? new BasicDBObject() : MongoTemplate.this.mapper.getMappedObject(query.getQueryObject(), entity);
                DBObject updateObj = update.getUpdateObject();
                for (String key : updateObj.keySet()) {
                    updateObj.put(key, MongoTemplate.this.mongoConverter.convertToMongoType(updateObj.get(key)));
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("calling update using query: " + queryObj + " and update: " + updateObj + " in collection: " + collectionName));
                }
                WriteResult wr = (writeConcernToUse = MongoTemplate.this.prepareWriteConcern(mongoAction = new MongoAction(MongoTemplate.this.writeConcern, MongoActionOperation.UPDATE, collectionName, entityClass, updateObj, (DBObject)queryObj))) == null ? collection.update((DBObject)queryObj, updateObj, upsert, multi) : collection.update((DBObject)queryObj, updateObj, upsert, multi, writeConcernToUse);
                MongoTemplate.this.handleAnyWriteResultErrors(wr, (DBObject)queryObj, "update with '" + updateObj + "'");
                return wr;
            }
        });
    }

    @Override
    public void remove(Object object) {
        if (object == null) {
            return;
        }
        this.remove(this.getIdQueryFor(object), object.getClass());
    }

    @Override
    public void remove(Object object, String collection) {
        Assert.hasText((String)collection);
        if (object == null) {
            return;
        }
        this.remove(this.getIdQueryFor(object), collection);
    }

    private Query getIdQueryFor(Object object) {
        Assert.notNull((Object)object);
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(object.getClass());
        MongoPersistentProperty idProp = (MongoPersistentProperty)entity.getIdProperty();
        if (idProp == null) {
            throw new MappingException("No id property found for object of type " + entity.getType().getName());
        }
        ConversionService service = this.mongoConverter.getConversionService();
        Object idProperty = null;
        idProperty = BeanWrapper.create((Object)object, (ConversionService)service).getProperty((PersistentProperty)idProp, Object.class, true);
        return new Query(Criteria.where(idProp.getFieldName()).is(idProperty));
    }

    private void assertUpdateableIdIfNotSet(Object entity) {
        MongoPersistentEntity persistentEntity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(entity.getClass());
        MongoPersistentProperty idProperty = (MongoPersistentProperty)persistentEntity.getIdProperty();
        if (idProperty == null) {
            return;
        }
        ConversionService service = this.mongoConverter.getConversionService();
        Object idValue = BeanWrapper.create((Object)entity, (ConversionService)service).getProperty((PersistentProperty)idProperty, Object.class, true);
        if (idValue == null && !MongoSimpleTypes.AUTOGENERATED_ID_TYPES.contains(idProperty.getType())) {
            throw new InvalidDataAccessApiUsageException(String.format("Cannot autogenerate id of type %s for entity of type %s!", idProperty.getType().getName(), entity.getClass().getName()));
        }
    }

    @Override
    public <T> void remove(Query query, Class<T> entityClass) {
        Assert.notNull((Object)query);
        this.doRemove(this.determineCollectionName(entityClass), query, entityClass);
    }

    protected <T> void doRemove(final String collectionName, Query query, final Class<T> entityClass) {
        if (query == null) {
            throw new InvalidDataAccessApiUsageException("Query passed in to remove can't be null");
        }
        final DBObject queryObject = query.getQueryObject();
        final MongoPersistentEntity<?> entity = this.getPersistentEntity(entityClass);
        this.execute(collectionName, new CollectionCallback<Void>(){

            @Override
            public Void doInCollection(DBCollection collection) throws MongoException, DataAccessException {
                DBObject dboq = MongoTemplate.this.mapper.getMappedObject(queryObject, entity);
                WriteResult wr = null;
                MongoAction mongoAction = new MongoAction(MongoTemplate.this.writeConcern, MongoActionOperation.REMOVE, collectionName, entityClass, null, queryObject);
                WriteConcern writeConcernToUse = MongoTemplate.this.prepareWriteConcern(mongoAction);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("remove using query: " + dboq + " in collection: " + collection.getName()));
                }
                wr = writeConcernToUse == null ? collection.remove(dboq) : collection.remove(dboq, writeConcernToUse);
                MongoTemplate.this.handleAnyWriteResultErrors(wr, dboq, "remove");
                return null;
            }
        });
    }

    @Override
    public void remove(Query query, String collectionName) {
        this.doRemove(collectionName, query, null);
    }

    @Override
    public <T> List<T> findAll(Class<T> entityClass) {
        return this.executeFindMultiInternal(new FindCallback(null), null, new ReadDbObjectCallback<Object>(this.mongoConverter, entityClass), this.determineCollectionName(entityClass));
    }

    @Override
    public <T> List<T> findAll(Class<T> entityClass, String collectionName) {
        return this.executeFindMultiInternal(new FindCallback(null), null, new ReadDbObjectCallback<Object>(this.mongoConverter, entityClass), collectionName);
    }

    @Override
    public <T> MapReduceResults<T> mapReduce(String inputCollectionName, String mapFunction, String reduceFunction, Class<T> entityClass) {
        return this.mapReduce(null, inputCollectionName, mapFunction, reduceFunction, new MapReduceOptions().outputTypeInline(), entityClass);
    }

    @Override
    public <T> MapReduceResults<T> mapReduce(String inputCollectionName, String mapFunction, String reduceFunction, MapReduceOptions mapReduceOptions, Class<T> entityClass) {
        return this.mapReduce(null, inputCollectionName, mapFunction, reduceFunction, mapReduceOptions, entityClass);
    }

    @Override
    public <T> MapReduceResults<T> mapReduce(Query query, String inputCollectionName, String mapFunction, String reduceFunction, Class<T> entityClass) {
        return this.mapReduce(query, inputCollectionName, mapFunction, reduceFunction, new MapReduceOptions().outputTypeInline(), entityClass);
    }

    @Override
    public <T> MapReduceResults<T> mapReduce(Query query, String inputCollectionName, String mapFunction, String reduceFunction, MapReduceOptions mapReduceOptions, Class<T> entityClass) {
        String mapFunc = this.replaceWithResourceIfNecessary(mapFunction);
        String reduceFunc = this.replaceWithResourceIfNecessary(reduceFunction);
        DBCollection inputCollection = this.getCollection(inputCollectionName);
        MapReduceCommand command = new MapReduceCommand(inputCollection, mapFunc, reduceFunc, mapReduceOptions.getOutputCollection(), mapReduceOptions.getOutputType(), null);
        DBObject commandObject = this.copyQuery(query, this.copyMapReduceOptions(mapReduceOptions, command));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Executing MapReduce on collection [" + command.getInput() + "], mapFunction [" + mapFunc + "], reduceFunction [" + reduceFunc + "]"));
        }
        CommandResult commandResult = command.getOutputType() == MapReduceCommand.OutputType.INLINE ? this.executeCommand(commandObject, this.getDb().getOptions()) : this.executeCommand(commandObject);
        this.handleCommandError(commandResult, commandObject);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("MapReduce command result = [%s]", SerializationUtils.serializeToJsonSafely(commandObject)));
        }
        MapReduceOutput mapReduceOutput = new MapReduceOutput(inputCollection, commandObject, commandResult);
        ArrayList mappedResults = new ArrayList();
        ReadDbObjectCallback<Object> callback = new ReadDbObjectCallback<Object>(this.mongoConverter, entityClass);
        for (DBObject dbObject : mapReduceOutput.results()) {
            mappedResults.add(callback.doWith(dbObject));
        }
        MapReduceResults mapReduceResult = new MapReduceResults(mappedResults, (DBObject)commandResult);
        return mapReduceResult;
    }

    @Override
    public <T> GroupByResults<T> group(String inputCollectionName, GroupBy groupBy, Class<T> entityClass) {
        return this.group(null, inputCollectionName, groupBy, entityClass);
    }

    @Override
    public <T> GroupByResults<T> group(Criteria criteria, String inputCollectionName, GroupBy groupBy, Class<T> entityClass) {
        Object initialObj;
        DBObject dbo = groupBy.getGroupByObject();
        dbo.put("ns", (Object)inputCollectionName);
        if (criteria == null) {
            dbo.put("cond", null);
        } else {
            dbo.put("cond", (Object)this.mapper.getMappedObject(criteria.getCriteriaObject(), null));
        }
        if (dbo.containsField("initial") && (initialObj = dbo.get("initial")) instanceof String) {
            String initialAsString = this.replaceWithResourceIfNecessary((String)initialObj);
            dbo.put("initial", JSON.parse((String)initialAsString));
        }
        if (dbo.containsField("$reduce")) {
            dbo.put("$reduce", (Object)this.replaceWithResourceIfNecessary(dbo.get("$reduce").toString()));
        }
        if (dbo.containsField("$keyf")) {
            dbo.put("$keyf", (Object)this.replaceWithResourceIfNecessary(dbo.get("$keyf").toString()));
        }
        if (dbo.containsField("finalize")) {
            dbo.put("finalize", (Object)this.replaceWithResourceIfNecessary(dbo.get("finalize").toString()));
        }
        BasicDBObject commandObject = new BasicDBObject("group", (Object)dbo);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("Executing Group with DBObject [%s]", SerializationUtils.serializeToJsonSafely(commandObject)));
        }
        CommandResult commandResult = this.executeCommand((DBObject)commandObject, this.getDb().getOptions());
        this.handleCommandError(commandResult, (DBObject)commandObject);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Group command result = [" + commandResult + "]"));
        }
        Iterable resultSet = (Iterable)commandResult.get("retval");
        ArrayList mappedResults = new ArrayList();
        ReadDbObjectCallback<Object> callback = new ReadDbObjectCallback<Object>(this.mongoConverter, entityClass);
        for (DBObject dbObject : resultSet) {
            mappedResults.add(callback.doWith(dbObject));
        }
        GroupByResults groupByResult = new GroupByResults(mappedResults, (DBObject)commandResult);
        return groupByResult;
    }

    protected String replaceWithResourceIfNecessary(String function) {
        String func = function;
        if (this.resourceLoader != null && ResourceUtils.isUrl((String)function)) {
            Resource functionResource = this.resourceLoader.getResource(func);
            if (!functionResource.exists()) {
                throw new InvalidDataAccessApiUsageException(String.format("Resource %s not found!", function));
            }
            try {
                return new Scanner(functionResource.getInputStream()).useDelimiter("\\A").next();
            }
            catch (IOException e) {
                throw new InvalidDataAccessApiUsageException(String.format("Cannot read map-reduce file %s!", function), (Throwable)e);
            }
        }
        return func;
    }

    private DBObject copyQuery(Query query, DBObject copyMapReduceOptions) {
        if (query != null) {
            if (query.getSkip() != 0 || query.getFieldsObject() != null) {
                throw new InvalidDataAccessApiUsageException("Can not use skip or field specification with map reduce operations");
            }
            if (query.getQueryObject() != null) {
                copyMapReduceOptions.put("query", (Object)query.getQueryObject());
            }
            if (query.getLimit() > 0) {
                copyMapReduceOptions.put("limit", (Object)query.getLimit());
            }
            if (query.getSortObject() != null) {
                copyMapReduceOptions.put("sort", (Object)query.getSortObject());
            }
        }
        return copyMapReduceOptions;
    }

    private DBObject copyMapReduceOptions(MapReduceOptions mapReduceOptions, MapReduceCommand command) {
        if (mapReduceOptions.getJavaScriptMode() != null) {
            command.addExtraOption("jsMode", (Object)true);
        }
        if (!mapReduceOptions.getExtraOptions().isEmpty()) {
            for (Map.Entry<String, Object> entry : mapReduceOptions.getExtraOptions().entrySet()) {
                command.addExtraOption(entry.getKey(), entry.getValue());
            }
        }
        if (mapReduceOptions.getFinalizeFunction() != null) {
            command.setFinalize(this.replaceWithResourceIfNecessary(mapReduceOptions.getFinalizeFunction()));
        }
        if (mapReduceOptions.getOutputDatabase() != null) {
            command.setOutputDB(mapReduceOptions.getOutputDatabase());
        }
        if (!mapReduceOptions.getScopeVariables().isEmpty()) {
            command.setScope(mapReduceOptions.getScopeVariables());
        }
        DBObject commandObject = command.toDBObject();
        DBObject outObject = (DBObject)commandObject.get("out");
        if (mapReduceOptions.getOutputSharded() != null) {
            outObject.put("sharded", (Object)mapReduceOptions.getOutputSharded());
        }
        return commandObject;
    }

    @Override
    public Set<String> getCollectionNames() {
        return this.execute(new DbCallback<Set<String>>(){

            @Override
            public Set<String> doInDB(DB db) throws MongoException, DataAccessException {
                return db.getCollectionNames();
            }
        });
    }

    public DB getDb() {
        return this.mongoDbFactory.getDb();
    }

    protected <T> void maybeEmitEvent(MongoMappingEvent<T> event) {
        if (null != this.eventPublisher) {
            this.eventPublisher.publishEvent(event);
        }
    }

    protected DBCollection doCreateCollection(final String collectionName, final DBObject collectionOptions) {
        return this.execute(new DbCallback<DBCollection>(){

            @Override
            public DBCollection doInDB(DB db) throws MongoException, DataAccessException {
                DBCollection coll = db.createCollection(collectionName, collectionOptions);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Created collection [" + coll.getFullName() + "]"));
                }
                return coll;
            }
        });
    }

    protected <T> T doFindOne(String collectionName, DBObject query, DBObject fields, Class<T> entityClass) {
        MongoConverter readerToUse = this.mongoConverter;
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(entityClass);
        DBObject mappedQuery = this.mapper.getMappedObject(query, entity);
        return (T)this.executeFindOneInternal(new FindOneCallback(mappedQuery, fields), new ReadDbObjectCallback<Object>(readerToUse, entityClass), collectionName);
    }

    protected <T> List<T> doFind(String collectionName, DBObject query, DBObject fields, Class<T> entityClass, CursorPreparer preparer) {
        return this.doFind(collectionName, query, fields, entityClass, preparer, new ReadDbObjectCallback<Object>(this.mongoConverter, entityClass));
    }

    protected <S, T> List<T> doFind(String collectionName, DBObject query, DBObject fields, Class<S> entityClass, CursorPreparer preparer, DbObjectCallback<T> objectCallback) {
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(entityClass);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("find using query: %s fields: %s for class: %s in collection: %s", SerializationUtils.serializeToJsonSafely(query), fields, entityClass, collectionName));
        }
        return this.executeFindMultiInternal(new FindCallback(this.mapper.getMappedObject(query, entity), fields), preparer, objectCallback, collectionName);
    }

    protected <T> List<T> doFind(String collectionName, DBObject query, DBObject fields, Class<T> entityClass) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("find using query: " + query + " fields: " + fields + " for class: " + entityClass + " in collection: " + collectionName));
        }
        MongoConverter readerToUse = this.mongoConverter;
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(entityClass);
        return this.executeFindMultiInternal(new FindCallback(this.mapper.getMappedObject(query, entity), fields), null, new ReadDbObjectCallback<Object>(readerToUse, entityClass), collectionName);
    }

    protected DBObject convertToDbObject(CollectionOptions collectionOptions) {
        BasicDBObject dbo = new BasicDBObject();
        if (collectionOptions != null) {
            if (collectionOptions.getCapped() != null) {
                dbo.put("capped", (Object)collectionOptions.getCapped());
            }
            if (collectionOptions.getSize() != null) {
                dbo.put("size", (Object)collectionOptions.getSize());
            }
            if (collectionOptions.getMaxDocuments() != null) {
                dbo.put("max", (Object)collectionOptions.getMaxDocuments());
            }
        }
        return dbo;
    }

    protected <T> T doFindAndRemove(String collectionName, DBObject query, DBObject fields, DBObject sort, Class<T> entityClass) {
        MongoConverter readerToUse = this.mongoConverter;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("findAndRemove using query: " + query + " fields: " + fields + " sort: " + sort + " for class: " + entityClass + " in collection: " + collectionName));
        }
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(entityClass);
        return (T)this.executeFindOneInternal(new FindAndRemoveCallback(this.mapper.getMappedObject(query, entity), fields, sort), new ReadDbObjectCallback<Object>(readerToUse, entityClass), collectionName);
    }

    protected <T> T doFindAndModify(String collectionName, DBObject query, DBObject fields, DBObject sort, Class<T> entityClass, Update update, FindAndModifyOptions options) {
        MongoConverter readerToUse = this.mongoConverter;
        if (options == null) {
            options = new FindAndModifyOptions();
        }
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(entityClass);
        DBObject updateObj = update.getUpdateObject();
        for (String key : updateObj.keySet()) {
            updateObj.put(key, this.mongoConverter.convertToMongoType(updateObj.get(key)));
        }
        DBObject mappedQuery = this.mapper.getMappedObject(query, entity);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("findAndModify using query: " + mappedQuery + " fields: " + fields + " sort: " + sort + " for class: " + entityClass + " and update: " + updateObj + " in collection: " + collectionName));
        }
        return (T)this.executeFindOneInternal(new FindAndModifyCallback(mappedQuery, fields, sort, updateObj, options), new ReadDbObjectCallback<Object>(readerToUse, entityClass), collectionName);
    }

    protected void populateIdIfNecessary(Object savedObject, Object id) {
        if (id == null) {
            return;
        }
        MongoPersistentProperty idProp = this.getIdPropertyFor(savedObject.getClass());
        if (idProp == null) {
            return;
        }
        ConversionService conversionService = this.mongoConverter.getConversionService();
        BeanWrapper wrapper = BeanWrapper.create((Object)savedObject, (ConversionService)conversionService);
        try {
            Object idValue = wrapper.getProperty((PersistentProperty)idProp, idProp.getType(), true);
            if (idValue != null) {
                return;
            }
            wrapper.setProperty((PersistentProperty)idProp, id);
        }
        catch (IllegalAccessException e) {
            throw new MappingException(e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new MappingException(e.getMessage(), (Throwable)e);
        }
    }

    private DBCollection getAndPrepareCollection(DB db, String collectionName) {
        try {
            DBCollection collection = db.getCollection(collectionName);
            this.prepareCollection(collection);
            return collection;
        }
        catch (RuntimeException e) {
            throw this.potentiallyConvertRuntimeException(e);
        }
    }

    private <T> T executeFindOneInternal(CollectionCallback<DBObject> collectionCallback, DbObjectCallback<T> objectCallback, String collectionName) {
        try {
            T result = objectCallback.doWith(collectionCallback.doInCollection(this.getAndPrepareCollection(this.getDb(), collectionName)));
            return result;
        }
        catch (RuntimeException e) {
            throw this.potentiallyConvertRuntimeException(e);
        }
    }

    private <T> List<T> executeFindMultiInternal(CollectionCallback<DBCursor> collectionCallback, CursorPreparer preparer, DbObjectCallback<T> objectCallback, String collectionName) {
        try {
            DBCursor cursor = collectionCallback.doInCollection(this.getAndPrepareCollection(this.getDb(), collectionName));
            if (preparer != null) {
                cursor = preparer.prepare(cursor);
            }
            ArrayList<T> result = new ArrayList<T>();
            for (DBObject object : cursor) {
                result.add(objectCallback.doWith(object));
            }
            return result;
        }
        catch (RuntimeException e) {
            throw this.potentiallyConvertRuntimeException(e);
        }
    }

    private void executeQueryInternal(CollectionCallback<DBCursor> collectionCallback, CursorPreparer preparer, DocumentCallbackHandler callbackHandler, String collectionName) {
        try {
            DBCursor cursor = collectionCallback.doInCollection(this.getAndPrepareCollection(this.getDb(), collectionName));
            if (preparer != null) {
                cursor = preparer.prepare(cursor);
            }
            for (DBObject dbobject : cursor) {
                callbackHandler.processDocument(dbobject);
            }
        }
        catch (RuntimeException e) {
            throw this.potentiallyConvertRuntimeException(e);
        }
    }

    private MongoPersistentEntity<?> getPersistentEntity(Class<?> type) {
        return type == null ? null : (MongoPersistentEntity)this.mappingContext.getPersistentEntity(type);
    }

    private MongoPersistentProperty getIdPropertyFor(Class<?> type) {
        return (MongoPersistentProperty)((MongoPersistentEntity)this.mappingContext.getPersistentEntity(type)).getIdProperty();
    }

    private <T> String determineEntityCollectionName(T obj) {
        if (null != obj) {
            return this.determineCollectionName(obj.getClass());
        }
        return null;
    }

    String determineCollectionName(Class<?> entityClass) {
        if (entityClass == null) {
            throw new InvalidDataAccessApiUsageException("No class parameter provided, entity collection can't be determined!");
        }
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(entityClass);
        if (entity == null) {
            throw new InvalidDataAccessApiUsageException("No Persitent Entity information found for the class " + entityClass.getName());
        }
        return entity.getCollection();
    }

    protected void handleAnyWriteResultErrors(WriteResult wr, DBObject query, String operation) {
        if (WriteResultChecking.NONE == this.writeResultChecking) {
            return;
        }
        String error = wr.getError();
        if (error != null) {
            String message = operation.equals("insert") || operation.equals("save") ? String.format("Insert/Save for %s failed: %s", query, error) : (operation.equals("insert_list") ? String.format("Insert list failed: %s", error) : String.format("Execution of %s%s failed: %s", operation, query == null ? "" : "' using '" + query.toString() + "' query", error));
            if (WriteResultChecking.EXCEPTION == this.writeResultChecking) {
                throw new DataIntegrityViolationException(message);
            }
            LOGGER.error((Object)message);
            return;
        }
    }

    private RuntimeException potentiallyConvertRuntimeException(RuntimeException ex) {
        DataAccessException resolved = this.exceptionTranslator.translateExceptionIfPossible(ex);
        return resolved == null ? ex : resolved;
    }

    private void handleCommandError(CommandResult result, DBObject source) {
        try {
            result.throwOnError();
        }
        catch (MongoException ex) {
            String error = result.getErrorMessage();
            error = error == null ? "NO MESSAGE" : error;
            throw new InvalidDataAccessApiUsageException("Command execution failed:  Error [" + error + "], Command = " + source, (Throwable)ex);
        }
    }

    private static final MongoConverter getDefaultMongoConverter(MongoDbFactory factory) {
        MappingMongoConverter converter = new MappingMongoConverter(factory, (MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty>)new MongoMappingContext());
        converter.afterPropertiesSet();
        return converter;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class GeoNearResultDbObjectCallback<T>
    implements DbObjectCallback<GeoResult<T>> {
        private final DbObjectCallback<T> delegate;
        private final Metric metric;

        public GeoNearResultDbObjectCallback(DbObjectCallback<T> delegate, Metric metric) {
            Assert.notNull(delegate);
            this.delegate = delegate;
            this.metric = metric;
        }

        @Override
        public GeoResult<T> doWith(DBObject object) {
            double distance = (Double)object.get("dis");
            DBObject content = (DBObject)object.get("obj");
            T doWith = this.delegate.doWith(content);
            return new GeoResult<T>(doWith, new Distance(distance, this.metric));
        }
    }

    class QueryCursorPreparer
    implements CursorPreparer {
        private final Query query;

        public QueryCursorPreparer(Query query) {
            this.query = query;
        }

        public DBCursor prepare(DBCursor cursor) {
            if (this.query == null) {
                return cursor;
            }
            if (this.query.getSkip() <= 0 && this.query.getLimit() <= 0 && this.query.getSortObject() == null && !StringUtils.hasText((String)this.query.getHint())) {
                return cursor;
            }
            DBCursor cursorToUse = cursor;
            try {
                if (this.query.getSkip() > 0) {
                    cursorToUse = cursorToUse.skip(this.query.getSkip());
                }
                if (this.query.getLimit() > 0) {
                    cursorToUse = cursorToUse.limit(this.query.getLimit());
                }
                if (this.query.getSortObject() != null) {
                    cursorToUse = cursorToUse.sort(this.query.getSortObject());
                }
                if (StringUtils.hasText((String)this.query.getHint())) {
                    cursorToUse = cursorToUse.hint(this.query.getHint());
                }
            }
            catch (RuntimeException e) {
                throw MongoTemplate.this.potentiallyConvertRuntimeException(e);
            }
            return cursorToUse;
        }
    }

    private class DefaultWriteConcernResolver
    implements WriteConcernResolver {
        private DefaultWriteConcernResolver() {
        }

        public WriteConcern resolve(MongoAction action) {
            return action.getDefaultWriteConcern();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReadDbObjectCallback<T>
    implements DbObjectCallback<T> {
        private final EntityReader<? super T, DBObject> reader;
        private final Class<T> type;

        public ReadDbObjectCallback(EntityReader<? super T, DBObject> reader, Class<T> type) {
            Assert.notNull(reader);
            Assert.notNull(type);
            this.reader = reader;
            this.type = type;
        }

        @Override
        public T doWith(DBObject object) {
            Object source;
            if (null != object) {
                MongoTemplate.this.maybeEmitEvent(new AfterLoadEvent<T>(object, this.type));
            }
            if (null != (source = this.reader.read(this.type, (Object)object))) {
                MongoTemplate.this.maybeEmitEvent(new AfterConvertEvent<Object>(object, source));
            }
            return (T)source;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface DbObjectCallback<T> {
        public T doWith(DBObject var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FindAndModifyCallback
    implements CollectionCallback<DBObject> {
        private final DBObject query;
        private final DBObject fields;
        private final DBObject sort;
        private final DBObject update;
        private final FindAndModifyOptions options;

        public FindAndModifyCallback(DBObject query, DBObject fields, DBObject sort, DBObject update, FindAndModifyOptions options) {
            this.query = query;
            this.fields = fields;
            this.sort = sort;
            this.update = update;
            this.options = options;
        }

        @Override
        public DBObject doInCollection(DBCollection collection) throws MongoException, DataAccessException {
            return collection.findAndModify(this.query, this.fields, this.sort, this.options.isRemove(), this.update, this.options.isReturnNew(), this.options.isUpsert());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FindAndRemoveCallback
    implements CollectionCallback<DBObject> {
        private final DBObject query;
        private final DBObject fields;
        private final DBObject sort;

        public FindAndRemoveCallback(DBObject query, DBObject fields, DBObject sort) {
            this.query = query;
            this.fields = fields;
            this.sort = sort;
        }

        @Override
        public DBObject doInCollection(DBCollection collection) throws MongoException, DataAccessException {
            return collection.findAndModify(this.query, this.fields, this.sort, true, null, false, false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FindCallback
    implements CollectionCallback<DBCursor> {
        private final DBObject query;
        private final DBObject fields;

        public FindCallback(DBObject query) {
            this(query, null);
        }

        public FindCallback(DBObject query, DBObject fields) {
            this.query = query;
            this.fields = fields;
        }

        @Override
        public DBCursor doInCollection(DBCollection collection) throws MongoException, DataAccessException {
            if (this.fields == null) {
                return collection.find(this.query);
            }
            return collection.find(this.query, this.fields);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FindOneCallback
    implements CollectionCallback<DBObject> {
        private final DBObject query;
        private final DBObject fields;

        public FindOneCallback(DBObject query, DBObject fields) {
            this.query = query;
            this.fields = fields;
        }

        @Override
        public DBObject doInCollection(DBCollection collection) throws MongoException, DataAccessException {
            if (this.fields == null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("findOne using query: " + this.query + " in db.collection: " + collection.getFullName()));
                }
                return collection.findOne(this.query);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("findOne using query: " + this.query + " fields: " + this.fields + " in db.collection: " + collection.getFullName()));
            }
            return collection.findOne(this.query, this.fields);
        }
    }
}

