/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.query;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.ObjectUtils;

public class Field {
    private final Map<String, Integer> criteria = new HashMap<String, Integer>();
    private final Map<String, Object> slices = new HashMap<String, Object>();

    public Field include(String key) {
        this.criteria.put(key, 1);
        return this;
    }

    public Field exclude(String key) {
        this.criteria.put(key, 0);
        return this;
    }

    public Field slice(String key, int size) {
        this.slices.put(key, size);
        return this;
    }

    public Field slice(String key, int offset, int size) {
        this.slices.put(key, new Integer[]{offset, size});
        return this;
    }

    public DBObject getFieldsObject() {
        BasicDBObject dbo = new BasicDBObject();
        for (String k : this.criteria.keySet()) {
            dbo.put(k, (Object)this.criteria.get(k));
        }
        for (String k : this.slices.keySet()) {
            dbo.put(k, (Object)new BasicDBObject("$slice", this.slices.get(k)));
        }
        return dbo;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Field)) {
            return false;
        }
        Field that = (Field)object;
        if (!((Object)this.criteria).equals(that.criteria)) {
            return false;
        }
        return ((Object)this.slices).equals(that.slices);
    }

    public int hashCode() {
        int result = 17;
        result += 31 * ObjectUtils.nullSafeHashCode(this.criteria);
        return result += 31 * ObjectUtils.nullSafeHashCode(this.slices);
    }
}

