/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.bson.BSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConversionException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.ConversionServiceFactory;
import org.springframework.data.convert.EntityInstantiator;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.AssociationHandler;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.BeanWrapper;
import org.springframework.data.mapping.model.DefaultSpELExpressionEvaluator;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.mapping.model.PersistentEntityParameterValueProvider;
import org.springframework.data.mapping.model.PropertyValueProvider;
import org.springframework.data.mapping.model.SpELContext;
import org.springframework.data.mapping.model.SpELExpressionEvaluator;
import org.springframework.data.mapping.model.SpELExpressionParameterValueProvider;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.convert.AbstractMongoConverter;
import org.springframework.data.mongodb.core.convert.DBObjectAccessor;
import org.springframework.data.mongodb.core.convert.DBObjectPropertyAccessor;
import org.springframework.data.mongodb.core.convert.DbRefResolver;
import org.springframework.data.mongodb.core.convert.DbRefResolverCallback;
import org.springframework.data.mongodb.core.convert.DefaultDbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultMongoTypeMapper;
import org.springframework.data.mongodb.core.convert.MongoTypeMapper;
import org.springframework.data.mongodb.core.convert.QueryMapper;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class MappingMongoConverter
extends AbstractMongoConverter
implements ApplicationContextAware {
    protected static final Logger LOGGER = LoggerFactory.getLogger(MappingMongoConverter.class);
    protected final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;
    protected final SpelExpressionParser spelExpressionParser = new SpelExpressionParser();
    protected final QueryMapper idMapper;
    protected final DbRefResolver dbRefResolver;
    protected ApplicationContext applicationContext;
    protected boolean useFieldAccessOnly = true;
    protected MongoTypeMapper typeMapper;
    protected String mapKeyDotReplacement = null;
    private SpELContext spELContext;

    public MappingMongoConverter(DbRefResolver dbRefResolver, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
        super(ConversionServiceFactory.createDefaultConversionService());
        Assert.notNull((Object)dbRefResolver, (String)"DbRefResolver must not be null!");
        Assert.notNull(mappingContext, (String)"MappingContext must not be null!");
        this.dbRefResolver = dbRefResolver;
        this.mappingContext = mappingContext;
        this.typeMapper = new DefaultMongoTypeMapper("_class", mappingContext);
        this.idMapper = new QueryMapper(this);
        this.spELContext = new SpELContext((PropertyAccessor)DBObjectPropertyAccessor.INSTANCE);
    }

    @Deprecated
    public MappingMongoConverter(MongoDbFactory mongoDbFactory, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
        this(new DefaultDbRefResolver(mongoDbFactory), mappingContext);
    }

    public void setTypeMapper(MongoTypeMapper typeMapper) {
        this.typeMapper = typeMapper == null ? new DefaultMongoTypeMapper("_class", this.mappingContext) : typeMapper;
    }

    @Override
    public MongoTypeMapper getTypeMapper() {
        return this.typeMapper;
    }

    public void setMapKeyDotReplacement(String mapKeyDotReplacement) {
        this.mapKeyDotReplacement = mapKeyDotReplacement;
    }

    public MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> getMappingContext() {
        return this.mappingContext;
    }

    public void setUseFieldAccessOnly(boolean useFieldAccessOnly) {
        this.useFieldAccessOnly = useFieldAccessOnly;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        this.spELContext = new SpELContext(this.spELContext, (BeanFactory)applicationContext);
    }

    public <S> S read(Class<S> clazz, DBObject dbo) {
        return this.read(ClassTypeInformation.from(clazz), dbo);
    }

    protected <S> S read(TypeInformation<S> type, DBObject dbo) {
        return this.read(type, dbo, null);
    }

    protected <S> S read(TypeInformation<S> type, DBObject dbo, Object parent) {
        if (null == dbo) {
            return null;
        }
        TypeInformation typeToUse = this.typeMapper.readType(dbo, type);
        Class rawType = typeToUse.getType();
        if (this.conversions.hasCustomReadTarget(dbo.getClass(), rawType)) {
            return (S)this.conversionService.convert((Object)dbo, rawType);
        }
        if (DBObject.class.isAssignableFrom(rawType)) {
            return (S)dbo;
        }
        if (typeToUse.isCollectionLike() && dbo instanceof BasicDBList) {
            return (S)this.readCollectionOrArray(typeToUse, (BasicDBList)dbo, parent);
        }
        if (typeToUse.isMap()) {
            return (S)this.readMap(typeToUse, dbo, parent);
        }
        MongoPersistentEntity persistentEntity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(typeToUse);
        if (persistentEntity == null) {
            throw new MappingException("No mapping metadata found for " + rawType.getName());
        }
        return this.read(persistentEntity, dbo, parent);
    }

    private ParameterValueProvider<MongoPersistentProperty> getParameterProvider(MongoPersistentEntity<?> entity, DBObject source, DefaultSpELExpressionEvaluator evaluator, Object parent) {
        MongoDbPropertyValueProvider provider = new MongoDbPropertyValueProvider(source, evaluator, parent);
        PersistentEntityParameterValueProvider parameterProvider = new PersistentEntityParameterValueProvider(entity, (PropertyValueProvider)provider, parent);
        return new ConverterAwareSpELExpressionParameterValueProvider((SpELExpressionEvaluator)evaluator, (ConversionService)this.conversionService, (ParameterValueProvider<MongoPersistentProperty>)parameterProvider, parent);
    }

    private <S> S read(final MongoPersistentEntity<S> entity, final DBObject dbo, final Object parent) {
        final DefaultSpELExpressionEvaluator evaluator = new DefaultSpELExpressionEvaluator((Object)dbo, this.spELContext);
        ParameterValueProvider<MongoPersistentProperty> provider = this.getParameterProvider(entity, dbo, evaluator, parent);
        EntityInstantiator instantiator = this.instantiators.getInstantiatorFor(entity);
        Object instance = instantiator.createInstance(entity, provider);
        final BeanWrapper wrapper = BeanWrapper.create((Object)instance, (ConversionService)this.conversionService);
        final Object result = wrapper.getBean();
        entity.doWithProperties((PropertyHandler)new PropertyHandler<MongoPersistentProperty>(){

            public void doWithPersistentProperty(MongoPersistentProperty prop) {
                if (!dbo.containsField(prop.getFieldName()) || entity.isConstructorArgument(prop)) {
                    return;
                }
                Object obj = MappingMongoConverter.this.getValueInternal(prop, dbo, (SpELExpressionEvaluator)evaluator, result);
                wrapper.setProperty((PersistentProperty)prop, obj, MappingMongoConverter.this.useFieldAccessOnly);
            }
        });
        entity.doWithAssociations((AssociationHandler)new AssociationHandler<MongoPersistentProperty>(){

            public void doWithAssociation(Association<MongoPersistentProperty> association) {
                MongoPersistentProperty inverseProp = (MongoPersistentProperty)association.getInverse();
                Object obj = MappingMongoConverter.this.dbRefResolver.resolveDbRef(inverseProp, new DbRefResolverCallback(){

                    @Override
                    public Object resolve(MongoPersistentProperty property) {
                        return MappingMongoConverter.this.getValueInternal(property, dbo, (SpELExpressionEvaluator)evaluator, parent);
                    }
                });
                wrapper.setProperty((PersistentProperty)inverseProp, obj);
            }
        });
        return (S)result;
    }

    @Override
    public com.mongodb.DBRef toDBRef(Object object, MongoPersistentProperty referingProperty) {
        DBRef annotation = null;
        if (referingProperty != null) {
            annotation = referingProperty.getDBRef();
            Assert.isTrue((annotation != null ? 1 : 0) != 0, (String)"The referenced property has to be mapped with @DBRef!");
        }
        return this.createDBRef(object, referingProperty);
    }

    public void write(Object obj, DBObject dbo) {
        if (null == obj) {
            return;
        }
        boolean handledByCustomConverter = this.conversions.getCustomWriteTarget(obj.getClass(), DBObject.class) != null;
        TypeInformation type = ClassTypeInformation.from(obj.getClass());
        if (!handledByCustomConverter && !(dbo instanceof BasicDBList)) {
            this.typeMapper.writeType(type, dbo);
        }
        this.writeInternal(obj, dbo, type);
    }

    protected void writeInternal(Object obj, DBObject dbo, TypeInformation<?> typeHint) {
        if (null == obj) {
            return;
        }
        Class<?> customTarget = this.conversions.getCustomWriteTarget(obj.getClass(), DBObject.class);
        if (customTarget != null) {
            DBObject result = (DBObject)this.conversionService.convert(obj, DBObject.class);
            dbo.putAll((BSONObject)result);
            return;
        }
        if (Map.class.isAssignableFrom(obj.getClass())) {
            this.writeMapInternal((Map)obj, dbo, ClassTypeInformation.MAP);
            return;
        }
        if (Collection.class.isAssignableFrom(obj.getClass())) {
            this.writeCollectionInternal((Collection)obj, ClassTypeInformation.LIST, (BasicDBList)dbo);
            return;
        }
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(obj.getClass());
        this.writeInternal(obj, dbo, entity);
        this.addCustomTypeKeyIfNecessary(typeHint, obj, dbo);
    }

    protected void writeInternal(Object obj, final DBObject dbo, MongoPersistentEntity<?> entity) {
        if (obj == null) {
            return;
        }
        if (null == entity) {
            throw new MappingException("No mapping metadata found for entity of type " + obj.getClass().getName());
        }
        final BeanWrapper wrapper = BeanWrapper.create((Object)obj, (ConversionService)this.conversionService);
        final MongoPersistentProperty idProperty = (MongoPersistentProperty)entity.getIdProperty();
        if (!dbo.containsField("_id") && null != idProperty) {
            boolean fieldAccessOnly = idProperty.usePropertyAccess() ? false : this.useFieldAccessOnly;
            try {
                Object id = wrapper.getProperty((PersistentProperty)idProperty, Object.class, fieldAccessOnly);
                dbo.put("_id", this.idMapper.convertId(id));
            }
            catch (ConversionException ignored) {
                // empty catch block
            }
        }
        entity.doWithProperties((PropertyHandler)new PropertyHandler<MongoPersistentProperty>(){

            public void doWithPersistentProperty(MongoPersistentProperty prop) {
                if (prop.equals(idProperty)) {
                    return;
                }
                boolean fieldAccessOnly = prop.usePropertyAccess() ? false : MappingMongoConverter.this.useFieldAccessOnly;
                Object propertyObj = wrapper.getProperty((PersistentProperty)prop, prop.getType(), fieldAccessOnly);
                if (null != propertyObj) {
                    if (!MappingMongoConverter.this.conversions.isSimpleType(propertyObj.getClass())) {
                        MappingMongoConverter.this.writePropertyInternal(propertyObj, dbo, prop);
                    } else {
                        MappingMongoConverter.this.writeSimpleInternal(propertyObj, dbo, prop);
                    }
                }
            }
        });
        entity.doWithAssociations((AssociationHandler)new AssociationHandler<MongoPersistentProperty>(){

            public void doWithAssociation(Association<MongoPersistentProperty> association) {
                Class type;
                MongoPersistentProperty inverseProp = (MongoPersistentProperty)association.getInverse();
                Object propertyObj = wrapper.getProperty((PersistentProperty)inverseProp, type = inverseProp.getType(), MappingMongoConverter.this.useFieldAccessOnly);
                if (null != propertyObj) {
                    MappingMongoConverter.this.writePropertyInternal(propertyObj, dbo, inverseProp);
                }
            }
        });
    }

    protected void writePropertyInternal(Object obj, DBObject dbo, MongoPersistentProperty prop) {
        com.mongodb.DBRef dbRefObj;
        if (obj == null) {
            return;
        }
        DBObjectAccessor accessor = new DBObjectAccessor(dbo);
        TypeInformation valueType = ClassTypeInformation.from(obj.getClass());
        TypeInformation type = prop.getTypeInformation();
        if (valueType.isCollectionLike()) {
            DBObject collectionInternal = this.createCollection(MappingMongoConverter.asCollection(obj), prop);
            accessor.put(prop, collectionInternal);
            return;
        }
        if (valueType.isMap()) {
            DBObject mapDbObj = this.createMap((Map)obj, prop);
            accessor.put(prop, mapDbObj);
            return;
        }
        if (prop.isDbReference() && null != (dbRefObj = this.createDBRef(obj, prop))) {
            accessor.put(prop, dbRefObj);
            return;
        }
        Class<?> basicTargetType = this.conversions.getCustomWriteTarget(obj.getClass(), null);
        if (basicTargetType != null) {
            accessor.put(prop, this.conversionService.convert(obj, basicTargetType));
            return;
        }
        Object existingValue = accessor.get(prop);
        BasicDBObject propDbObj = existingValue instanceof BasicDBObject ? (BasicDBObject)existingValue : new BasicDBObject();
        this.addCustomTypeKeyIfNecessary(type, obj, (DBObject)propDbObj);
        MongoPersistentEntity entity = this.isSubtype(prop.getType(), obj.getClass()) ? (MongoPersistentEntity)this.mappingContext.getPersistentEntity(obj.getClass()) : (MongoPersistentEntity)this.mappingContext.getPersistentEntity(type);
        this.writeInternal(obj, (DBObject)propDbObj, entity);
        accessor.put(prop, propDbObj);
    }

    private boolean isSubtype(Class<?> left, Class<?> right) {
        return left.isAssignableFrom(right) && !left.equals(right);
    }

    private static Collection<?> asCollection(Object source) {
        if (source instanceof Collection) {
            return (Collection)source;
        }
        return source.getClass().isArray() ? CollectionUtils.arrayToList((Object)source) : Collections.singleton(source);
    }

    protected DBObject createCollection(Collection<?> collection, MongoPersistentProperty property) {
        if (!property.isDbReference()) {
            return this.writeCollectionInternal(collection, property.getTypeInformation(), new BasicDBList());
        }
        BasicDBList dbList = new BasicDBList();
        for (Object element : collection) {
            if (element == null) continue;
            com.mongodb.DBRef dbRef = this.createDBRef(element, property);
            dbList.add((Object)dbRef);
        }
        return dbList;
    }

    protected DBObject createMap(Map<Object, Object> map, MongoPersistentProperty property) {
        Assert.notNull(map, (String)"Given map must not be null!");
        Assert.notNull((Object)property, (String)"PersistentProperty must not be null!");
        if (!property.isDbReference()) {
            return this.writeMapInternal(map, (DBObject)new BasicDBObject(), property.getTypeInformation());
        }
        BasicDBObject dbObject = new BasicDBObject();
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (this.conversions.isSimpleType(key.getClass())) {
                String simpleKey = this.potentiallyEscapeMapKey(key.toString());
                dbObject.put(simpleKey, value != null ? this.createDBRef(value, property) : null);
                continue;
            }
            throw new MappingException("Cannot use a complex object as a key value.");
        }
        return dbObject;
    }

    private BasicDBList writeCollectionInternal(Collection<?> source, TypeInformation<?> type, BasicDBList sink) {
        TypeInformation componentType = type == null ? null : type.getComponentType();
        for (Object element : source) {
            Class<?> elementType;
            Class<?> clazz = elementType = element == null ? null : element.getClass();
            if (elementType == null || this.conversions.isSimpleType(elementType)) {
                sink.add(this.getPotentiallyConvertedSimpleWrite(element));
                continue;
            }
            if (element instanceof Collection || elementType.isArray()) {
                sink.add((Object)this.writeCollectionInternal(MappingMongoConverter.asCollection(element), componentType, new BasicDBList()));
                continue;
            }
            BasicDBObject propDbObj = new BasicDBObject();
            this.writeInternal(element, (DBObject)propDbObj, componentType);
            sink.add((Object)propDbObj);
        }
        return sink;
    }

    protected DBObject writeMapInternal(Map<Object, Object> obj, DBObject dbo, TypeInformation<?> propertyType) {
        for (Map.Entry<Object, Object> entry : obj.entrySet()) {
            Object key = entry.getKey();
            Object val = entry.getValue();
            if (this.conversions.isSimpleType(key.getClass())) {
                String simpleKey = this.potentiallyEscapeMapKey(key.toString());
                if (val == null || this.conversions.isSimpleType(val.getClass())) {
                    this.writeSimpleInternal(val, dbo, simpleKey);
                    continue;
                }
                if (val instanceof Collection || val.getClass().isArray()) {
                    dbo.put(simpleKey, (Object)this.writeCollectionInternal(MappingMongoConverter.asCollection(val), propertyType.getMapValueType(), new BasicDBList()));
                    continue;
                }
                BasicDBObject newDbo = new BasicDBObject();
                TypeInformation valueTypeInfo = propertyType.isMap() ? propertyType.getMapValueType() : ClassTypeInformation.OBJECT;
                this.writeInternal(val, (DBObject)newDbo, valueTypeInfo);
                dbo.put(simpleKey, (Object)newDbo);
                continue;
            }
            throw new MappingException("Cannot use a complex object as a key value.");
        }
        return dbo;
    }

    protected String potentiallyEscapeMapKey(String source) {
        if (!source.contains(".")) {
            return source;
        }
        if (this.mapKeyDotReplacement == null) {
            throw new MappingException(String.format("Map key %s contains dots but no replacement was configured! Make sure map keys don't contain dots in the first place or configure an appropriate replacement!", source));
        }
        return source.replaceAll("\\.", this.mapKeyDotReplacement);
    }

    protected String potentiallyUnescapeMapKey(String source) {
        return this.mapKeyDotReplacement == null ? source : source.replaceAll(this.mapKeyDotReplacement, "\\.");
    }

    protected void addCustomTypeKeyIfNecessary(TypeInformation<?> type, Object value, DBObject dbObject) {
        boolean notTheSameClass;
        TypeInformation actualType = type != null ? type.getActualType() : null;
        Class reference = actualType == null ? Object.class : actualType.getType();
        boolean bl = notTheSameClass = !value.getClass().equals(reference);
        if (notTheSameClass) {
            this.typeMapper.writeType(value.getClass(), dbObject);
        }
    }

    private void writeSimpleInternal(Object value, DBObject dbObject, String key) {
        dbObject.put(key, this.getPotentiallyConvertedSimpleWrite(value));
    }

    private void writeSimpleInternal(Object value, DBObject dbObject, MongoPersistentProperty property) {
        DBObjectAccessor accessor = new DBObjectAccessor(dbObject);
        accessor.put(property, this.getPotentiallyConvertedSimpleWrite(value));
    }

    private Object getPotentiallyConvertedSimpleWrite(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> customTarget = this.conversions.getCustomWriteTarget(value.getClass(), null);
        if (customTarget != null) {
            return this.conversionService.convert(value, customTarget);
        }
        return Enum.class.isAssignableFrom(value.getClass()) ? ((Enum)value).name() : value;
    }

    private Object getPotentiallyConvertedSimpleRead(Object value, Class<?> target) {
        if (value == null || target == null) {
            return value;
        }
        if (this.conversions.hasCustomReadTarget(value.getClass(), target)) {
            return this.conversionService.convert(value, target);
        }
        if (Enum.class.isAssignableFrom(target)) {
            return Enum.valueOf(target, value.toString());
        }
        return target.isAssignableFrom(value.getClass()) ? value : this.conversionService.convert(value, target);
    }

    protected com.mongodb.DBRef createDBRef(Object target, MongoPersistentProperty property) {
        Assert.notNull((Object)target);
        if (target instanceof com.mongodb.DBRef) {
            return (com.mongodb.DBRef)target;
        }
        MongoPersistentEntity targetEntity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(target.getClass());
        MongoPersistentEntity mongoPersistentEntity = targetEntity = targetEntity == null ? (targetEntity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity((PersistentProperty)property)) : targetEntity;
        if (null == targetEntity) {
            throw new MappingException("No mapping metadata found for " + target.getClass());
        }
        MongoPersistentProperty idProperty = (MongoPersistentProperty)targetEntity.getIdProperty();
        if (idProperty == null) {
            throw new MappingException("No id property found on class " + targetEntity.getType());
        }
        Object id = null;
        if (target.getClass().equals(idProperty.getType())) {
            id = target;
        } else {
            BeanWrapper wrapper = BeanWrapper.create((Object)target, (ConversionService)this.conversionService);
            id = wrapper.getProperty((PersistentProperty)idProperty, Object.class, this.useFieldAccessOnly);
        }
        if (null == id) {
            throw new MappingException("Cannot create a reference to an object with a NULL id.");
        }
        return this.dbRefResolver.createDbRef(property == null ? null : property.getDBRef(), targetEntity, this.idMapper.convertId(id));
    }

    protected Object getValueInternal(MongoPersistentProperty prop, DBObject dbo, SpELExpressionEvaluator eval, Object parent) {
        MongoDbPropertyValueProvider provider = new MongoDbPropertyValueProvider(dbo, this.spELContext, parent);
        return provider.getPropertyValue(prop);
    }

    private Object readCollectionOrArray(TypeInformation<?> targetType, BasicDBList sourceValue, Object parent) {
        Collection<Object> items;
        Class rawComponentType;
        Assert.notNull(targetType);
        Class<List> collectionType = targetType.getType();
        if (sourceValue.isEmpty()) {
            return this.getPotentiallyConvertedSimpleRead(new HashSet(), collectionType);
        }
        collectionType = Collection.class.isAssignableFrom(collectionType) ? collectionType : List.class;
        TypeInformation componentType = targetType.getComponentType();
        Class clazz = rawComponentType = componentType == null ? null : componentType.getType();
        if (targetType.getType().isArray()) {
            items = new ArrayList();
        } else if (EnumSet.class.isAssignableFrom(collectionType)) {
            Assert.notNull((Object)rawComponentType, (String)"Component type must not be null for enum sets!");
            items = EnumSet.noneOf(rawComponentType.asSubclass(Enum.class));
        } else {
            items = CollectionFactory.createCollection(collectionType, (int)sourceValue.size());
        }
        for (int i = 0; i < sourceValue.size(); ++i) {
            Object dbObjItem = sourceValue.get(i);
            if (dbObjItem instanceof com.mongodb.DBRef) {
                items.add(com.mongodb.DBRef.class.equals((Object)rawComponentType) ? dbObjItem : this.read(componentType, this.readRef((com.mongodb.DBRef)dbObjItem), parent));
                continue;
            }
            if (dbObjItem instanceof DBObject) {
                items.add(this.read(componentType, (DBObject)dbObjItem, parent));
                continue;
            }
            items.add(this.getPotentiallyConvertedSimpleRead(dbObjItem, rawComponentType));
        }
        return this.getPotentiallyConvertedSimpleRead(items, targetType.getType());
    }

    protected Map<Object, Object> readMap(TypeInformation<?> type, DBObject dbObject, Object parent) {
        EnumMap<Object, Object> map;
        Class rawValueType;
        Assert.notNull((Object)dbObject);
        Class mapType = this.typeMapper.readType(dbObject, type).getType();
        TypeInformation keyType = type.getComponentType();
        Class rawKeyType = keyType == null ? null : keyType.getType();
        TypeInformation valueType = type.getMapValueType();
        Class clazz = rawValueType = valueType == null ? null : valueType.getType();
        if (EnumMap.class.isAssignableFrom(mapType)) {
            Assert.notNull((Object)keyType, (String)"Key type must nut be null for enum maps!");
            map = new EnumMap<Object, Object>(rawKeyType.asSubclass(Enum.class));
        } else {
            map = CollectionFactory.createMap((Class)mapType, (int)dbObject.keySet().size());
        }
        Map sourceMap = dbObject.toMap();
        for (Map.Entry entry : sourceMap.entrySet()) {
            Object value;
            if (this.typeMapper.isTypeKey((String)entry.getKey())) continue;
            Object key = this.potentiallyUnescapeMapKey((String)entry.getKey());
            if (rawKeyType != null) {
                key = this.conversionService.convert(key, rawKeyType);
            }
            if ((value = entry.getValue()) instanceof DBObject) {
                map.put(key, this.read(valueType, (DBObject)value, parent));
                continue;
            }
            if (value instanceof com.mongodb.DBRef) {
                map.put(key, com.mongodb.DBRef.class.equals((Object)rawValueType) ? value : this.read(valueType, this.readRef((com.mongodb.DBRef)value)));
                continue;
            }
            Class valueClass = valueType == null ? null : valueType.getType();
            map.put(key, this.getPotentiallyConvertedSimpleRead(value, valueClass));
        }
        return map;
    }

    protected <T> List<?> unwrapList(BasicDBList dbList, TypeInformation<T> targetType) {
        ArrayList<Object> rootList = new ArrayList<Object>();
        for (int i = 0; i < dbList.size(); ++i) {
            Object obj = dbList.get(i);
            if (obj instanceof BasicDBList) {
                rootList.add(this.unwrapList((BasicDBList)obj, targetType.getComponentType()));
                continue;
            }
            if (obj instanceof DBObject) {
                rootList.add(this.read(targetType, (DBObject)obj));
                continue;
            }
            rootList.add(obj);
        }
        return rootList;
    }

    @Override
    public Object convertToMongoType(Object obj, TypeInformation<?> typeInformation) {
        TypeInformation typeHint;
        if (obj == null) {
            return null;
        }
        Class<?> target = this.conversions.getCustomWriteTarget(obj.getClass());
        if (target != null) {
            return this.conversionService.convert(obj, target);
        }
        if (this.conversions.isSimpleType(obj.getClass())) {
            return this.getPotentiallyConvertedSimpleWrite(obj);
        }
        TypeInformation typeInformation2 = typeHint = typeInformation == null ? null : ClassTypeInformation.OBJECT;
        if (obj instanceof BasicDBList) {
            return this.maybeConvertList((Iterable<?>)((BasicDBList)obj), (TypeInformation<?>)typeHint);
        }
        if (obj instanceof DBObject) {
            BasicDBObject newValueDbo = new BasicDBObject();
            for (String vk : ((DBObject)obj).keySet()) {
                Object o = ((DBObject)obj).get(vk);
                newValueDbo.put(vk, this.convertToMongoType(o, typeHint));
            }
            return newValueDbo;
        }
        if (obj instanceof Map) {
            BasicDBObject result = new BasicDBObject();
            for (Map.Entry entry : ((Map)obj).entrySet()) {
                result.put(entry.getKey().toString(), this.convertToMongoType(entry.getValue(), typeHint));
            }
            return result;
        }
        if (obj.getClass().isArray()) {
            return this.maybeConvertList(Arrays.asList((Object[])obj), typeHint);
        }
        if (obj instanceof Collection) {
            return this.maybeConvertList((Collection)obj, typeHint);
        }
        BasicDBObject newDbo = new BasicDBObject();
        this.write(obj, (DBObject)newDbo);
        if (typeInformation == null) {
            return this.removeTypeInfoRecursively(newDbo);
        }
        return !obj.getClass().equals(typeInformation.getType()) ? newDbo : this.removeTypeInfoRecursively(newDbo);
    }

    public BasicDBList maybeConvertList(Iterable<?> source, TypeInformation<?> typeInformation) {
        BasicDBList newDbl = new BasicDBList();
        for (Object element : source) {
            newDbl.add(this.convertToMongoType(element, typeInformation));
        }
        return newDbl;
    }

    private Object removeTypeInfoRecursively(Object object) {
        if (!(object instanceof DBObject)) {
            return object;
        }
        DBObject dbObject = (DBObject)object;
        String keyToRemove = null;
        for (String key : dbObject.keySet()) {
            Object value;
            if (this.typeMapper.isTypeKey(key)) {
                keyToRemove = key;
            }
            if ((value = dbObject.get(key)) instanceof BasicDBList) {
                for (Object element : (BasicDBList)value) {
                    this.removeTypeInfoRecursively(element);
                }
                continue;
            }
            this.removeTypeInfoRecursively(value);
        }
        if (keyToRemove != null) {
            dbObject.removeField(keyToRemove);
        }
        return dbObject;
    }

    private <T> T readValue(Object value, TypeInformation<?> type, Object parent) {
        Class rawType = type.getType();
        if (this.conversions.hasCustomReadTarget(value.getClass(), rawType)) {
            return (T)this.conversionService.convert(value, rawType);
        }
        if (value instanceof com.mongodb.DBRef) {
            return (T)(rawType.equals(com.mongodb.DBRef.class) ? value : this.read(type, this.readRef((com.mongodb.DBRef)value), parent));
        }
        if (value instanceof BasicDBList) {
            return (T)this.readCollectionOrArray(type, (BasicDBList)value, parent);
        }
        if (value instanceof DBObject) {
            return (T)this.read(type, (DBObject)value, parent);
        }
        return (T)this.getPotentiallyConvertedSimpleRead(value, rawType);
    }

    DBObject readRef(com.mongodb.DBRef ref) {
        return ref.fetch();
    }

    private class ConverterAwareSpELExpressionParameterValueProvider
    extends SpELExpressionParameterValueProvider<MongoPersistentProperty> {
        private final Object parent;

        public ConverterAwareSpELExpressionParameterValueProvider(SpELExpressionEvaluator evaluator, ConversionService conversionService, ParameterValueProvider<MongoPersistentProperty> delegate, Object parent) {
            super(evaluator, conversionService, delegate);
            this.parent = parent;
        }

        protected <T> T potentiallyConvertSpelValue(Object object, PreferredConstructor.Parameter<T, MongoPersistentProperty> parameter) {
            return (T)MappingMongoConverter.this.readValue(object, parameter.getType(), this.parent);
        }
    }

    private class MongoDbPropertyValueProvider
    implements PropertyValueProvider<MongoPersistentProperty> {
        private final DBObjectAccessor source;
        private final SpELExpressionEvaluator evaluator;
        private final Object parent;

        public MongoDbPropertyValueProvider(DBObject source, SpELContext factory, Object parent) {
            this(source, new DefaultSpELExpressionEvaluator((Object)source, factory), parent);
        }

        public MongoDbPropertyValueProvider(DBObject source, DefaultSpELExpressionEvaluator evaluator, Object parent) {
            Assert.notNull((Object)source);
            Assert.notNull((Object)evaluator);
            this.source = new DBObjectAccessor(source);
            this.evaluator = evaluator;
            this.parent = parent;
        }

        public <T> T getPropertyValue(MongoPersistentProperty property) {
            Object value;
            String expression = property.getSpelExpression();
            Object object = value = expression != null ? this.evaluator.evaluate(expression) : this.source.get(property);
            if (value == null) {
                return null;
            }
            return (T)MappingMongoConverter.this.readValue(value, property.getTypeInformation(), this.parent);
        }
    }
}

