/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.query;

import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.springframework.core.convert.converter.Converter;

public abstract class SerializationUtils {
    private SerializationUtils() {
    }

    public static String serializeToJsonSafely(Object value) {
        if (value == null) {
            return null;
        }
        try {
            return JSON.serialize((Object)value);
        }
        catch (Exception e) {
            if (value instanceof Collection) {
                return SerializationUtils.toString((Collection)value);
            }
            if (value instanceof Map) {
                return SerializationUtils.toString((Map)value);
            }
            if (value instanceof DBObject) {
                return SerializationUtils.toString(((DBObject)value).toMap());
            }
            return String.format("{ $java : %s }", value.toString());
        }
    }

    private static String toString(Map<?, ?> source) {
        return SerializationUtils.iterableToDelimitedString(source.entrySet(), "{ ", " }", new Converter<Map.Entry<?, ?>, Object>(){

            public Object convert(Map.Entry<?, ?> source) {
                return String.format("\"%s\" : %s", source.getKey(), SerializationUtils.serializeToJsonSafely(source.getValue()));
            }
        });
    }

    private static String toString(Collection<?> source) {
        return SerializationUtils.iterableToDelimitedString(source, "[ ", " ]", new Converter<Object, Object>(){

            public Object convert(Object source) {
                return SerializationUtils.serializeToJsonSafely(source);
            }
        });
    }

    private static <T> String iterableToDelimitedString(Iterable<T> source, String prefix, String postfix, Converter<? super T, Object> transformer) {
        StringBuilder builder = new StringBuilder(prefix);
        Iterator<T> iterator = source.iterator();
        while (iterator.hasNext()) {
            builder.append(transformer.convert(iterator.next()));
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        return builder.append(postfix).toString();
    }
}

