/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import com.mongodb.WriteResult;
import java.util.Collections;
import java.util.List;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.SliceImpl;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoPage;
import org.springframework.data.geo.GeoResult;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Point;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.NearQuery;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.repository.query.ConvertingParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoEntityMetadata;
import org.springframework.data.mongodb.repository.query.MongoParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoParametersParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoQueryMethod;
import org.springframework.data.repository.core.EntityMetadata;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

public abstract class AbstractMongoQuery
implements RepositoryQuery {
    private static final ConversionService CONVERSION_SERVICE = new DefaultConversionService();
    private final MongoQueryMethod method;
    private final MongoOperations operations;

    public AbstractMongoQuery(MongoQueryMethod method, MongoOperations operations) {
        Assert.notNull((Object)operations);
        Assert.notNull((Object)((Object)method));
        this.method = method;
        this.operations = operations;
    }

    public MongoQueryMethod getQueryMethod() {
        return this.method;
    }

    public Object execute(Object[] parameters) {
        MongoParametersParameterAccessor accessor = new MongoParametersParameterAccessor(this.method, parameters);
        Query query = this.createQuery(new ConvertingParameterAccessor(this.operations.getConverter(), accessor));
        this.applyQueryMetaAttributesWhenPresent(query);
        if (this.isDeleteQuery()) {
            return new DeleteExecution().execute(query);
        }
        if (this.method.isGeoNearQuery() && this.method.isPageQuery()) {
            MongoParametersParameterAccessor countAccessor = new MongoParametersParameterAccessor(this.method, parameters);
            Query countQuery = this.createCountQuery(new ConvertingParameterAccessor(this.operations.getConverter(), countAccessor));
            return new GeoNearExecution(accessor).execute(query, countQuery);
        }
        if (this.method.isGeoNearQuery()) {
            return new GeoNearExecution(accessor).execute(query);
        }
        if (this.method.isSliceQuery()) {
            return new SlicedExecution(accessor.getPageable()).execute(query);
        }
        if (this.method.isCollectionQuery()) {
            return new CollectionExecution(accessor.getPageable()).execute(query);
        }
        if (this.method.isPageQuery()) {
            return new PagedExecution(accessor.getPageable()).execute(query);
        }
        return new SingleEntityExecution(this.isCountQuery()).execute(query);
    }

    private Query applyQueryMetaAttributesWhenPresent(Query query) {
        if (this.method.hasQueryMetaAttributes()) {
            query.setMeta(this.method.getQueryMetaAttributes());
        }
        return query;
    }

    protected Query createCountQuery(ConvertingParameterAccessor accessor) {
        Query query = this.createQuery(accessor);
        this.applyQueryMetaAttributesWhenPresent(query);
        return query;
    }

    protected abstract Query createQuery(ConvertingParameterAccessor var1);

    protected abstract boolean isCountQuery();

    protected abstract boolean isDeleteQuery();

    final class DeleteExecution
    extends Execution {
        DeleteExecution() {
        }

        @Override
        Object execute(Query query) {
            EntityMetadata metadata = AbstractMongoQuery.this.method.getEntityInformation();
            return this.deleteAndConvertResult(query, (MongoEntityMetadata<?>)metadata);
        }

        private Object deleteAndConvertResult(Query query, MongoEntityMetadata<?> metadata) {
            if (AbstractMongoQuery.this.method.isCollectionQuery()) {
                return AbstractMongoQuery.this.operations.findAllAndRemove(query, metadata.getJavaType(), metadata.getCollectionName());
            }
            WriteResult writeResult = AbstractMongoQuery.this.operations.remove(query, metadata.getJavaType(), metadata.getCollectionName());
            return writeResult != null ? (long)writeResult.getN() : 0L;
        }
    }

    final class GeoNearExecution
    extends Execution {
        private final MongoParameterAccessor accessor;

        public GeoNearExecution(MongoParameterAccessor accessor) {
            this.accessor = accessor;
        }

        @Override
        Object execute(Query query) {
            GeoResults<Object> results = this.doExecuteQuery(query);
            return this.isListOfGeoResult() ? results.getContent() : results;
        }

        Object execute(Query query, Query countQuery) {
            EntityMetadata metadata = AbstractMongoQuery.this.method.getEntityInformation();
            long count = AbstractMongoQuery.this.operations.count(countQuery, metadata.getCollectionName());
            return new GeoPage(this.doExecuteQuery(query), this.accessor.getPageable(), count);
        }

        private GeoResults<Object> doExecuteQuery(Query query) {
            Pageable pageable;
            Distance maxDistance;
            Point nearLocation = this.accessor.getGeoNearLocation();
            NearQuery nearQuery = NearQuery.near(nearLocation);
            if (query != null) {
                nearQuery.query(query);
            }
            if ((maxDistance = this.accessor.getMaxDistance()) != null) {
                nearQuery.maxDistance(maxDistance).in(maxDistance.getMetric());
            }
            if ((pageable = this.accessor.getPageable()) != null) {
                nearQuery.with(pageable);
            }
            EntityMetadata metadata = AbstractMongoQuery.this.method.getEntityInformation();
            return AbstractMongoQuery.this.operations.geoNear(nearQuery, metadata.getJavaType(), metadata.getCollectionName());
        }

        private boolean isListOfGeoResult() {
            TypeInformation<?> returnType = AbstractMongoQuery.this.method.getReturnType();
            if (!returnType.getType().equals(List.class)) {
                return false;
            }
            TypeInformation componentType = returnType.getComponentType();
            return componentType == null ? false : GeoResult.class.equals((Object)componentType.getType());
        }
    }

    final class SingleEntityExecution
    extends Execution {
        private final boolean countProjection;

        private SingleEntityExecution(boolean countProjection) {
            this.countProjection = countProjection;
        }

        @Override
        Object execute(Query query) {
            EntityMetadata metadata = AbstractMongoQuery.this.method.getEntityInformation();
            return this.countProjection ? Long.valueOf(AbstractMongoQuery.this.operations.count(query, metadata.getJavaType())) : AbstractMongoQuery.this.operations.findOne(query, metadata.getJavaType(), metadata.getCollectionName());
        }
    }

    final class PagedExecution
    extends Execution {
        private final Pageable pageable;

        public PagedExecution(Pageable pageable) {
            Assert.notNull((Object)pageable);
            this.pageable = pageable;
        }

        @Override
        Object execute(Query query) {
            boolean pageableOutOfScope;
            EntityMetadata metadata = AbstractMongoQuery.this.method.getEntityInformation();
            int overallLimit = query.getLimit();
            long count = AbstractMongoQuery.this.operations.count(query, metadata.getCollectionName());
            count = overallLimit != 0 ? Math.min(count, (long)query.getLimit()) : count;
            boolean bl = pageableOutOfScope = (long)this.pageable.getOffset() > count;
            if (pageableOutOfScope) {
                return new PageImpl(Collections.emptyList(), this.pageable, count);
            }
            query = query.with(this.pageable);
            if (overallLimit != 0 && this.pageable.getOffset() + this.pageable.getPageSize() > overallLimit) {
                query.limit(overallLimit - this.pageable.getOffset());
            }
            List result = AbstractMongoQuery.this.operations.find(query, metadata.getJavaType(), metadata.getCollectionName());
            return new PageImpl(result, this.pageable, count);
        }
    }

    final class SlicedExecution
    extends Execution {
        private final Pageable pageable;

        SlicedExecution(Pageable pageable) {
            this.pageable = pageable;
        }

        @Override
        Object execute(Query query) {
            EntityMetadata metadata = AbstractMongoQuery.this.method.getEntityInformation();
            int pageSize = this.pageable.getPageSize();
            Query modifiedQuery = query.with(this.pageable).limit(pageSize + 1);
            List result = AbstractMongoQuery.this.operations.find(modifiedQuery, metadata.getJavaType(), metadata.getCollectionName());
            boolean hasNext = result.size() > pageSize;
            return new SliceImpl(hasNext ? result.subList(0, pageSize) : result, this.pageable, hasNext);
        }
    }

    final class CollectionExecution
    extends Execution {
        private final Pageable pageable;

        CollectionExecution(Pageable pageable) {
            this.pageable = pageable;
        }

        @Override
        public Object execute(Query query) {
            return this.readCollection(query.with(this.pageable));
        }
    }

    private abstract class Execution {
        private Execution() {
        }

        abstract Object execute(Query var1);

        protected List<?> readCollection(Query query) {
            EntityMetadata metadata = AbstractMongoQuery.this.method.getEntityInformation();
            String collectionName = metadata.getCollectionName();
            return AbstractMongoQuery.this.operations.find(query, metadata.getJavaType(), collectionName);
        }
    }
}

