/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.config;

import com.mongodb.reactivestreams.client.MongoClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.ReactiveMongoDatabaseFactory;
import org.springframework.data.mongodb.config.MongoConfigurationSupport;
import org.springframework.data.mongodb.core.ReactiveMongoOperations;
import org.springframework.data.mongodb.core.ReactiveMongoTemplate;
import org.springframework.data.mongodb.core.SimpleReactiveMongoDatabaseFactory;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;

@Configuration
public abstract class AbstractReactiveMongoConfiguration
extends MongoConfigurationSupport {
    public abstract MongoClient mongoClient();

    @Bean
    public ReactiveMongoOperations reactiveMongoTemplate() throws Exception {
        return new ReactiveMongoTemplate(this.mongoDbFactory(), this.mappingMongoConverter());
    }

    @Bean
    public ReactiveMongoDatabaseFactory mongoDbFactory() {
        return new SimpleReactiveMongoDatabaseFactory(this.mongoClient(), this.getDatabaseName());
    }

    @Bean
    public MappingMongoConverter mappingMongoConverter() throws Exception {
        MappingMongoConverter converter = new MappingMongoConverter(ReactiveMongoTemplate.NO_OP_REF_RESOLVER, (MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty>)this.mongoMappingContext());
        converter.setCustomConversions(this.customConversions());
        return converter;
    }
}

