/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.config;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.annotation.Persistent;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.context.MappingContextIsNewStrategyFactory;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.mapping.model.CamelCaseAbbreviatingFieldNamingStrategy;
import org.springframework.data.mapping.model.FieldNamingStrategy;
import org.springframework.data.mapping.model.PropertyNameFieldNamingStrategy;
import org.springframework.data.mongodb.core.convert.CustomConversions;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.data.support.CachingIsNewStrategyFactory;
import org.springframework.data.support.IsNewStrategyFactory;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public abstract class MongoConfigurationSupport {
    protected abstract String getDatabaseName();

    protected Collection<String> getMappingBasePackages() {
        Package mappingBasePackage = this.getClass().getPackage();
        return Collections.singleton(mappingBasePackage == null ? null : mappingBasePackage.getName());
    }

    @Bean
    public MongoMappingContext mongoMappingContext() throws ClassNotFoundException {
        MongoMappingContext mappingContext = new MongoMappingContext();
        mappingContext.setInitialEntitySet(this.getInitialEntitySet());
        mappingContext.setSimpleTypeHolder(this.customConversions().getSimpleTypeHolder());
        mappingContext.setFieldNamingStrategy(this.fieldNamingStrategy());
        return mappingContext;
    }

    @Bean
    public IsNewStrategyFactory isNewStrategyFactory() throws ClassNotFoundException {
        return new CachingIsNewStrategyFactory((IsNewStrategyFactory)new MappingContextIsNewStrategyFactory(new PersistentEntities(Arrays.asList(new MappingContext[]{this.mongoMappingContext()}))));
    }

    @Bean
    public CustomConversions customConversions() {
        return new CustomConversions(Collections.emptyList());
    }

    protected Set<Class<?>> getInitialEntitySet() throws ClassNotFoundException {
        HashSet initialEntitySet = new HashSet();
        for (String basePackage : this.getMappingBasePackages()) {
            initialEntitySet.addAll(this.scanForEntities(basePackage));
        }
        return initialEntitySet;
    }

    protected Set<Class<?>> scanForEntities(String basePackage) throws ClassNotFoundException {
        if (!StringUtils.hasText((String)basePackage)) {
            return Collections.emptySet();
        }
        HashSet initialEntitySet = new HashSet();
        if (StringUtils.hasText((String)basePackage)) {
            ClassPathScanningCandidateComponentProvider componentProvider = new ClassPathScanningCandidateComponentProvider(false);
            componentProvider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Document.class));
            componentProvider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Persistent.class));
            for (BeanDefinition candidate : componentProvider.findCandidateComponents(basePackage)) {
                initialEntitySet.add(ClassUtils.forName((String)candidate.getBeanClassName(), (ClassLoader)MongoConfigurationSupport.class.getClassLoader()));
            }
        }
        return initialEntitySet;
    }

    protected boolean abbreviateFieldNames() {
        return false;
    }

    protected FieldNamingStrategy fieldNamingStrategy() {
        return this.abbreviateFieldNames() ? new CamelCaseAbbreviatingFieldNamingStrategy() : PropertyNameFieldNamingStrategy.INSTANCE;
    }
}

