/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.Map;
import org.bson.Document;
import org.springframework.util.Assert;

public class AggregationOptions {
    private static final String BATCH_SIZE = "batchSize";
    private static final String CURSOR = "cursor";
    private static final String EXPLAIN = "explain";
    private static final String ALLOW_DISK_USE = "allowDiskUse";
    private final boolean allowDiskUse;
    private final boolean explain;
    private final Document cursor;

    public AggregationOptions(boolean allowDiskUse, boolean explain, Document cursor) {
        this.allowDiskUse = allowDiskUse;
        this.explain = explain;
        this.cursor = cursor;
    }

    public AggregationOptions(boolean allowDiskUse, boolean explain, int cursorBatchSize) {
        this(allowDiskUse, explain, AggregationOptions.createCursor(cursorBatchSize));
    }

    public static AggregationOptions fromDocument(Document document) {
        Assert.notNull((Object)document, (String)"Document must not be null!");
        boolean allowDiskUse = false;
        boolean explain = false;
        Document cursor = null;
        if (document.containsKey((Object)ALLOW_DISK_USE)) {
            allowDiskUse = (Boolean)document.get((Object)ALLOW_DISK_USE, Boolean.class);
        }
        if (document.containsKey((Object)EXPLAIN)) {
            explain = (Boolean)document.get((Object)EXPLAIN);
        }
        if (document.containsKey((Object)CURSOR)) {
            cursor = (Document)document.get((Object)CURSOR, Document.class);
        }
        return new AggregationOptions(allowDiskUse, explain, cursor);
    }

    public boolean isAllowDiskUse() {
        return this.allowDiskUse;
    }

    public boolean isExplain() {
        return this.explain;
    }

    public Integer getCursorBatchSize() {
        if (this.cursor != null && this.cursor.containsKey((Object)BATCH_SIZE)) {
            return (Integer)this.cursor.get((Object)BATCH_SIZE, Integer.class);
        }
        return null;
    }

    public Document getCursor() {
        return this.cursor;
    }

    Document applyAndReturnPotentiallyChangedCommand(Document command) {
        Document result = new Document((Map)command);
        if (this.allowDiskUse && !result.containsKey((Object)ALLOW_DISK_USE)) {
            result.put(ALLOW_DISK_USE, (Object)this.allowDiskUse);
        }
        if (this.explain && !result.containsKey((Object)EXPLAIN)) {
            result.put(EXPLAIN, (Object)this.explain);
        }
        if (this.cursor != null && !result.containsKey((Object)CURSOR)) {
            result.put(CURSOR, (Object)this.cursor);
        }
        return result;
    }

    public Document toDocument() {
        Document document = new Document();
        document.put(ALLOW_DISK_USE, (Object)this.allowDiskUse);
        document.put(EXPLAIN, (Object)this.explain);
        document.put(CURSOR, (Object)this.cursor);
        return document;
    }

    public String toString() {
        return this.toDocument().toJson();
    }

    static Document createCursor(int cursorBatchSize) {
        return new Document(BATCH_SIZE, (Object)cursorBatchSize);
    }

    public static class Builder {
        private boolean allowDiskUse;
        private boolean explain;
        private Document cursor;

        public Builder allowDiskUse(boolean allowDiskUse) {
            this.allowDiskUse = allowDiskUse;
            return this;
        }

        public Builder explain(boolean explain) {
            this.explain = explain;
            return this;
        }

        public Builder cursor(Document cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder cursorBatchSize(int batchSize) {
            this.cursor = AggregationOptions.createCursor(batchSize);
            return this;
        }

        public AggregationOptions build() {
            return new AggregationOptions(this.allowDiskUse, this.explain, this.cursor);
        }
    }
}

