/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.convert.JodaTimeConverters;
import org.springframework.data.convert.Jsr310Converters;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.ThreeTenBackPortConverters;
import org.springframework.data.convert.WritingConverter;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.mongodb.core.convert.ConverterRegistration;
import org.springframework.data.mongodb.core.convert.GeoConverters;
import org.springframework.data.mongodb.core.convert.MongoConverters;
import org.springframework.data.mongodb.core.mapping.MongoSimpleTypes;
import org.springframework.util.Assert;

public class CustomConversions {
    private static final Logger LOG = LoggerFactory.getLogger(CustomConversions.class);
    private static final String READ_CONVERTER_NOT_SIMPLE = "Registering converter from %s to %s as reading converter although it doesn't convert from a Mongo supported type! You might wanna check you annotation setup at the converter implementation.";
    private static final String WRITE_CONVERTER_NOT_SIMPLE = "Registering converter from %s to %s as writing converter although it doesn't convert to a Mongo supported type! You might wanna check you annotation setup at the converter implementation.";
    private final Set<GenericConverter.ConvertiblePair> readingPairs;
    private final Set<GenericConverter.ConvertiblePair> writingPairs;
    private final Set<Class<?>> customSimpleTypes;
    private final SimpleTypeHolder simpleTypeHolder;
    private final List<Object> converters;
    private final Map<GenericConverter.ConvertiblePair, Optional<Class<?>>> customReadTargetTypes;
    private final Map<GenericConverter.ConvertiblePair, Optional<Class<?>>> customWriteTargetTypes;
    private final Map<Class<?>, Optional<Class<?>>> rawWriteTargetTypes;

    CustomConversions() {
        this(new ArrayList());
    }

    public CustomConversions(List<?> converters) {
        Assert.notNull(converters, (String)"List of converters must not be null!");
        this.readingPairs = new LinkedHashSet<GenericConverter.ConvertiblePair>();
        this.writingPairs = new LinkedHashSet<GenericConverter.ConvertiblePair>();
        this.customSimpleTypes = new HashSet();
        this.customReadTargetTypes = new ConcurrentHashMap();
        this.customWriteTargetTypes = new ConcurrentHashMap();
        this.rawWriteTargetTypes = new ConcurrentHashMap();
        ArrayList<? extends Object> toRegister = new ArrayList<Object>();
        toRegister.addAll(converters);
        toRegister.add((Object)CustomToStringConverter.INSTANCE);
        toRegister.addAll(MongoConverters.getConvertersToRegister());
        toRegister.addAll(JodaTimeConverters.getConvertersToRegister());
        toRegister.addAll(GeoConverters.getConvertersToRegister());
        toRegister.addAll(Jsr310Converters.getConvertersToRegister());
        toRegister.addAll(ThreeTenBackPortConverters.getConvertersToRegister());
        for (Object e : toRegister) {
            this.registerConversion(e);
        }
        Collections.reverse(toRegister);
        this.converters = Collections.unmodifiableList(toRegister);
        this.simpleTypeHolder = new SimpleTypeHolder(this.customSimpleTypes, MongoSimpleTypes.HOLDER);
    }

    public SimpleTypeHolder getSimpleTypeHolder() {
        return this.simpleTypeHolder;
    }

    public boolean isSimpleType(Class<?> type) {
        return this.simpleTypeHolder.isSimpleType(type);
    }

    public void registerConvertersIn(GenericConversionService conversionService) {
        for (Object converter : this.converters) {
            boolean added = false;
            if (converter instanceof Converter) {
                conversionService.addConverter((Converter)converter);
                added = true;
            }
            if (converter instanceof ConverterFactory) {
                conversionService.addConverterFactory((ConverterFactory)converter);
                added = true;
            }
            if (converter instanceof GenericConverter) {
                conversionService.addConverter((GenericConverter)converter);
                added = true;
            }
            if (added) continue;
            throw new IllegalArgumentException("Given set contains element that is neither Converter nor ConverterFactory!");
        }
    }

    private void registerConversion(Object converter) {
        Class<?> type = converter.getClass();
        boolean isWriting = type.isAnnotationPresent(WritingConverter.class);
        boolean isReading = type.isAnnotationPresent(ReadingConverter.class);
        if (converter instanceof GenericConverter) {
            GenericConverter genericConverter = (GenericConverter)converter;
            for (GenericConverter.ConvertiblePair pair : genericConverter.getConvertibleTypes()) {
                this.register(new ConverterRegistration(pair, isReading, isWriting));
            }
        } else if (converter instanceof ConverterFactory) {
            Class[] arguments = GenericTypeResolver.resolveTypeArguments(converter.getClass(), ConverterFactory.class);
            this.register(new ConverterRegistration(arguments[0], arguments[1], isReading, isWriting));
        } else if (converter instanceof Converter) {
            Class[] arguments = GenericTypeResolver.resolveTypeArguments(converter.getClass(), Converter.class);
            this.register(new ConverterRegistration(arguments[0], arguments[1], isReading, isWriting));
        } else {
            throw new IllegalArgumentException("Unsupported Converter type!");
        }
    }

    private void register(ConverterRegistration converterRegistration) {
        GenericConverter.ConvertiblePair pair = converterRegistration.getConvertiblePair();
        if (converterRegistration.isReading()) {
            this.readingPairs.add(pair);
            if (LOG.isWarnEnabled() && !converterRegistration.isSimpleSourceType()) {
                LOG.warn(String.format(READ_CONVERTER_NOT_SIMPLE, pair.getSourceType(), pair.getTargetType()));
            }
        }
        if (converterRegistration.isWriting()) {
            this.writingPairs.add(pair);
            this.customSimpleTypes.add(pair.getSourceType());
            if (LOG.isWarnEnabled() && !converterRegistration.isSimpleTargetType()) {
                LOG.warn(String.format(WRITE_CONVERTER_NOT_SIMPLE, pair.getSourceType(), pair.getTargetType()));
            }
        }
    }

    public Class<?> getCustomWriteTarget(Class<?> sourceType) {
        return this.rawWriteTargetTypes.computeIfAbsent(sourceType, it -> CustomConversions.getCustomTarget(sourceType, null, this.writingPairs)).orElse(null);
    }

    public Class<?> getCustomWriteTarget(Class<?> sourceType, Class<?> requestedTargetType) {
        if (requestedTargetType == null) {
            return this.getCustomWriteTarget(sourceType);
        }
        return this.customWriteTargetTypes.computeIfAbsent(new GenericConverter.ConvertiblePair(sourceType, requestedTargetType), it -> CustomConversions.getCustomTarget(sourceType, requestedTargetType, this.writingPairs)).orElse(null);
    }

    public boolean hasCustomWriteTarget(Class<?> sourceType) {
        return this.hasCustomWriteTarget(sourceType, null);
    }

    public boolean hasCustomWriteTarget(Class<?> sourceType, Class<?> requestedTargetType) {
        return this.getCustomWriteTarget(sourceType, requestedTargetType) != null;
    }

    public boolean hasCustomReadTarget(Class<?> sourceType, Class<?> requestedTargetType) {
        return this.getCustomReadTarget(sourceType, requestedTargetType) != null;
    }

    private Class<?> getCustomReadTarget(Class<?> sourceType, Class<?> requestedTargetType) {
        if (requestedTargetType == null) {
            return null;
        }
        return this.customReadTargetTypes.computeIfAbsent(new GenericConverter.ConvertiblePair(sourceType, requestedTargetType), it -> CustomConversions.getCustomTarget(sourceType, requestedTargetType, this.readingPairs)).orElse(null);
    }

    private static Optional<Class<?>> getCustomTarget(Class<?> sourceType, Class<?> requestedTargetType, Collection<GenericConverter.ConvertiblePair> pairs) {
        Assert.notNull(sourceType, (String)"Source Class must not be null!");
        Assert.notNull(pairs, (String)"Collection of ConvertiblePair must not be null!");
        if (requestedTargetType != null && pairs.contains(new GenericConverter.ConvertiblePair(sourceType, requestedTargetType))) {
            return Optional.of(requestedTargetType);
        }
        for (GenericConverter.ConvertiblePair typePair : pairs) {
            if (!typePair.getSourceType().isAssignableFrom(sourceType)) continue;
            Class targetType = typePair.getTargetType();
            if (requestedTargetType != null && !targetType.isAssignableFrom(requestedTargetType)) continue;
            return Optional.of(targetType);
        }
        return Optional.empty();
    }

    @WritingConverter
    private static enum CustomToStringConverter implements GenericConverter
    {
        INSTANCE;


        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            GenericConverter.ConvertiblePair localeToString = new GenericConverter.ConvertiblePair(Locale.class, String.class);
            GenericConverter.ConvertiblePair booleanToString = new GenericConverter.ConvertiblePair(Character.class, String.class);
            return new HashSet<GenericConverter.ConvertiblePair>(Arrays.asList(localeToString, booleanToString));
        }

        public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            return source.toString();
        }
    }
}

