/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import com.mongodb.BasicDBList;
import com.mongodb.DBObject;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.data.convert.DefaultTypeMapper;
import org.springframework.data.convert.SimpleTypeInformationMapper;
import org.springframework.data.convert.TypeAliasAccessor;
import org.springframework.data.convert.TypeInformationMapper;
import org.springframework.data.mapping.Alias;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.convert.MongoTypeMapper;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.ObjectUtils;

public class DefaultMongoTypeMapper
extends DefaultTypeMapper<Bson>
implements MongoTypeMapper {
    public static final String DEFAULT_TYPE_KEY = "_class";
    private static final TypeInformation<List> LIST_TYPE_INFO = ClassTypeInformation.from(List.class);
    private static final TypeInformation<Map> MAP_TYPE_INFO = ClassTypeInformation.from(Map.class);
    private final TypeAliasAccessor<Bson> accessor;
    private final String typeKey;

    public DefaultMongoTypeMapper() {
        this(DEFAULT_TYPE_KEY);
    }

    public DefaultMongoTypeMapper(String typeKey) {
        this(typeKey, Arrays.asList(new SimpleTypeInformationMapper()));
    }

    public DefaultMongoTypeMapper(String typeKey, MappingContext<? extends PersistentEntity<?, ?>, ?> mappingContext) {
        this(typeKey, new DocumentTypeAliasAccessor(typeKey), mappingContext, Arrays.asList(new SimpleTypeInformationMapper()));
    }

    public DefaultMongoTypeMapper(String typeKey, List<? extends TypeInformationMapper> mappers) {
        this(typeKey, new DocumentTypeAliasAccessor(typeKey), null, mappers);
    }

    private DefaultMongoTypeMapper(String typeKey, TypeAliasAccessor<Bson> accessor, MappingContext<? extends PersistentEntity<?, ?>, ?> mappingContext, List<? extends TypeInformationMapper> mappers) {
        super(accessor, mappingContext, mappers);
        this.typeKey = typeKey;
        this.accessor = accessor;
    }

    @Override
    public boolean isTypeKey(String key) {
        return this.typeKey == null ? false : this.typeKey.equals(key);
    }

    @Override
    public void writeTypeRestrictions(Document result, Set<Class<?>> restrictedTypes) {
        if (restrictedTypes == null || restrictedTypes.isEmpty()) {
            return;
        }
        BasicDBList restrictedMappedTypes = new BasicDBList();
        for (Class<?> restrictedType : restrictedTypes) {
            Alias typeAlias = this.getAliasFor((TypeInformation)ClassTypeInformation.from(restrictedType));
            if (typeAlias == null || ObjectUtils.nullSafeEquals((Object)Alias.NONE, (Object)typeAlias) || !typeAlias.getValue().isPresent()) continue;
            restrictedMappedTypes.add(typeAlias.getValue().get());
        }
        this.accessor.writeTypeTo((Object)result, (Object)new Document("$in", (Object)restrictedMappedTypes));
    }

    protected Optional<TypeInformation<?>> getFallbackTypeFor(Bson source) {
        return Optional.of(source instanceof BasicDBList ? LIST_TYPE_INFO : MAP_TYPE_INFO);
    }

    public static final class DocumentTypeAliasAccessor
    implements TypeAliasAccessor<Bson> {
        private final String typeKey;

        public DocumentTypeAliasAccessor(String typeKey) {
            this.typeKey = typeKey;
        }

        public Alias readAliasFrom(Bson source) {
            if (source instanceof List) {
                return Alias.NONE;
            }
            if (source instanceof Document) {
                return Alias.ofOptional(Optional.ofNullable(((Document)source).get((Object)this.typeKey)));
            }
            if (source instanceof DBObject) {
                return Alias.ofOptional(Optional.ofNullable(((DBObject)source).get(this.typeKey)));
            }
            throw new IllegalArgumentException("Cannot read alias from " + source.getClass());
        }

        public void writeTypeTo(Bson sink, Object alias) {
            if (this.typeKey != null) {
                if (sink instanceof Document) {
                    ((Document)sink).put(this.typeKey, alias);
                } else if (sink instanceof DBObject) {
                    ((DBObject)sink).put(this.typeKey, alias);
                }
            }
        }
    }
}

