/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.mapping;

import java.math.BigInteger;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.annotation.Id;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.AnnotationBasedPersistentProperty;
import org.springframework.data.mapping.model.FieldNamingStrategy;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.PropertyNameFieldNamingStrategy;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.Field;
import org.springframework.data.mongodb.core.mapping.Language;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.mapping.TextScore;
import org.springframework.util.StringUtils;

public class BasicMongoPersistentProperty
extends AnnotationBasedPersistentProperty<MongoPersistentProperty>
implements MongoPersistentProperty {
    private static final Logger LOG = LoggerFactory.getLogger(BasicMongoPersistentProperty.class);
    private static final String ID_FIELD_NAME = "_id";
    private static final String LANGUAGE_FIELD_NAME = "language";
    private static final Set<Class<?>> SUPPORTED_ID_TYPES = new HashSet();
    private static final Set<String> SUPPORTED_ID_PROPERTY_NAMES = new HashSet<String>();
    private final FieldNamingStrategy fieldNamingStrategy;

    public BasicMongoPersistentProperty(Property property, MongoPersistentEntity<?> owner, SimpleTypeHolder simpleTypeHolder, FieldNamingStrategy fieldNamingStrategy) {
        super(property, owner, simpleTypeHolder);
        Object object = this.fieldNamingStrategy = fieldNamingStrategy == null ? PropertyNameFieldNamingStrategy.INSTANCE : fieldNamingStrategy;
        if (this.isIdProperty() && this.getFieldName() != ID_FIELD_NAME) {
            LOG.warn("Customizing field name for id property not allowed! Custom name will not be considered!");
        }
    }

    public boolean isIdProperty() {
        if (super.isIdProperty()) {
            return true;
        }
        return SUPPORTED_ID_PROPERTY_NAMES.contains(this.getName()) && !this.hasExplicitFieldName();
    }

    @Override
    public boolean isExplicitIdProperty() {
        return this.isAnnotationPresent(Id.class);
    }

    @Override
    public String getFieldName() {
        if (this.isIdProperty()) {
            if (!this.getOwner().getIdProperty().isPresent()) {
                return ID_FIELD_NAME;
            }
            if (this.getOwner().isIdProperty((PersistentProperty)this)) {
                return ID_FIELD_NAME;
            }
        }
        if (this.hasExplicitFieldName()) {
            return this.getAnnotatedFieldName();
        }
        String fieldName = this.fieldNamingStrategy.getFieldName((PersistentProperty)this);
        if (!StringUtils.hasText((String)fieldName)) {
            throw new MappingException(String.format("Invalid (null or empty) field name returned for property %s by %s!", this, this.fieldNamingStrategy.getClass()));
        }
        return fieldName;
    }

    protected boolean hasExplicitFieldName() {
        return StringUtils.hasText((String)this.getAnnotatedFieldName());
    }

    private String getAnnotatedFieldName() {
        Optional annotation = this.findAnnotation(Field.class);
        return annotation.filter(it -> StringUtils.hasText((String)it.value())).map(it -> it.value()).orElse(null);
    }

    @Override
    public int getFieldOrder() {
        Optional annotation = this.findAnnotation(Field.class);
        return annotation.map(it -> it.order()).orElse(Integer.MAX_VALUE);
    }

    protected Association<MongoPersistentProperty> createAssociation() {
        return new Association((PersistentProperty)this, null);
    }

    @Override
    public boolean isDbReference() {
        return this.isAnnotationPresent(DBRef.class);
    }

    @Override
    public DBRef getDBRef() {
        return this.findAnnotation(DBRef.class).orElse(null);
    }

    @Override
    public boolean isLanguageProperty() {
        return this.getFieldName().equals(LANGUAGE_FIELD_NAME) || this.isExplicitLanguageProperty();
    }

    @Override
    public boolean isExplicitLanguageProperty() {
        return this.isAnnotationPresent(Language.class);
    }

    @Override
    public boolean isTextScoreProperty() {
        return this.isAnnotationPresent(TextScore.class);
    }

    static {
        SUPPORTED_ID_TYPES.add(ObjectId.class);
        SUPPORTED_ID_TYPES.add(String.class);
        SUPPORTED_ID_TYPES.add(BigInteger.class);
        SUPPORTED_ID_PROPERTY_NAMES.add("id");
        SUPPORTED_ID_PROPERTY_NAMES.add(ID_FIELD_NAME);
    }
}

