/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.WriteConcern;
import org.bson.Document;
import org.springframework.data.mongodb.core.MongoActionOperation;
import org.springframework.util.Assert;

public class MongoAction {
    private final String collectionName;
    private final WriteConcern defaultWriteConcern;
    private final Class<?> entityType;
    private final MongoActionOperation mongoActionOperation;
    private final Document query;
    private final Document document;

    public MongoAction(WriteConcern defaultWriteConcern, MongoActionOperation mongoActionOperation, String collectionName, Class<?> entityType, Document document, Document query) {
        Assert.hasText((String)collectionName, (String)"Collection name must not be null or empty!");
        this.defaultWriteConcern = defaultWriteConcern;
        this.mongoActionOperation = mongoActionOperation;
        this.collectionName = collectionName;
        this.entityType = entityType;
        this.query = query;
        this.document = document;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public WriteConcern getDefaultWriteConcern() {
        return this.defaultWriteConcern;
    }

    public Class<?> getEntityType() {
        return this.entityType;
    }

    public MongoActionOperation getMongoActionOperation() {
        return this.mongoActionOperation;
    }

    public Document getQuery() {
        return this.query;
    }

    public Document getDocument() {
        return this.document;
    }
}

