/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.client.model.IndexOptions;
import com.mongodb.reactivestreams.client.ListIndexesPublisher;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.reactivestreams.Publisher;
import org.springframework.data.mongodb.core.IndexConverters;
import org.springframework.data.mongodb.core.ReactiveIndexOperations;
import org.springframework.data.mongodb.core.ReactiveMongoOperations;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.index.IndexInfo;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DefaultReactiveIndexOperations
implements ReactiveIndexOperations {
    private final ReactiveMongoOperations mongoOperations;
    private final String collectionName;

    public DefaultReactiveIndexOperations(ReactiveMongoOperations mongoOperations, String collectionName) {
        Assert.notNull((Object)mongoOperations, (String)"ReactiveMongoOperations must not be null!");
        Assert.notNull((Object)collectionName, (String)"Collection must not be null!");
        this.mongoOperations = mongoOperations;
        this.collectionName = collectionName;
    }

    @Override
    public Mono<String> ensureIndex(IndexDefinition indexDefinition) {
        return this.mongoOperations.execute(this.collectionName, collection -> {
            Document indexOptions = indexDefinition.getIndexOptions();
            if (indexOptions != null) {
                return collection.createIndex((Bson)indexDefinition.getIndexKeys(), (IndexOptions)IndexConverters.indexDefinitionToIndexOptionsConverter().convert((Object)indexDefinition));
            }
            return collection.createIndex((Bson)indexDefinition.getIndexKeys());
        }).next();
    }

    @Override
    public Mono<Void> dropIndex(String name) {
        return this.mongoOperations.execute(this.collectionName, collection -> Mono.from((Publisher)collection.dropIndex(name))).flatMap(success -> Mono.empty()).next();
    }

    @Override
    public Mono<Void> dropAllIndexes() {
        return this.dropIndex("*");
    }

    @Override
    public Flux<IndexInfo> getIndexInfo() {
        return this.mongoOperations.execute(this.collectionName, collection -> {
            ListIndexesPublisher indexesPublisher = collection.listIndexes(Document.class);
            return Flux.from((Publisher)indexesPublisher).map(arg_0 -> IndexConverters.documentToIndexInfoConverter().convert(arg_0));
        });
    }
}

