/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import java.beans.ConstructorProperties;
import org.springframework.data.mongodb.core.ExecutableAggregationOperation;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.TypedAggregation;
import org.springframework.data.util.CloseableIterator;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class ExecutableAggregationOperationSupport
implements ExecutableAggregationOperation {
    private final MongoTemplate template;

    ExecutableAggregationOperationSupport(MongoTemplate template) {
        Assert.notNull((Object)template, (String)"Template must not be null!");
        this.template = template;
    }

    @Override
    public <T> ExecutableAggregationOperation.AggregationOperation<T> aggregateAndReturn(Class<T> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null!");
        return new AggregationOperationSupport<T>(this.template, null, domainType, null);
    }

    static class AggregationOperationSupport<T>
    implements ExecutableAggregationOperation.AggregationOperationWithAggregation<T>,
    ExecutableAggregationOperation.AggregationOperation<T>,
    ExecutableAggregationOperation.TerminatingAggregationOperation<T> {
        private final MongoTemplate template;
        private final Aggregation aggregation;
        private final Class<T> domainType;
        private final String collection;

        @Override
        public ExecutableAggregationOperation.AggregationOperationWithAggregation<T> inCollection(String collection) {
            Assert.hasText((String)collection, (String)"Collection must not be null nor empty!");
            return new AggregationOperationSupport<T>(this.template, this.aggregation, this.domainType, collection);
        }

        @Override
        public ExecutableAggregationOperation.TerminatingAggregationOperation<T> by(Aggregation aggregation) {
            Assert.notNull((Object)aggregation, (String)"Aggregation must not be null!");
            return new AggregationOperationSupport<T>(this.template, aggregation, this.domainType, this.collection);
        }

        @Override
        public AggregationResults<T> all() {
            return this.template.aggregate(this.aggregation, this.getCollectionName(this.aggregation), this.domainType);
        }

        @Override
        public CloseableIterator<T> stream() {
            return this.template.aggregateStream(this.aggregation, this.getCollectionName(this.aggregation), this.domainType);
        }

        private String getCollectionName(Aggregation aggregation) {
            TypedAggregation typedAggregation;
            if (StringUtils.hasText((String)this.collection)) {
                return this.collection;
            }
            if (aggregation instanceof TypedAggregation && (typedAggregation = (TypedAggregation)aggregation).getInputType() != null) {
                return this.template.determineCollectionName(typedAggregation.getInputType());
            }
            return this.template.determineCollectionName(this.domainType);
        }

        @ConstructorProperties(value={"template", "aggregation", "domainType", "collection"})
        public AggregationOperationSupport(MongoTemplate template, Aggregation aggregation, Class<T> domainType, String collection) {
            this.template = template;
            this.aggregation = aggregation;
            this.domainType = domainType;
            this.collection = collection;
        }
    }
}

