/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.bulk.BulkWriteResult;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.ExecutableInsertOperation;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class ExecutableInsertOperationSupport
implements ExecutableInsertOperation {
    private final MongoTemplate template;

    ExecutableInsertOperationSupport(MongoTemplate template) {
        Assert.notNull((Object)template, (String)"Template must not be null!");
        this.template = template;
    }

    @Override
    public <T> ExecutableInsertOperation.InsertOperation<T> insert(Class<T> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null!");
        return new InsertOperationSupport<T>(this.template, domainType, null, null);
    }

    static class InsertOperationSupport<T>
    implements ExecutableInsertOperation.InsertOperation<T> {
        private final MongoTemplate template;
        private final Class<T> domainType;
        private final String collection;
        private final BulkOperations.BulkMode bulkMode;

        @Override
        public void one(T object) {
            Assert.notNull(object, (String)"Object must not be null!");
            this.template.insert(object, this.getCollectionName());
        }

        @Override
        public void all(Collection<? extends T> objects) {
            Assert.notNull(objects, (String)"Objects must not be null!");
            this.template.insert(objects, this.getCollectionName());
        }

        @Override
        public BulkWriteResult bulk(Collection<? extends T> objects) {
            Assert.notNull(objects, (String)"Objects must not be null!");
            return this.template.bulkOps(this.bulkMode != null ? this.bulkMode : BulkOperations.BulkMode.ORDERED, this.domainType, this.getCollectionName()).insert(new ArrayList<T>(objects)).execute();
        }

        @Override
        public ExecutableInsertOperation.InsertOperationWithBulkMode<T> inCollection(String collection) {
            Assert.hasText((String)collection, (String)"Collection must not be null nor empty.");
            return new InsertOperationSupport<T>(this.template, this.domainType, collection, this.bulkMode);
        }

        @Override
        public ExecutableInsertOperation.TerminatingBulkInsertOperation<T> withBulkMode(BulkOperations.BulkMode bulkMode) {
            Assert.notNull((Object)((Object)bulkMode), (String)"BulkMode must not be null!");
            return new InsertOperationSupport<T>(this.template, this.domainType, this.collection, bulkMode);
        }

        private String getCollectionName() {
            return StringUtils.hasText((String)this.collection) ? this.collection : this.template.determineCollectionName(this.domainType);
        }

        @ConstructorProperties(value={"template", "domainType", "collection", "bulkMode"})
        public InsertOperationSupport(MongoTemplate template, Class<T> domainType, String collection, BulkOperations.BulkMode bulkMode) {
            this.template = template;
            this.domainType = domainType;
            this.collection = collection;
            this.bulkMode = bulkMode;
        }
    }
}

