/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.mapping;

import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.util.Optionals;

public final class EntityHandler<T extends MongoPersistentEntity<?>> {
    private final Optional<T> entity;

    public void doWithVersionProperty(BiConsumer<T, MongoPersistentProperty> consumer) {
        Optionals.ifAllPresent(this.entity, this.entity.flatMap(it -> it.getVersionProperty()), consumer);
    }

    @ConstructorProperties(value={"entity"})
    private EntityHandler(Optional<T> entity) {
        this.entity = entity;
    }

    public static <T extends MongoPersistentEntity<?>> EntityHandler<T> of(Optional<T> entity) {
        return new EntityHandler<T>(entity);
    }

    public Optional<T> getEntity() {
        return this.entity;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityHandler)) {
            return false;
        }
        EntityHandler other = (EntityHandler)o;
        Optional<T> this$entity = this.getEntity();
        Optional<T> other$entity = other.getEntity();
        return !(this$entity == null ? other$entity != null : !((Object)this$entity).equals(other$entity));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Optional<T> $entity = this.getEntity();
        result = result * 59 + ($entity == null ? 43 : ((Object)$entity).hashCode());
        return result;
    }

    public String toString() {
        return "EntityHandler(entity=" + this.getEntity() + ")";
    }
}

