/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.support;

import java.lang.reflect.Method;
import java.util.Optional;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.repository.query.MongoEntityInformation;
import org.springframework.data.mongodb.repository.query.MongoQueryMethod;
import org.springframework.data.mongodb.repository.query.PartTreeMongoQuery;
import org.springframework.data.mongodb.repository.query.StringBasedMongoQuery;
import org.springframework.data.mongodb.repository.support.MongoEntityInformationSupport;
import org.springframework.data.mongodb.repository.support.QuerydslMongoRepository;
import org.springframework.data.mongodb.repository.support.SimpleMongoRepository;
import org.springframework.data.mongodb.repository.support.SimpleReactiveMongoRepository;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.data.querydsl.QuerydslUtils;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.EvaluationContextProvider;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.reactive.ReactiveCrudRepository;
import org.springframework.data.repository.reactive.RxJava1CrudRepository;
import org.springframework.data.repository.util.QueryExecutionConverters;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class MongoRepositoryFactory
extends RepositoryFactorySupport {
    private static final boolean PROJECT_REACTOR_PRESENT = ClassUtils.isPresent((String)"reactor.core.publisher.Flux", (ClassLoader)QueryExecutionConverters.class.getClassLoader());
    private static final boolean RXJAVA_OBSERVABLE_PRESENT = ClassUtils.isPresent((String)"rx.Observable", (ClassLoader)QueryExecutionConverters.class.getClassLoader());
    private static final SpelExpressionParser EXPRESSION_PARSER = new SpelExpressionParser();
    private final MongoOperations operations;
    private final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;

    public MongoRepositoryFactory(MongoOperations mongoOperations) {
        Assert.notNull((Object)mongoOperations, (String)"MongoOperations must not be null!");
        this.operations = mongoOperations;
        this.mappingContext = mongoOperations.getConverter().getMappingContext();
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        boolean isQueryDslRepository;
        boolean isReactiveRepository = PROJECT_REACTOR_PRESENT && ReactiveCrudRepository.class.isAssignableFrom(metadata.getRepositoryInterface()) || RXJAVA_OBSERVABLE_PRESENT && RxJava1CrudRepository.class.isAssignableFrom(metadata.getRepositoryInterface());
        boolean bl = isQueryDslRepository = QuerydslUtils.QUERY_DSL_PRESENT && QuerydslPredicateExecutor.class.isAssignableFrom(metadata.getRepositoryInterface());
        if (isReactiveRepository) {
            if (isQueryDslRepository) {
                throw new InvalidDataAccessApiUsageException("Cannot combine Querydsl and reactive repository in one interface");
            }
            return SimpleReactiveMongoRepository.class;
        }
        return isQueryDslRepository ? QuerydslMongoRepository.class : SimpleMongoRepository.class;
    }

    protected Object getTargetRepository(RepositoryInformation information) {
        MongoEntityInformation entityInformation = this.getEntityInformation(information.getDomainType(), information);
        return this.getTargetRepositoryViaReflection(information, new Object[]{entityInformation, this.operations});
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(QueryLookupStrategy.Key key, EvaluationContextProvider evaluationContextProvider) {
        return Optional.of(new MongoQueryLookupStrategy(this.operations, evaluationContextProvider, this.mappingContext));
    }

    public <T, ID> MongoEntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        return this.getEntityInformation(domainClass, null);
    }

    private <T, ID> MongoEntityInformation<T, ID> getEntityInformation(Class<T> domainClass, RepositoryInformation information) {
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getRequiredPersistentEntity(domainClass);
        return MongoEntityInformationSupport.entityInformationFor(entity, information != null ? information.getIdType() : null);
    }

    private static class MongoQueryLookupStrategy
    implements QueryLookupStrategy {
        private final MongoOperations operations;
        private final EvaluationContextProvider evaluationContextProvider;
        MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;

        public MongoQueryLookupStrategy(MongoOperations operations, EvaluationContextProvider evaluationContextProvider, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
            this.operations = operations;
            this.evaluationContextProvider = evaluationContextProvider;
            this.mappingContext = mappingContext;
        }

        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
            MongoQueryMethod queryMethod = new MongoQueryMethod(method, metadata, factory, this.mappingContext);
            String namedQueryName = queryMethod.getNamedQueryName();
            if (namedQueries.hasQuery(namedQueryName)) {
                String namedQuery = namedQueries.getQuery(namedQueryName);
                return new StringBasedMongoQuery(namedQuery, queryMethod, this.operations, EXPRESSION_PARSER, this.evaluationContextProvider);
            }
            if (queryMethod.hasAnnotatedQuery()) {
                return new StringBasedMongoQuery(queryMethod, this.operations, EXPRESSION_PARSER, this.evaluationContextProvider);
            }
            return new PartTreeMongoQuery(queryMethod, this.operations);
        }
    }
}

