/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.MongoClient;
import com.mongodb.MongoException;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MapReduceIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mongodb.client.model.DeleteOptions;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.FindOneAndDeleteOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.ReturnDocument;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import com.mongodb.util.JSONParseException;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.json.JsonParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.convert.EntityReader;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResult;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Metric;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.CollectionCallback;
import org.springframework.data.mongodb.core.CollectionOptions;
import org.springframework.data.mongodb.core.CursorPreparer;
import org.springframework.data.mongodb.core.DbCallback;
import org.springframework.data.mongodb.core.DefaultBulkOperations;
import org.springframework.data.mongodb.core.DefaultIndexOperations;
import org.springframework.data.mongodb.core.DefaultScriptOperations;
import org.springframework.data.mongodb.core.DefaultWriteConcernResolver;
import org.springframework.data.mongodb.core.DocumentCallbackHandler;
import org.springframework.data.mongodb.core.ExecutableAggregationOperation;
import org.springframework.data.mongodb.core.ExecutableAggregationOperationSupport;
import org.springframework.data.mongodb.core.ExecutableFindOperation;
import org.springframework.data.mongodb.core.ExecutableFindOperationSupport;
import org.springframework.data.mongodb.core.ExecutableInsertOperation;
import org.springframework.data.mongodb.core.ExecutableInsertOperationSupport;
import org.springframework.data.mongodb.core.ExecutableRemoveOperation;
import org.springframework.data.mongodb.core.ExecutableRemoveOperationSupport;
import org.springframework.data.mongodb.core.ExecutableUpdateOperation;
import org.springframework.data.mongodb.core.ExecutableUpdateOperationSupport;
import org.springframework.data.mongodb.core.FindAndModifyOptions;
import org.springframework.data.mongodb.core.GeoCommandStatistics;
import org.springframework.data.mongodb.core.IndexConverters;
import org.springframework.data.mongodb.core.MongoAction;
import org.springframework.data.mongodb.core.MongoActionOperation;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.ScriptOperations;
import org.springframework.data.mongodb.core.SimpleMongoDbFactory;
import org.springframework.data.mongodb.core.WriteConcernResolver;
import org.springframework.data.mongodb.core.WriteResultChecking;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.AggregationOptions;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.TypeBasedAggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.TypedAggregation;
import org.springframework.data.mongodb.core.convert.DefaultDbRefResolver;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.MongoCustomConversions;
import org.springframework.data.mongodb.core.convert.MongoWriter;
import org.springframework.data.mongodb.core.convert.QueryMapper;
import org.springframework.data.mongodb.core.convert.UpdateMapper;
import org.springframework.data.mongodb.core.index.IndexOperations;
import org.springframework.data.mongodb.core.index.IndexOperationsProvider;
import org.springframework.data.mongodb.core.index.MongoMappingEventPublisher;
import org.springframework.data.mongodb.core.index.MongoPersistentEntityIndexCreator;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.mapping.MongoSimpleTypes;
import org.springframework.data.mongodb.core.mapping.event.AfterConvertEvent;
import org.springframework.data.mongodb.core.mapping.event.AfterDeleteEvent;
import org.springframework.data.mongodb.core.mapping.event.AfterLoadEvent;
import org.springframework.data.mongodb.core.mapping.event.AfterSaveEvent;
import org.springframework.data.mongodb.core.mapping.event.BeforeConvertEvent;
import org.springframework.data.mongodb.core.mapping.event.BeforeDeleteEvent;
import org.springframework.data.mongodb.core.mapping.event.BeforeSaveEvent;
import org.springframework.data.mongodb.core.mapping.event.MongoMappingEvent;
import org.springframework.data.mongodb.core.mapreduce.GroupBy;
import org.springframework.data.mongodb.core.mapreduce.GroupByResults;
import org.springframework.data.mongodb.core.mapreduce.MapReduceOptions;
import org.springframework.data.mongodb.core.mapreduce.MapReduceResults;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Meta;
import org.springframework.data.mongodb.core.query.NearQuery;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.SerializationUtils;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.util.MongoClientVersion;
import org.springframework.data.projection.ProjectionInformation;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.data.util.CloseableIterator;
import org.springframework.data.util.Optionals;
import org.springframework.data.util.Pair;
import org.springframework.data.util.StreamUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

public class MongoTemplate
implements MongoOperations,
ApplicationContextAware,
IndexOperationsProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoTemplate.class);
    private static final String ID_FIELD = "_id";
    private static final WriteResultChecking DEFAULT_WRITE_RESULT_CHECKING = WriteResultChecking.NONE;
    private static final Collection<String> ITERABLE_CLASSES;
    private final MongoConverter mongoConverter;
    private final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;
    private final MongoDbFactory mongoDbFactory;
    private final PersistenceExceptionTranslator exceptionTranslator;
    private final QueryMapper queryMapper;
    private final UpdateMapper updateMapper;
    private final SpelAwareProxyProjectionFactory projectionFactory;
    @Nullable
    private WriteConcern writeConcern;
    private WriteConcernResolver writeConcernResolver = DefaultWriteConcernResolver.INSTANCE;
    private WriteResultChecking writeResultChecking = WriteResultChecking.NONE;
    @Nullable
    private ReadPreference readPreference;
    @Nullable
    private ApplicationEventPublisher eventPublisher;
    @Nullable
    private ResourceLoader resourceLoader;
    @Nullable
    private MongoPersistentEntityIndexCreator indexCreator;

    public MongoTemplate(MongoClient mongoClient, String databaseName) {
        this(new SimpleMongoDbFactory(mongoClient, databaseName), null);
    }

    public MongoTemplate(MongoDbFactory mongoDbFactory) {
        this(mongoDbFactory, null);
    }

    public MongoTemplate(MongoDbFactory mongoDbFactory, @Nullable MongoConverter mongoConverter) {
        Assert.notNull((Object)mongoDbFactory, (String)"MongoDbFactory must not be null!");
        this.mongoDbFactory = mongoDbFactory;
        this.exceptionTranslator = mongoDbFactory.getExceptionTranslator();
        this.mongoConverter = mongoConverter == null ? MongoTemplate.getDefaultMongoConverter(mongoDbFactory) : mongoConverter;
        this.queryMapper = new QueryMapper(this.mongoConverter);
        this.updateMapper = new UpdateMapper(this.mongoConverter);
        this.projectionFactory = new SpelAwareProxyProjectionFactory();
        this.mappingContext = this.mongoConverter.getMappingContext();
        if (this.mappingContext instanceof MongoMappingContext) {
            this.indexCreator = new MongoPersistentEntityIndexCreator((MongoMappingContext)this.mappingContext, this);
            this.eventPublisher = new MongoMappingEventPublisher(this.indexCreator);
            if (this.mappingContext instanceof ApplicationEventPublisherAware) {
                ((ApplicationEventPublisherAware)this.mappingContext).setApplicationEventPublisher(this.eventPublisher);
            }
        }
    }

    public void setWriteResultChecking(@Nullable WriteResultChecking resultChecking) {
        this.writeResultChecking = resultChecking == null ? DEFAULT_WRITE_RESULT_CHECKING : resultChecking;
    }

    public void setWriteConcern(@Nullable WriteConcern writeConcern) {
        this.writeConcern = writeConcern;
    }

    public void setWriteConcernResolver(@Nullable WriteConcernResolver writeConcernResolver) {
        this.writeConcernResolver = writeConcernResolver == null ? DefaultWriteConcernResolver.INSTANCE : writeConcernResolver;
    }

    public void setReadPreference(@Nullable ReadPreference readPreference) {
        this.readPreference = readPreference;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.prepareIndexCreator(applicationContext);
        this.eventPublisher = applicationContext;
        if (this.mappingContext instanceof ApplicationEventPublisherAware) {
            ((ApplicationEventPublisherAware)this.mappingContext).setApplicationEventPublisher(this.eventPublisher);
        }
        this.resourceLoader = applicationContext;
        this.projectionFactory.setBeanFactory((BeanFactory)applicationContext);
        this.projectionFactory.setBeanClassLoader(applicationContext.getClassLoader());
    }

    private void prepareIndexCreator(ApplicationContext context) {
        String[] indexCreators;
        for (String creator : indexCreators = context.getBeanNamesForType(MongoPersistentEntityIndexCreator.class)) {
            MongoPersistentEntityIndexCreator creatorBean = (MongoPersistentEntityIndexCreator)context.getBean(creator, MongoPersistentEntityIndexCreator.class);
            if (!creatorBean.isIndexCreatorFor(this.mappingContext)) continue;
            return;
        }
        if (context instanceof ConfigurableApplicationContext && this.indexCreator != null) {
            ((ConfigurableApplicationContext)context).addApplicationListener((ApplicationListener)this.indexCreator);
        }
    }

    @Override
    public MongoConverter getConverter() {
        return this.mongoConverter;
    }

    @Override
    public <T> CloseableIterator<T> stream(Query query, Class<T> entityType) {
        return this.stream(query, entityType, this.determineCollectionName(entityType));
    }

    @Override
    public <T> CloseableIterator<T> stream(Query query, Class<T> entityType, String collectionName) {
        return this.doStream(query, entityType, collectionName, entityType);
    }

    protected <T> CloseableIterator<T> doStream(final Query query, final Class<?> entityType, final String collectionName, final Class<T> returnType) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Assert.notNull(entityType, (String)"Entity type must not be null!");
        Assert.hasText((String)collectionName, (String)"Collection name must not be null or empty!");
        Assert.notNull(returnType, (String)"ReturnType must not be null!");
        return (CloseableIterator)this.execute(collectionName, new CollectionCallback<CloseableIterator<T>>(){

            @Override
            public CloseableIterator<T> doInCollection(MongoCollection<Document> collection) throws MongoException, DataAccessException {
                MongoPersistentEntity persistentEntity = (MongoPersistentEntity)MongoTemplate.this.mappingContext.getRequiredPersistentEntity(entityType);
                Document mappedFields = MongoTemplate.this.getMappedFieldsObject(query.getFieldsObject(), persistentEntity, returnType);
                Document mappedQuery = MongoTemplate.this.queryMapper.getMappedObject((Bson)query.getQueryObject(), persistentEntity);
                FindIterable<Document> cursor = new QueryCursorPreparer(query, entityType).prepare((FindIterable<Document>)collection.find((Bson)mappedQuery).projection((Bson)mappedFields));
                return new CloseableIterableCursorAdapter(cursor, MongoTemplate.this.exceptionTranslator, new ProjectingReadCallback(MongoTemplate.this.mongoConverter, entityType, returnType, collectionName));
            }
        });
    }

    @Override
    public String getCollectionName(Class<?> entityClass) {
        return this.determineCollectionName(entityClass);
    }

    @Override
    public Document executeCommand(final String jsonCommand) {
        Assert.hasText((String)jsonCommand, (String)"JsonCommand must not be null nor empty!");
        return this.execute(new DbCallback<Document>(){

            @Override
            public Document doInDB(MongoDatabase db) throws MongoException, DataAccessException {
                return (Document)db.runCommand((Bson)Document.parse((String)jsonCommand), Document.class);
            }
        });
    }

    @Override
    public Document executeCommand(final Document command) {
        Assert.notNull((Object)command, (String)"Command must not be null!");
        Document result = this.execute(new DbCallback<Document>(){

            @Override
            public Document doInDB(MongoDatabase db) throws MongoException, DataAccessException {
                return (Document)db.runCommand((Bson)command, Document.class);
            }
        });
        return result;
    }

    @Override
    public Document executeCommand(final Document command, final @Nullable ReadPreference readPreference) {
        Assert.notNull((Object)command, (String)"Command must not be null!");
        Document result = this.execute(new DbCallback<Document>(){

            @Override
            public Document doInDB(MongoDatabase db) throws MongoException, DataAccessException {
                return readPreference != null ? (Document)db.runCommand((Bson)command, readPreference, Document.class) : (Document)db.runCommand((Bson)command, Document.class);
            }
        });
        return result;
    }

    @Override
    public void executeQuery(Query query, String collectionName, DocumentCallbackHandler dch) {
        this.executeQuery(query, collectionName, dch, new QueryCursorPreparer(query, null));
    }

    protected void executeQuery(Query query, String collectionName, DocumentCallbackHandler documentCallbackHandler, @Nullable CursorPreparer preparer) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Assert.notNull((Object)collectionName, (String)"CollectionName must not be null!");
        Assert.notNull((Object)documentCallbackHandler, (String)"DocumentCallbackHandler must not be null!");
        Document queryObject = this.queryMapper.getMappedObject((Bson)query.getQueryObject(), Optional.empty());
        Document sortObject = query.getSortObject();
        Document fieldsObject = query.getFieldsObject();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Executing query: {} sort: {} fields: {} in collection: {}", new Object[]{SerializationUtils.serializeToJsonSafely(queryObject), sortObject, fieldsObject, collectionName});
        }
        this.executeQueryInternal(new FindCallback(queryObject, fieldsObject), preparer, documentCallbackHandler, collectionName);
    }

    @Override
    public <T> T execute(DbCallback<T> action) {
        Assert.notNull(action, (String)"DbCallbackmust not be null!");
        try {
            MongoDatabase db = this.getDb();
            return action.doInDB(db);
        }
        catch (RuntimeException e) {
            throw MongoTemplate.potentiallyConvertRuntimeException(e, this.exceptionTranslator);
        }
    }

    @Override
    public <T> T execute(Class<?> entityClass, CollectionCallback<T> callback) {
        Assert.notNull(entityClass, (String)"EntityClass must not be null!");
        return this.execute(this.determineCollectionName(entityClass), callback);
    }

    @Override
    public <T> T execute(String collectionName, CollectionCallback<T> callback) {
        Assert.notNull((Object)collectionName, (String)"CollectionName must not be null!");
        Assert.notNull(callback, (String)"CollectionCallback must not be null!");
        try {
            MongoCollection<Document> collection = this.getAndPrepareCollection(this.getDb(), collectionName);
            return callback.doInCollection(collection);
        }
        catch (RuntimeException e) {
            throw MongoTemplate.potentiallyConvertRuntimeException(e, this.exceptionTranslator);
        }
    }

    @Override
    public <T> MongoCollection<Document> createCollection(Class<T> entityClass) {
        return this.createCollection(this.determineCollectionName(entityClass));
    }

    @Override
    public <T> MongoCollection<Document> createCollection(Class<T> entityClass, @Nullable CollectionOptions collectionOptions) {
        return this.createCollection(this.determineCollectionName(entityClass), collectionOptions);
    }

    @Override
    public MongoCollection<Document> createCollection(String collectionName) {
        Assert.notNull((Object)collectionName, (String)"CollectionName must not be null!");
        return this.doCreateCollection(collectionName, new Document());
    }

    @Override
    public MongoCollection<Document> createCollection(String collectionName, @Nullable CollectionOptions collectionOptions) {
        Assert.notNull((Object)collectionName, (String)"CollectionName must not be null!");
        return this.doCreateCollection(collectionName, this.convertToDocument(collectionOptions));
    }

    @Override
    public MongoCollection<Document> getCollection(final String collectionName) {
        Assert.notNull((Object)collectionName, (String)"CollectionName must not be null!");
        return this.execute(new DbCallback<MongoCollection<Document>>(){

            @Override
            public MongoCollection<Document> doInDB(MongoDatabase db) throws MongoException, DataAccessException {
                return db.getCollection(collectionName, Document.class);
            }
        });
    }

    @Override
    public <T> boolean collectionExists(Class<T> entityClass) {
        return this.collectionExists(this.determineCollectionName(entityClass));
    }

    @Override
    public boolean collectionExists(final String collectionName) {
        Assert.notNull((Object)collectionName, (String)"CollectionName must not be null!");
        return this.execute(new DbCallback<Boolean>(){

            @Override
            public Boolean doInDB(MongoDatabase db) throws MongoException, DataAccessException {
                for (String name : db.listCollectionNames()) {
                    if (!name.equals(collectionName)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    @Override
    public <T> void dropCollection(Class<T> entityClass) {
        this.dropCollection(this.determineCollectionName(entityClass));
    }

    @Override
    public void dropCollection(String collectionName) {
        Assert.notNull((Object)collectionName, (String)"CollectionName must not be null!");
        this.execute(collectionName, new CollectionCallback<Void>(){

            @Override
            public Void doInCollection(MongoCollection<Document> collection) throws MongoException, DataAccessException {
                collection.drop();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Dropped collection [{}]", (Object)collection.getNamespace().getCollectionName());
                }
                return null;
            }
        });
    }

    @Override
    public IndexOperations indexOps(String collectionName) {
        return new DefaultIndexOperations(this.getMongoDbFactory(), collectionName, this.queryMapper);
    }

    @Override
    public IndexOperations indexOps(Class<?> entityClass) {
        return new DefaultIndexOperations(this.getMongoDbFactory(), this.determineCollectionName(entityClass), this.queryMapper, entityClass);
    }

    @Override
    public BulkOperations bulkOps(BulkOperations.BulkMode bulkMode, String collectionName) {
        return this.bulkOps(bulkMode, null, collectionName);
    }

    @Override
    public BulkOperations bulkOps(BulkOperations.BulkMode bulkMode, Class<?> entityClass) {
        return this.bulkOps(bulkMode, entityClass, this.determineCollectionName(entityClass));
    }

    @Override
    public BulkOperations bulkOps(BulkOperations.BulkMode mode, @Nullable Class<?> entityType, String collectionName) {
        Assert.notNull((Object)((Object)mode), (String)"BulkMode must not be null!");
        Assert.hasText((String)collectionName, (String)"Collection name must not be null or empty!");
        DefaultBulkOperations operations = new DefaultBulkOperations(this, collectionName, new DefaultBulkOperations.BulkOperationContext(mode, Optional.ofNullable(this.getPersistentEntity(entityType)), this.queryMapper, this.updateMapper));
        operations.setExceptionTranslator(this.exceptionTranslator);
        operations.setDefaultWriteConcern(this.writeConcern);
        return operations;
    }

    @Override
    public ScriptOperations scriptOps() {
        return new DefaultScriptOperations(this);
    }

    @Override
    @Nullable
    public <T> T findOne(Query query, Class<T> entityClass) {
        return this.findOne(query, entityClass, this.determineCollectionName(entityClass));
    }

    @Override
    @Nullable
    public <T> T findOne(Query query, Class<T> entityClass, String collectionName) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Assert.notNull(entityClass, (String)"EntityClass must not be null!");
        Assert.notNull((Object)collectionName, (String)"CollectionName must not be null!");
        if (ObjectUtils.isEmpty((Object)query.getSortObject()) && !query.getCollation().isPresent()) {
            return this.doFindOne(collectionName, query.getQueryObject(), query.getFieldsObject(), entityClass);
        }
        query.limit(1);
        List<T> results = this.find(query, entityClass, collectionName);
        return results.isEmpty() ? null : (T)results.get(0);
    }

    @Override
    public boolean exists(Query query, Class<?> entityClass) {
        return this.exists(query, entityClass, this.determineCollectionName(entityClass));
    }

    @Override
    public boolean exists(Query query, String collectionName) {
        return this.exists(query, null, collectionName);
    }

    @Override
    public boolean exists(Query query, @Nullable Class<?> entityClass, String collectionName) {
        if (query == null) {
            throw new InvalidDataAccessApiUsageException("Query passed in to exist can't be null");
        }
        Assert.notNull((Object)collectionName, (String)"CollectionName must not be null!");
        Document mappedQuery = this.queryMapper.getMappedObject((Bson)query.getQueryObject(), this.getPersistentEntity(entityClass));
        return this.execute(collectionName, new ExistsCallback(mappedQuery, query.getCollation().map(Collation::toMongoCollation).orElse(null)));
    }

    @Override
    public <T> List<T> find(Query query, Class<T> entityClass) {
        return this.find(query, entityClass, this.determineCollectionName(entityClass));
    }

    @Override
    public <T> List<T> find(Query query, Class<T> entityClass, String collectionName) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Assert.notNull((Object)collectionName, (String)"CollectionName must not be null!");
        Assert.notNull(entityClass, (String)"EntityClass must not be null!");
        return this.doFind(collectionName, query.getQueryObject(), query.getFieldsObject(), entityClass, new QueryCursorPreparer(query, entityClass));
    }

    @Override
    @Nullable
    public <T> T findById(Object id, Class<T> entityClass) {
        return this.findById(id, entityClass, this.determineCollectionName(entityClass));
    }

    @Override
    @Nullable
    public <T> T findById(Object id, Class<T> entityClass, String collectionName) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull(entityClass, (String)"EntityClass must not be null!");
        Assert.notNull((Object)collectionName, (String)"CollectionName must not be null!");
        MongoPersistentEntity persistentEntity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(entityClass);
        String idKey = ID_FIELD;
        if (persistentEntity != null && persistentEntity.getIdProperty() != null) {
            idKey = ((MongoPersistentProperty)persistentEntity.getIdProperty()).getName();
        }
        return this.doFindOne(collectionName, new Document(idKey, id), new Document(), entityClass);
    }

    @Override
    public <T> GeoResults<T> geoNear(NearQuery near, Class<T> entityClass) {
        return this.geoNear(near, entityClass, this.determineCollectionName(entityClass));
    }

    @Override
    public <T> GeoResults<T> geoNear(NearQuery near, Class<T> domainType, String collectionName) {
        return this.geoNear(near, domainType, collectionName, domainType);
    }

    public <T> GeoResults<T> geoNear(NearQuery near, Class<?> domainType, String collectionName, Class<T> returnType) {
        Document commandResult;
        List results;
        if (near == null) {
            throw new InvalidDataAccessApiUsageException("NearQuery must not be null!");
        }
        if (domainType == null) {
            throw new InvalidDataAccessApiUsageException("Entity class must not be null!");
        }
        Assert.notNull((Object)collectionName, (String)"CollectionName must not be null!");
        Assert.notNull(returnType, (String)"ReturnType must not be null!");
        String collection = StringUtils.hasText((String)collectionName) ? collectionName : this.determineCollectionName(domainType);
        Document nearDocument = near.toDocument();
        Document command = new Document("geoNear", (Object)collection);
        command.putAll((Map)nearDocument);
        if (nearDocument.containsKey((Object)"query")) {
            Document query = (Document)nearDocument.get((Object)"query");
            command.put("query", (Object)this.queryMapper.getMappedObject((Bson)query, this.getPersistentEntity(domainType)));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Executing geoNear using: {} for class: {} in collection: {}", new Object[]{SerializationUtils.serializeToJsonSafely(command), domainType, collectionName});
        }
        results = (results = (List)(commandResult = this.executeCommand(command, this.readPreference)).get((Object)"results")) == null ? Collections.emptyList() : results;
        GeoNearResultDocumentCallback callback = new GeoNearResultDocumentCallback(new ProjectingReadCallback(this.mongoConverter, domainType, returnType, collectionName), near.getMetric());
        ArrayList result = new ArrayList(results.size());
        int index = 0;
        long elementsToSkip = near.getSkip() != null ? near.getSkip() : 0L;
        for (Object element : results) {
            if ((long)index >= elementsToSkip) {
                result.add(callback.doWith((Document)element));
            }
            ++index;
        }
        if (elementsToSkip > 0L) {
            return new GeoResults(result, near.getMetric());
        }
        GeoCommandStatistics stats = GeoCommandStatistics.from(commandResult);
        return new GeoResults(result, new Distance(stats.getAverageDistance(), near.getMetric()));
    }

    @Override
    @Nullable
    public <T> T findAndModify(Query query, Update update, Class<T> entityClass) {
        return this.findAndModify(query, update, new FindAndModifyOptions(), entityClass, this.determineCollectionName(entityClass));
    }

    @Override
    @Nullable
    public <T> T findAndModify(Query query, Update update, Class<T> entityClass, String collectionName) {
        return this.findAndModify(query, update, new FindAndModifyOptions(), entityClass, collectionName);
    }

    @Override
    @Nullable
    public <T> T findAndModify(Query query, Update update, FindAndModifyOptions options, Class<T> entityClass) {
        return this.findAndModify(query, update, options, entityClass, this.determineCollectionName(entityClass));
    }

    @Override
    @Nullable
    public <T> T findAndModify(Query query, Update update, FindAndModifyOptions options, Class<T> entityClass, String collectionName) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Assert.notNull((Object)update, (String)"Update must not be null!");
        Assert.notNull((Object)options, (String)"Options must not be null!");
        Assert.notNull(entityClass, (String)"EntityClass must not be null!");
        Assert.notNull((Object)collectionName, (String)"CollectionName must not be null!");
        FindAndModifyOptions optionsToUse = FindAndModifyOptions.of(options);
        Optionals.ifAllPresent(query.getCollation(), optionsToUse.getCollation(), (l, r) -> {
            throw new IllegalArgumentException("Both Query and FindAndModifyOptions define a collation. Please provide the collation only via one of the two.");
        });
        query.getCollation().ifPresent(optionsToUse::collation);
        return this.doFindAndModify(collectionName, query.getQueryObject(), query.getFieldsObject(), this.getMappedSortObject(query, entityClass), entityClass, update, optionsToUse);
    }

    @Override
    @Nullable
    public <T> T findAndRemove(Query query, Class<T> entityClass) {
        return this.findAndRemove(query, entityClass, this.determineCollectionName(entityClass));
    }

    @Override
    @Nullable
    public <T> T findAndRemove(Query query, Class<T> entityClass, String collectionName) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Assert.notNull(entityClass, (String)"EntityClass must not be null!");
        Assert.notNull((Object)collectionName, (String)"CollectionName must not be null!");
        return this.doFindAndRemove(collectionName, query.getQueryObject(), query.getFieldsObject(), this.getMappedSortObject(query, entityClass), query.getCollation().orElse(null), entityClass);
    }

    @Override
    public long count(Query query, Class<?> entityClass) {
        Assert.notNull(entityClass, (String)"Entity class must not be null!");
        return this.count(query, entityClass, this.determineCollectionName(entityClass));
    }

    @Override
    public long count(Query query, String collectionName) {
        return this.count(query, null, collectionName);
    }

    @Override
    public long count(Query query, @Nullable Class<?> entityClass, String collectionName) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Assert.hasText((String)collectionName, (String)"Collection name must not be null or empty!");
        Document document = this.queryMapper.getMappedObject((Bson)query.getQueryObject(), Optional.ofNullable(entityClass).map(it -> (MongoPersistentEntity)this.mappingContext.getPersistentEntity(entityClass)));
        return this.execute(collectionName, (MongoCollection<Document> collection) -> collection.count((Bson)document));
    }

    @Override
    public void insert(Object objectToSave) {
        Assert.notNull((Object)objectToSave, (String)"ObjectToSave must not be null!");
        this.ensureNotIterable(objectToSave);
        this.insert(objectToSave, this.determineEntityCollectionName(objectToSave));
    }

    @Override
    public void insert(Object objectToSave, String collectionName) {
        Assert.notNull((Object)objectToSave, (String)"ObjectToSave must not be null!");
        Assert.notNull((Object)collectionName, (String)"CollectionName must not be null!");
        this.ensureNotIterable(objectToSave);
        this.doInsert(collectionName, objectToSave, this.mongoConverter);
    }

    protected void ensureNotIterable(@Nullable Object o) {
        if (null != o && (o.getClass().isArray() || ITERABLE_CLASSES.contains(o.getClass().getName()))) {
            throw new IllegalArgumentException("Cannot use a collection here.");
        }
    }

    protected MongoCollection<Document> prepareCollection(MongoCollection<Document> collection) {
        if (this.readPreference != null) {
            return collection.withReadPreference(this.readPreference);
        }
        return collection;
    }

    @Nullable
    protected WriteConcern prepareWriteConcern(MongoAction mongoAction) {
        WriteConcern wc = this.writeConcernResolver.resolve(mongoAction);
        return this.potentiallyForceAcknowledgedWrite(wc);
    }

    @Nullable
    private WriteConcern potentiallyForceAcknowledgedWrite(@Nullable WriteConcern wc) {
        if (ObjectUtils.nullSafeEquals((Object)((Object)WriteResultChecking.EXCEPTION), (Object)((Object)this.writeResultChecking)) && MongoClientVersion.isMongo3Driver() && (wc == null || wc.getWObject() == null || wc.getWObject() instanceof Number && ((Number)wc.getWObject()).intValue() < 1)) {
            return WriteConcern.ACKNOWLEDGED;
        }
        return wc;
    }

    protected <T> void doInsert(String collectionName, T objectToSave, MongoWriter<T> writer) {
        this.initializeVersionProperty(objectToSave);
        this.maybeEmitEvent(new BeforeConvertEvent<T>(objectToSave, collectionName));
        this.assertUpdateableIdIfNotSet(objectToSave);
        Document dbDoc = this.toDocument(objectToSave, writer);
        this.maybeEmitEvent(new BeforeSaveEvent<T>(objectToSave, dbDoc, collectionName));
        Object id = this.insertDocument(collectionName, dbDoc, objectToSave.getClass());
        this.populateIdIfNecessary(objectToSave, id);
        this.maybeEmitEvent(new AfterSaveEvent<T>(objectToSave, dbDoc, collectionName));
    }

    private <T> Document toDocument(T objectToSave, MongoWriter<T> writer) {
        if (objectToSave instanceof Document) {
            return (Document)objectToSave;
        }
        if (!(objectToSave instanceof String)) {
            Document dbDoc = new Document();
            writer.write(objectToSave, dbDoc);
            if (dbDoc.containsKey((Object)ID_FIELD) && dbDoc.get((Object)ID_FIELD) == null) {
                dbDoc.remove((Object)ID_FIELD);
            }
            return dbDoc;
        }
        try {
            return Document.parse((String)((String)objectToSave));
        }
        catch (JSONParseException e) {
            throw new MappingException("Could not parse given String to save into a JSON document!", (Throwable)e);
        }
        catch (JsonParseException e) {
            throw new MappingException("Could not parse given String to save into a JSON document!", (Throwable)e);
        }
    }

    private void initializeVersionProperty(Object entity) {
        MongoPersistentEntity<?> persistentEntity = this.getPersistentEntity(entity.getClass());
        if (persistentEntity != null && persistentEntity.hasVersionProperty()) {
            MongoPersistentProperty versionProperty = (MongoPersistentProperty)persistentEntity.getRequiredVersionProperty();
            ConvertingPropertyAccessor accessor = new ConvertingPropertyAccessor(persistentEntity.getPropertyAccessor(entity), this.mongoConverter.getConversionService());
            accessor.setProperty((PersistentProperty)versionProperty, (Object)0);
        }
    }

    @Override
    public void insert(Collection<? extends Object> batchToSave, Class<?> entityClass) {
        Assert.notNull(batchToSave, (String)"BatchToSave must not be null!");
        this.doInsertBatch(this.determineCollectionName(entityClass), batchToSave, this.mongoConverter);
    }

    @Override
    public void insert(Collection<? extends Object> batchToSave, String collectionName) {
        Assert.notNull(batchToSave, (String)"BatchToSave must not be null!");
        Assert.notNull((Object)collectionName, (String)"CollectionName must not be null!");
        this.doInsertBatch(collectionName, batchToSave, this.mongoConverter);
    }

    @Override
    public void insertAll(Collection<? extends Object> objectsToSave) {
        Assert.notNull(objectsToSave, (String)"ObjectsToSave must not be null!");
        this.doInsertAll(objectsToSave, this.mongoConverter);
    }

    protected <T> void doInsertAll(Collection<? extends T> listToSave, MongoWriter<T> writer) {
        HashMap<String, ArrayList<T>> elementsByCollection = new HashMap<String, ArrayList<T>>();
        for (T t : listToSave) {
            if (t == null) continue;
            MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getRequiredPersistentEntity(t.getClass());
            String collection = entity.getCollection();
            ArrayList<T> collectionElements = (ArrayList<T>)elementsByCollection.get(collection);
            if (null == collectionElements) {
                collectionElements = new ArrayList<T>();
                elementsByCollection.put(collection, collectionElements);
            }
            collectionElements.add(t);
        }
        for (Map.Entry entry : elementsByCollection.entrySet()) {
            this.doInsertBatch((String)entry.getKey(), (Collection)entry.getValue(), this.mongoConverter);
        }
    }

    protected <T> void doInsertBatch(String collectionName, Collection<? extends T> batchToSave, MongoWriter<T> writer) {
        Assert.notNull(writer, (String)"MongoWriter must not be null!");
        ArrayList<Document> documentList = new ArrayList<Document>();
        for (T o : batchToSave) {
            this.initializeVersionProperty(o);
            this.maybeEmitEvent(new BeforeConvertEvent<T>(o, collectionName));
            Document document = this.toDocument(o, writer);
            this.maybeEmitEvent(new BeforeSaveEvent<T>(o, document, collectionName));
            documentList.add(document);
        }
        List<Object> ids = this.insertDocumentList(collectionName, documentList);
        int i = 0;
        for (T obj : batchToSave) {
            if (i < ids.size()) {
                this.populateIdIfNecessary(obj, ids.get(i));
                this.maybeEmitEvent(new AfterSaveEvent<T>(obj, (Document)documentList.get(i), collectionName));
            }
            ++i;
        }
    }

    @Override
    public void save(Object objectToSave) {
        Assert.notNull((Object)objectToSave, (String)"Object to save must not be null!");
        this.save(objectToSave, this.determineEntityCollectionName(objectToSave));
    }

    @Override
    public void save(Object objectToSave, String collectionName) {
        Assert.notNull((Object)objectToSave, (String)"Object to save must not be null!");
        Assert.hasText((String)collectionName, (String)"Collection name must not be null or empty!");
        MongoPersistentEntity<?> entity = this.getPersistentEntity(objectToSave.getClass());
        if (entity != null && entity.hasVersionProperty()) {
            this.doSaveVersioned(objectToSave, entity, collectionName);
            return;
        }
        this.doSave(collectionName, objectToSave, this.mongoConverter);
    }

    private <T> T doSaveVersioned(T objectToSave, MongoPersistentEntity<?> entity, String collectionName) {
        MongoPersistentProperty property;
        ConvertingPropertyAccessor convertingAccessor = new ConvertingPropertyAccessor(entity.getPropertyAccessor(objectToSave), this.mongoConverter.getConversionService());
        Number number = (Number)convertingAccessor.getProperty((PersistentProperty)(property = (MongoPersistentProperty)entity.getRequiredVersionProperty()), Number.class);
        if (number != null) {
            convertingAccessor.setProperty((PersistentProperty)property, (Object)(number.longValue() + 1L));
            this.maybeEmitEvent(new BeforeConvertEvent<T>(objectToSave, collectionName));
            this.assertUpdateableIdIfNotSet(objectToSave);
            Document document = new Document();
            this.mongoConverter.write(objectToSave, document);
            this.maybeEmitEvent(new BeforeSaveEvent<T>(objectToSave, document, collectionName));
            Update update = Update.fromDocument(document, ID_FIELD);
            MongoPersistentProperty idProperty = (MongoPersistentProperty)entity.getRequiredIdProperty();
            Object id = entity.getIdentifierAccessor(objectToSave).getRequiredIdentifier();
            Query query = new Query(Criteria.where(idProperty.getName()).is(id).and(property.getName()).is(number));
            UpdateResult result = this.doUpdate(collectionName, query, update, objectToSave.getClass(), false, false);
            if (result.getModifiedCount() == 0L) {
                throw new OptimisticLockingFailureException(String.format("Cannot save entity %s with version %s to collection %s. Has it been modified meanwhile?", id, number, collectionName));
            }
            this.maybeEmitEvent(new AfterSaveEvent<T>(objectToSave, document, collectionName));
            return objectToSave;
        }
        this.doInsert(collectionName, objectToSave, this.mongoConverter);
        return objectToSave;
    }

    protected <T> T doSave(String collectionName, T objectToSave, MongoWriter<T> writer) {
        this.maybeEmitEvent(new BeforeConvertEvent<T>(objectToSave, collectionName));
        this.assertUpdateableIdIfNotSet(objectToSave);
        Document dbDoc = this.toDocument(objectToSave, writer);
        this.maybeEmitEvent(new BeforeSaveEvent<T>(objectToSave, dbDoc, collectionName));
        Object id = this.saveDocument(collectionName, dbDoc, objectToSave.getClass());
        this.populateIdIfNecessary(objectToSave, id);
        this.maybeEmitEvent(new AfterSaveEvent<T>(objectToSave, dbDoc, collectionName));
        return objectToSave;
    }

    protected Object insertDocument(final String collectionName, final Document document, final Class<?> entityClass) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Inserting Document containing fields: {} in collection: {}", (Object)document.keySet(), (Object)collectionName);
        }
        return this.execute(collectionName, new CollectionCallback<Object>(){

            @Override
            public Object doInCollection(MongoCollection<Document> collection) throws MongoException, DataAccessException {
                MongoAction mongoAction = new MongoAction(MongoTemplate.this.writeConcern, MongoActionOperation.INSERT, collectionName, entityClass, document, null);
                WriteConcern writeConcernToUse = MongoTemplate.this.prepareWriteConcern(mongoAction);
                if (writeConcernToUse == null) {
                    collection.insertOne((Object)document);
                } else {
                    collection.withWriteConcern(writeConcernToUse).insertOne((Object)document);
                }
                return document.get((Object)MongoTemplate.ID_FIELD);
            }
        });
    }

    protected List<Object> insertDocumentList(String collectionName, List<Document> documents) {
        if (documents.isEmpty()) {
            return Collections.emptyList();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Inserting list of Documents containing {} items", (Object)documents.size());
        }
        this.execute(collectionName, (MongoCollection<Document> collection) -> {
            MongoAction mongoAction = new MongoAction(this.writeConcern, MongoActionOperation.INSERT_LIST, collectionName, null, null, null);
            WriteConcern writeConcernToUse = this.prepareWriteConcern(mongoAction);
            if (writeConcernToUse == null) {
                collection.insertMany(documents);
            } else {
                collection.withWriteConcern(writeConcernToUse).insertMany(documents);
            }
            return null;
        });
        return (List)documents.stream().map(it -> it.get((Object)ID_FIELD)).collect(StreamUtils.toUnmodifiableList());
    }

    protected Object saveDocument(final String collectionName, final Document dbDoc, final Class<?> entityClass) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Saving Document containing fields: {}", (Object)dbDoc.keySet());
        }
        return this.execute(collectionName, new CollectionCallback<Object>(){

            @Override
            public Object doInCollection(MongoCollection<Document> collection) throws MongoException, DataAccessException {
                MongoAction mongoAction = new MongoAction(MongoTemplate.this.writeConcern, MongoActionOperation.SAVE, collectionName, entityClass, dbDoc, null);
                WriteConcern writeConcernToUse = MongoTemplate.this.prepareWriteConcern(mongoAction);
                if (!dbDoc.containsKey((Object)MongoTemplate.ID_FIELD)) {
                    if (writeConcernToUse == null) {
                        collection.insertOne((Object)dbDoc);
                    } else {
                        collection.withWriteConcern(writeConcernToUse).insertOne((Object)dbDoc);
                    }
                } else if (writeConcernToUse == null) {
                    collection.replaceOne(Filters.eq((String)MongoTemplate.ID_FIELD, (Object)dbDoc.get((Object)MongoTemplate.ID_FIELD)), (Object)dbDoc, new UpdateOptions().upsert(true));
                } else {
                    collection.withWriteConcern(writeConcernToUse).replaceOne(Filters.eq((String)MongoTemplate.ID_FIELD, (Object)dbDoc.get((Object)MongoTemplate.ID_FIELD)), (Object)dbDoc, new UpdateOptions().upsert(true));
                }
                return dbDoc.get((Object)MongoTemplate.ID_FIELD);
            }
        });
    }

    @Override
    public UpdateResult upsert(Query query, Update update, Class<?> entityClass) {
        return this.doUpdate(this.determineCollectionName(entityClass), query, update, entityClass, true, false);
    }

    @Override
    public UpdateResult upsert(Query query, Update update, String collectionName) {
        return this.doUpdate(collectionName, query, update, null, true, false);
    }

    @Override
    public UpdateResult upsert(Query query, Update update, Class<?> entityClass, String collectionName) {
        Assert.notNull(entityClass, (String)"EntityClass must not be null!");
        return this.doUpdate(collectionName, query, update, entityClass, true, false);
    }

    @Override
    public UpdateResult updateFirst(Query query, Update update, Class<?> entityClass) {
        return this.doUpdate(this.determineCollectionName(entityClass), query, update, entityClass, false, false);
    }

    @Override
    public UpdateResult updateFirst(Query query, Update update, String collectionName) {
        return this.doUpdate(collectionName, query, update, null, false, false);
    }

    @Override
    public UpdateResult updateFirst(Query query, Update update, Class<?> entityClass, String collectionName) {
        Assert.notNull(entityClass, (String)"EntityClass must not be null!");
        return this.doUpdate(collectionName, query, update, entityClass, false, false);
    }

    @Override
    public UpdateResult updateMulti(Query query, Update update, Class<?> entityClass) {
        return this.doUpdate(this.determineCollectionName(entityClass), query, update, entityClass, false, true);
    }

    @Override
    public UpdateResult updateMulti(Query query, Update update, String collectionName) {
        return this.doUpdate(collectionName, query, update, null, false, true);
    }

    @Override
    public UpdateResult updateMulti(Query query, Update update, Class<?> entityClass, String collectionName) {
        Assert.notNull(entityClass, (String)"EntityClass must not be null!");
        return this.doUpdate(collectionName, query, update, entityClass, false, true);
    }

    protected UpdateResult doUpdate(final String collectionName, final Query query, final Update update, final @Nullable Class<?> entityClass, final boolean upsert, final boolean multi) {
        Assert.notNull((Object)collectionName, (String)"CollectionName must not be null!");
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Assert.notNull((Object)update, (String)"Update must not be null!");
        return this.execute(collectionName, new CollectionCallback<UpdateResult>(){

            @Override
            public UpdateResult doInCollection(MongoCollection<Document> collection) throws MongoException, DataAccessException {
                MongoAction mongoAction;
                WriteConcern writeConcernToUse;
                Document updateObj;
                MongoPersistentEntity entity = entityClass == null ? null : MongoTemplate.this.getPersistentEntity(entityClass);
                MongoTemplate.this.increaseVersionForUpdateIfNecessary(entity, update);
                UpdateOptions opts = new UpdateOptions();
                opts.upsert(upsert);
                Document queryObj = new Document();
                if (query != null) {
                    queryObj.putAll((Map)MongoTemplate.this.queryMapper.getMappedObject((Bson)query.getQueryObject(), entity));
                    query.getCollation().map(Collation::toMongoCollation).ifPresent(arg_0 -> ((UpdateOptions)opts).collation(arg_0));
                }
                Document document = updateObj = update == null ? new Document() : MongoTemplate.this.updateMapper.getMappedObject((Bson)update.getUpdateObject(), entity);
                if (multi && update.isIsolated().booleanValue() && !queryObj.containsKey((Object)"$isolated")) {
                    queryObj.put("$isolated", (Object)1);
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Calling update using query: {} and update: {} in collection: {}", new Object[]{SerializationUtils.serializeToJsonSafely(queryObj), SerializationUtils.serializeToJsonSafely(updateObj), collectionName});
                }
                MongoCollection mongoCollection = collection = (writeConcernToUse = MongoTemplate.this.prepareWriteConcern(mongoAction = new MongoAction(MongoTemplate.this.writeConcern, MongoActionOperation.UPDATE, collectionName, entityClass, updateObj, queryObj))) != null ? collection.withWriteConcern(writeConcernToUse) : collection;
                if (!UpdateMapper.isUpdateObject(updateObj)) {
                    return collection.replaceOne((Bson)queryObj, (Object)updateObj, opts);
                }
                if (multi) {
                    return collection.updateMany((Bson)queryObj, (Bson)updateObj, opts);
                }
                return collection.updateOne((Bson)queryObj, (Bson)updateObj, opts);
            }
        });
    }

    private void increaseVersionForUpdateIfNecessary(@Nullable MongoPersistentEntity<?> persistentEntity, Update update) {
        String versionFieldName;
        if (persistentEntity != null && persistentEntity.hasVersionProperty() && !update.modifies(versionFieldName = ((MongoPersistentProperty)persistentEntity.getRequiredVersionProperty()).getFieldName())) {
            update.inc(versionFieldName, 1L);
        }
    }

    @Override
    public DeleteResult remove(Object object) {
        Assert.notNull((Object)object, (String)"Object must not be null!");
        return this.remove(this.getIdQueryFor(object), object.getClass());
    }

    @Override
    public DeleteResult remove(Object object, String collectionName) {
        Assert.notNull((Object)object, (String)"Object must not be null!");
        Assert.hasText((String)collectionName, (String)"Collection name must not be null or empty!");
        return this.doRemove(collectionName, this.getIdQueryFor(object), object.getClass());
    }

    private Pair<String, Object> extractIdPropertyAndValue(Object object) {
        Assert.notNull((Object)object, (String)"Id cannot be extracted from 'null'.");
        Class<?> objectType = object.getClass();
        if (object instanceof Document) {
            return Pair.of((Object)ID_FIELD, (Object)((Document)object).get((Object)ID_FIELD));
        }
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(objectType);
        if (entity != null && entity.hasIdProperty()) {
            MongoPersistentProperty idProperty = (MongoPersistentProperty)entity.getIdProperty();
            return Pair.of((Object)idProperty.getFieldName(), (Object)entity.getPropertyAccessor(object).getProperty((PersistentProperty)idProperty));
        }
        throw new MappingException("No id property found for object of type " + objectType);
    }

    private Query getIdQueryFor(Object object) {
        Pair<String, Object> id = this.extractIdPropertyAndValue(object);
        return new Query(Criteria.where((String)id.getFirst()).is(id.getSecond()));
    }

    private Query getIdInQueryFor(Collection<?> objects) {
        Assert.notEmpty(objects, (String)"Cannot create Query for empty collection.");
        Iterator<?> it = objects.iterator();
        Pair<String, Object> pair = this.extractIdPropertyAndValue(it.next());
        ArrayList<Object> ids = new ArrayList<Object>(objects.size());
        ids.add(pair.getSecond());
        while (it.hasNext()) {
            ids.add(this.extractIdPropertyAndValue(it.next()).getSecond());
        }
        return new Query(Criteria.where((String)pair.getFirst()).in(ids));
    }

    private void assertUpdateableIdIfNotSet(Object value) {
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(value.getClass());
        if (entity != null && entity.hasIdProperty()) {
            MongoPersistentProperty property = (MongoPersistentProperty)entity.getRequiredIdProperty();
            Object propertyValue = entity.getPropertyAccessor(value).getProperty((PersistentProperty)property);
            if (propertyValue != null) {
                return;
            }
            if (!MongoSimpleTypes.AUTOGENERATED_ID_TYPES.contains(property.getType())) {
                throw new InvalidDataAccessApiUsageException(String.format("Cannot autogenerate id of type %s for entity of type %s!", property.getType().getName(), value.getClass().getName()));
            }
        }
    }

    @Override
    public DeleteResult remove(Query query, String collectionName) {
        return this.doRemove(collectionName, query, null);
    }

    @Override
    public DeleteResult remove(Query query, Class<?> entityClass) {
        return this.remove(query, entityClass, this.determineCollectionName(entityClass));
    }

    @Override
    public DeleteResult remove(Query query, Class<?> entityClass, String collectionName) {
        Assert.notNull(entityClass, (String)"EntityClass must not be null!");
        return this.doRemove(collectionName, query, entityClass);
    }

    protected <T> DeleteResult doRemove(final String collectionName, final Query query, final @Nullable Class<T> entityClass) {
        Assert.hasText((String)collectionName, (String)"Collection name must not be null or empty!");
        if (query == null) {
            throw new InvalidDataAccessApiUsageException("Query passed in to remove can't be null!");
        }
        final Document queryObject = query.getQueryObject();
        final MongoPersistentEntity<?> entity = this.getPersistentEntity(entityClass);
        return this.execute(collectionName, new CollectionCallback<DeleteResult>(){

            @Override
            public DeleteResult doInCollection(MongoCollection<Document> collection) throws MongoException, DataAccessException {
                MongoTemplate.this.maybeEmitEvent(new BeforeDeleteEvent(queryObject, entityClass, collectionName));
                Document mappedQuery = MongoTemplate.this.queryMapper.getMappedObject((Bson)queryObject, entity);
                DeleteOptions options = new DeleteOptions();
                query.getCollation().map(Collation::toMongoCollation).ifPresent(arg_0 -> ((DeleteOptions)options).collation(arg_0));
                MongoAction mongoAction = new MongoAction(MongoTemplate.this.writeConcern, MongoActionOperation.REMOVE, collectionName, entityClass, null, queryObject);
                WriteConcern writeConcernToUse = MongoTemplate.this.prepareWriteConcern(mongoAction);
                DeleteResult dr = null;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Remove using query: {} in collection: {}.", new Object[]{SerializationUtils.serializeToJsonSafely(mappedQuery), collectionName});
                }
                dr = writeConcernToUse == null ? collection.deleteMany((Bson)mappedQuery, options) : collection.withWriteConcern(writeConcernToUse).deleteMany((Bson)mappedQuery, options);
                MongoTemplate.this.maybeEmitEvent(new AfterDeleteEvent(queryObject, entityClass, collectionName));
                return dr;
            }
        });
    }

    @Override
    public <T> List<T> findAll(Class<T> entityClass) {
        return this.findAll(entityClass, this.determineCollectionName(entityClass));
    }

    @Override
    public <T> List<T> findAll(Class<T> entityClass, String collectionName) {
        return this.executeFindMultiInternal(new FindCallback(new Document(), new Document()), null, new ReadDocumentCallback<Object>(this.mongoConverter, entityClass, collectionName), collectionName);
    }

    @Override
    public <T> MapReduceResults<T> mapReduce(String inputCollectionName, String mapFunction, String reduceFunction, Class<T> entityClass) {
        return this.mapReduce(new Query(), inputCollectionName, mapFunction, reduceFunction, new MapReduceOptions().outputTypeInline(), entityClass);
    }

    @Override
    public <T> MapReduceResults<T> mapReduce(String inputCollectionName, String mapFunction, String reduceFunction, @Nullable MapReduceOptions mapReduceOptions, Class<T> entityClass) {
        return this.mapReduce(new Query(), inputCollectionName, mapFunction, reduceFunction, mapReduceOptions, entityClass);
    }

    @Override
    public <T> MapReduceResults<T> mapReduce(Query query, String inputCollectionName, String mapFunction, String reduceFunction, Class<T> entityClass) {
        return this.mapReduce(query, inputCollectionName, mapFunction, reduceFunction, new MapReduceOptions().outputTypeInline(), entityClass);
    }

    @Override
    public <T> MapReduceResults<T> mapReduce(Query query, String inputCollectionName, String mapFunction, String reduceFunction, @Nullable MapReduceOptions mapReduceOptions, Class<T> entityClass) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Assert.notNull((Object)inputCollectionName, (String)"InputCollectionName must not be null!");
        Assert.notNull(entityClass, (String)"EntityClass must not be null!");
        Assert.notNull((Object)reduceFunction, (String)"ReduceFunction must not be null!");
        Assert.notNull((Object)mapFunction, (String)"MapFunction must not be null!");
        String mapFunc = this.replaceWithResourceIfNecessary(mapFunction);
        String reduceFunc = this.replaceWithResourceIfNecessary(reduceFunction);
        MongoCollection<Document> inputCollection = this.getCollection(inputCollectionName);
        MapReduceIterable result = inputCollection.mapReduce(mapFunc, reduceFunc);
        if (query != null && result != null) {
            if (query.getLimit() > 0 && mapReduceOptions.getLimit() == null) {
                result = result.limit(query.getLimit());
            }
            if (query.getMeta() != null && query.getMeta().getMaxTimeMsec() != null) {
                result = result.maxTime(query.getMeta().getMaxTimeMsec().longValue(), TimeUnit.MILLISECONDS);
            }
            result = result.sort((Bson)this.getMappedSortObject(query, entityClass));
            result = result.filter((Bson)this.queryMapper.getMappedObject((Bson)query.getQueryObject(), Optional.empty()));
        }
        Optional<Collation> collation = query.getCollation();
        if (mapReduceOptions != null) {
            Optionals.ifAllPresent(collation, mapReduceOptions.getCollation(), (l, r) -> {
                throw new IllegalArgumentException("Both Query and MapReduceOptions define a collation. Please provide the collation only via one of the two.");
            });
            if (mapReduceOptions.getCollation().isPresent()) {
                collation = mapReduceOptions.getCollation();
            }
            if (!CollectionUtils.isEmpty(mapReduceOptions.getScopeVariables())) {
                result = result.scope((Bson)new Document(mapReduceOptions.getScopeVariables()));
            }
            if (mapReduceOptions.getLimit() != null && mapReduceOptions.getLimit() > 0) {
                result = result.limit(mapReduceOptions.getLimit().intValue());
            }
            if (mapReduceOptions.getFinalizeFunction().filter(StringUtils::hasText).isPresent()) {
                result = result.finalizeFunction(mapReduceOptions.getFinalizeFunction().get());
            }
            if (mapReduceOptions.getJavaScriptMode() != null) {
                result = result.jsMode(mapReduceOptions.getJavaScriptMode().booleanValue());
            }
            if (mapReduceOptions.getOutputSharded().isPresent()) {
                result = result.sharded(mapReduceOptions.getOutputSharded().get().booleanValue());
            }
        }
        result = collation.map(Collation::toMongoCollation).map(arg_0 -> ((MapReduceIterable)result).collation(arg_0)).orElse(result);
        ArrayList mappedResults = new ArrayList();
        ReadDocumentCallback<Object> callback = new ReadDocumentCallback<Object>(this.mongoConverter, entityClass, inputCollectionName);
        for (Document document : result) {
            mappedResults.add(callback.doWith(document));
        }
        return new MapReduceResults(mappedResults, new Document());
    }

    @Override
    public <T> GroupByResults<T> group(String inputCollectionName, GroupBy groupBy, Class<T> entityClass) {
        return this.group(null, inputCollectionName, groupBy, entityClass);
    }

    @Override
    public <T> GroupByResults<T> group(@Nullable Criteria criteria, String inputCollectionName, GroupBy groupBy, Class<T> entityClass) {
        Object initialObj;
        Document document = groupBy.getGroupByObject();
        document.put("ns", (Object)inputCollectionName);
        if (criteria == null) {
            document.put("cond", null);
        } else {
            document.put("cond", (Object)this.queryMapper.getMappedObject((Bson)criteria.getCriteriaObject(), Optional.empty()));
        }
        if (document.containsKey((Object)"initial") && (initialObj = document.get((Object)"initial")) instanceof String) {
            String initialAsString = this.replaceWithResourceIfNecessary((String)initialObj);
            document.put("initial", (Object)Document.parse((String)initialAsString));
        }
        if (document.containsKey((Object)"$reduce")) {
            document.put("$reduce", (Object)this.replaceWithResourceIfNecessary(document.get((Object)"$reduce").toString()));
        }
        if (document.containsKey((Object)"$keyf")) {
            document.put("$keyf", (Object)this.replaceWithResourceIfNecessary(document.get((Object)"$keyf").toString()));
        }
        if (document.containsKey((Object)"finalize")) {
            document.put("finalize", (Object)this.replaceWithResourceIfNecessary(document.get((Object)"finalize").toString()));
        }
        Document commandObject = new Document("group", (Object)document);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Executing Group with Document [{}]", (Object)SerializationUtils.serializeToJsonSafely(commandObject));
        }
        Document commandResult = this.executeCommand(commandObject);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Group command result = [{}]", (Object)commandResult);
        }
        Iterable resultSet = (Iterable)commandResult.get((Object)"retval");
        ArrayList mappedResults = new ArrayList();
        ReadDocumentCallback<Object> callback = new ReadDocumentCallback<Object>(this.mongoConverter, entityClass, inputCollectionName);
        for (Document resultDocument : resultSet) {
            mappedResults.add(callback.doWith(resultDocument));
        }
        return new GroupByResults(mappedResults, commandResult);
    }

    @Override
    public <O> AggregationResults<O> aggregate(TypedAggregation<?> aggregation, Class<O> outputType) {
        return this.aggregate(aggregation, this.determineCollectionName(aggregation.getInputType()), outputType);
    }

    @Override
    public <O> AggregationResults<O> aggregate(TypedAggregation<?> aggregation, String inputCollectionName, Class<O> outputType) {
        Assert.notNull(aggregation, (String)"Aggregation pipeline must not be null!");
        TypeBasedAggregationOperationContext context = new TypeBasedAggregationOperationContext(aggregation.getInputType(), this.mappingContext, this.queryMapper);
        return this.aggregate(aggregation, inputCollectionName, outputType, context);
    }

    @Override
    public <O> AggregationResults<O> aggregate(Aggregation aggregation, Class<?> inputType, Class<O> outputType) {
        return this.aggregate(aggregation, this.determineCollectionName(inputType), outputType, new TypeBasedAggregationOperationContext(inputType, this.mappingContext, this.queryMapper));
    }

    @Override
    public <O> AggregationResults<O> aggregate(Aggregation aggregation, String collectionName, Class<O> outputType) {
        return this.aggregate(aggregation, collectionName, outputType, null);
    }

    @Override
    public <O> CloseableIterator<O> aggregateStream(TypedAggregation<?> aggregation, String inputCollectionName, Class<O> outputType) {
        Assert.notNull(aggregation, (String)"Aggregation pipeline must not be null!");
        TypeBasedAggregationOperationContext context = new TypeBasedAggregationOperationContext(aggregation.getInputType(), this.mappingContext, this.queryMapper);
        return this.aggregateStream(aggregation, inputCollectionName, outputType, context);
    }

    @Override
    public <O> CloseableIterator<O> aggregateStream(TypedAggregation<?> aggregation, Class<O> outputType) {
        return this.aggregateStream(aggregation, this.determineCollectionName(aggregation.getInputType()), outputType);
    }

    @Override
    public <O> CloseableIterator<O> aggregateStream(Aggregation aggregation, Class<?> inputType, Class<O> outputType) {
        return this.aggregateStream(aggregation, this.determineCollectionName(inputType), outputType, new TypeBasedAggregationOperationContext(inputType, this.mappingContext, this.queryMapper));
    }

    @Override
    public <O> CloseableIterator<O> aggregateStream(Aggregation aggregation, String collectionName, Class<O> outputType) {
        return this.aggregateStream(aggregation, collectionName, outputType, null);
    }

    @Override
    public <T> List<T> findAllAndRemove(Query query, String collectionName) {
        return this.findAllAndRemove(query, Object.class, collectionName);
    }

    @Override
    public <T> List<T> findAllAndRemove(Query query, Class<T> entityClass) {
        return this.findAllAndRemove(query, entityClass, this.determineCollectionName(entityClass));
    }

    @Override
    public <T> List<T> findAllAndRemove(Query query, Class<T> entityClass, String collectionName) {
        return this.doFindAndDelete(collectionName, query, entityClass);
    }

    protected <T> List<T> doFindAndDelete(String collectionName, Query query, Class<T> entityClass) {
        List<T> result = this.find(query, entityClass, collectionName);
        if (!CollectionUtils.isEmpty(result)) {
            this.remove(this.getIdInQueryFor(result), entityClass, collectionName);
        }
        return result;
    }

    protected <O> AggregationResults<O> aggregate(Aggregation aggregation, String collectionName, Class<O> outputType, @Nullable AggregationOperationContext context) {
        Assert.hasText((String)collectionName, (String)"Collection name must not be null or empty!");
        Assert.notNull((Object)aggregation, (String)"Aggregation pipeline must not be null!");
        Assert.notNull(outputType, (String)"Output type must not be null!");
        AggregationOperationContext rootContext = context == null ? Aggregation.DEFAULT_CONTEXT : context;
        Document command = aggregation.toDocument(collectionName, rootContext);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Executing aggregation: {}", (Object)SerializationUtils.serializeToJsonSafely(command));
        }
        Document commandResult = this.executeCommand(command, this.readPreference);
        return new AggregationResults<O>(this.returnPotentiallyMappedResults(outputType, commandResult, collectionName), commandResult);
    }

    private <O> List<O> returnPotentiallyMappedResults(Class<O> outputType, Document commandResult, String collectionName) {
        Iterable resultSet = (Iterable)commandResult.get((Object)"result");
        if (resultSet == null) {
            return Collections.emptyList();
        }
        UnwrapAndReadDocumentCallback<Object> callback = new UnwrapAndReadDocumentCallback<Object>(this.mongoConverter, outputType, collectionName);
        ArrayList mappedResults = new ArrayList();
        for (Document document : resultSet) {
            mappedResults.add(callback.doWith(document));
        }
        return mappedResults;
    }

    protected <O> CloseableIterator<O> aggregateStream(Aggregation aggregation, String collectionName, Class<O> outputType, @Nullable AggregationOperationContext context) {
        Assert.hasText((String)collectionName, (String)"Collection name must not be null or empty!");
        Assert.notNull((Object)aggregation, (String)"Aggregation pipeline must not be null!");
        Assert.notNull(outputType, (String)"Output type must not be null!");
        AggregationOperationContext rootContext = context == null ? Aggregation.DEFAULT_CONTEXT : context;
        final Document command = aggregation.toDocument(collectionName, rootContext);
        this.assertNotExplain(command);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Streaming aggregation: {}", (Object)SerializationUtils.serializeToJsonSafely(command));
        }
        final ReadDocumentCallback<Object> readCallback = new ReadDocumentCallback<Object>(this.mongoConverter, outputType, collectionName);
        return (CloseableIterator)this.execute(collectionName, new CollectionCallback<CloseableIterator<O>>(){

            @Override
            public CloseableIterator<O> doInCollection(MongoCollection<Document> collection) throws MongoException, DataAccessException {
                List pipeline = (List)command.get((Object)"pipeline");
                AggregationOptions options = AggregationOptions.fromDocument(command);
                AggregateIterable cursor = collection.aggregate(pipeline).allowDiskUse(Boolean.valueOf(options.isAllowDiskUse())).useCursor(Boolean.valueOf(true));
                Integer cursorBatchSize = options.getCursorBatchSize();
                if (cursorBatchSize != null) {
                    cursor = cursor.batchSize(cursorBatchSize.intValue());
                }
                if (options.getCollation().isPresent()) {
                    cursor = cursor.collation(options.getCollation().map(Collation::toMongoCollation).get());
                }
                return new CloseableIterableCursorAdapter((MongoCursor<Document>)cursor.iterator(), MongoTemplate.this.exceptionTranslator, readCallback);
            }
        });
    }

    @Override
    public <T> ExecutableFindOperation.ExecutableFind<T> query(Class<T> domainType) {
        return new ExecutableFindOperationSupport(this).query(domainType);
    }

    @Override
    public <T> ExecutableUpdateOperation.ExecutableUpdate<T> update(Class<T> domainType) {
        return new ExecutableUpdateOperationSupport(this).update(domainType);
    }

    @Override
    public <T> ExecutableRemoveOperation.ExecutableRemove<T> remove(Class<T> domainType) {
        return new ExecutableRemoveOperationSupport(this).remove(domainType);
    }

    @Override
    public <T> ExecutableAggregationOperation.ExecutableAggregation<T> aggregateAndReturn(Class<T> domainType) {
        return new ExecutableAggregationOperationSupport(this).aggregateAndReturn(domainType);
    }

    @Override
    public <T> ExecutableInsertOperation.ExecutableInsert<T> insert(Class<T> domainType) {
        return new ExecutableInsertOperationSupport(this).insert(domainType);
    }

    private void assertNotExplain(Document command) {
        Boolean explain = (Boolean)command.get((Object)"explain", Boolean.class);
        if (explain != null && explain.booleanValue()) {
            throw new IllegalArgumentException("Can't use explain option with streaming!");
        }
    }

    protected String replaceWithResourceIfNecessary(String function) {
        String func = function;
        if (this.resourceLoader != null && ResourceUtils.isUrl((String)function)) {
            Resource functionResource = this.resourceLoader.getResource(func);
            if (!functionResource.exists()) {
                throw new InvalidDataAccessApiUsageException(String.format("Resource %s not found!", function));
            }
            try (Scanner scanner = null;){
                scanner = new Scanner(functionResource.getInputStream());
                String string = scanner.useDelimiter("\\A").next();
                return string;
            }
        }
        return func;
    }

    @Override
    public Set<String> getCollectionNames() {
        return this.execute(new DbCallback<Set<String>>(){

            @Override
            public Set<String> doInDB(MongoDatabase db) throws MongoException, DataAccessException {
                LinkedHashSet<String> result = new LinkedHashSet<String>();
                for (String name : db.listCollectionNames()) {
                    result.add(name);
                }
                return result;
            }
        });
    }

    public MongoDatabase getDb() {
        return this.mongoDbFactory.getDb();
    }

    protected <T> void maybeEmitEvent(MongoMappingEvent<T> event) {
        if (null != this.eventPublisher) {
            this.eventPublisher.publishEvent(event);
        }
    }

    protected MongoCollection<Document> doCreateCollection(final String collectionName, final Document collectionOptions) {
        return this.execute(new DbCallback<MongoCollection<Document>>(){

            @Override
            public MongoCollection<Document> doInDB(MongoDatabase db) throws MongoException, DataAccessException {
                CreateCollectionOptions co = new CreateCollectionOptions();
                if (collectionOptions.containsKey((Object)"capped")) {
                    co.capped(((Boolean)collectionOptions.get((Object)"capped")).booleanValue());
                }
                if (collectionOptions.containsKey((Object)"size")) {
                    co.sizeInBytes(((Number)collectionOptions.get((Object)"size")).longValue());
                }
                if (collectionOptions.containsKey((Object)"max")) {
                    co.maxDocuments(((Number)collectionOptions.get((Object)"max")).longValue());
                }
                if (collectionOptions.containsKey((Object)"collation")) {
                    co.collation(IndexConverters.fromDocument((Document)collectionOptions.get((Object)"collation", Document.class)));
                }
                db.createCollection(collectionName, co);
                MongoCollection coll = db.getCollection(collectionName, Document.class);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Created collection [{}]", (Object)coll.getNamespace().getCollectionName());
                }
                return coll;
            }
        });
    }

    protected <T> T doFindOne(String collectionName, Document query, Document fields, Class<T> entityClass) {
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(entityClass);
        Document mappedQuery = this.queryMapper.getMappedObject((Bson)query, entity);
        Document mappedFields = this.queryMapper.getMappedObject((Bson)fields, entity);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("findOne using query: {} fields: {} for class: {} in collection: {}", new Object[]{SerializationUtils.serializeToJsonSafely(query), mappedFields, entityClass, collectionName});
        }
        return (T)this.executeFindOneInternal(new FindOneCallback(mappedQuery, mappedFields), new ReadDocumentCallback<Object>(this.mongoConverter, entityClass, collectionName), collectionName);
    }

    protected <T> List<T> doFind(String collectionName, Document query, Document fields, Class<T> entityClass) {
        return this.doFind(collectionName, query, fields, entityClass, null, new ReadDocumentCallback<Object>(this.mongoConverter, entityClass, collectionName));
    }

    protected <T> List<T> doFind(String collectionName, Document query, Document fields, Class<T> entityClass, CursorPreparer preparer) {
        return this.doFind(collectionName, query, fields, entityClass, preparer, new ReadDocumentCallback<Object>(this.mongoConverter, entityClass, collectionName));
    }

    protected <S, T> List<T> doFind(String collectionName, Document query, Document fields, Class<S> entityClass, @Nullable CursorPreparer preparer, DocumentCallback<T> objectCallback) {
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(entityClass);
        Document mappedFields = this.queryMapper.getMappedFields(fields, entity);
        Document mappedQuery = this.queryMapper.getMappedObject((Bson)query, entity);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("find using query: {} fields: {} for class: {} in collection: {}", new Object[]{SerializationUtils.serializeToJsonSafely(mappedQuery), mappedFields, entityClass, collectionName});
        }
        return this.executeFindMultiInternal(new FindCallback(mappedQuery, mappedFields), preparer, objectCallback, collectionName);
    }

    <S, T> List<T> doFind(String collectionName, Document query, Document fields, Class<S> sourceClass, Class<T> targetClass, CursorPreparer preparer) {
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getRequiredPersistentEntity(sourceClass);
        Document mappedFields = this.getMappedFieldsObject(fields, entity, targetClass);
        Document mappedQuery = this.queryMapper.getMappedObject((Bson)query, entity);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("find using query: {} fields: {} for class: {} in collection: {}", new Object[]{SerializationUtils.serializeToJsonSafely(mappedQuery), mappedFields, sourceClass, collectionName});
        }
        return this.executeFindMultiInternal(new FindCallback(mappedQuery, mappedFields), preparer, new ProjectingReadCallback<S, T>(this.mongoConverter, sourceClass, targetClass, collectionName), collectionName);
    }

    protected Document convertToDocument(@Nullable CollectionOptions collectionOptions) {
        Document document = new Document();
        if (collectionOptions != null) {
            collectionOptions.getCapped().ifPresent(val -> document.put("capped", val));
            collectionOptions.getSize().ifPresent(val -> document.put("size", val));
            collectionOptions.getMaxDocuments().ifPresent(val -> document.put("max", val));
            collectionOptions.getCollation().ifPresent(val -> document.append("collation", (Object)val.toDocument()));
        }
        return document;
    }

    protected <T> T doFindAndRemove(String collectionName, Document query, Document fields, Document sort, @Nullable Collation collation, Class<T> entityClass) {
        MongoConverter readerToUse = this.mongoConverter;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("findAndRemove using query: {} fields: {} sort: {} for class: {} in collection: {}", new Object[]{SerializationUtils.serializeToJsonSafely(query), fields, sort, entityClass, collectionName});
        }
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(entityClass);
        return (T)this.executeFindOneInternal(new FindAndRemoveCallback(this.queryMapper.getMappedObject((Bson)query, entity), fields, sort, collation), new ReadDocumentCallback<Object>(readerToUse, entityClass, collectionName), collectionName);
    }

    protected <T> T doFindAndModify(String collectionName, Document query, Document fields, Document sort, Class<T> entityClass, Update update, @Nullable FindAndModifyOptions options) {
        MongoConverter readerToUse = this.mongoConverter;
        if (options == null) {
            options = new FindAndModifyOptions();
        }
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(entityClass);
        this.increaseVersionForUpdateIfNecessary(entity, update);
        Document mappedQuery = this.queryMapper.getMappedObject((Bson)query, entity);
        Document mappedUpdate = this.updateMapper.getMappedObject((Bson)update.getUpdateObject(), entity);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("findAndModify using query: {} fields: {} sort: {} for class: {} and update: {} in collection: {}", new Object[]{SerializationUtils.serializeToJsonSafely(mappedQuery), fields, sort, entityClass, SerializationUtils.serializeToJsonSafely(mappedUpdate), collectionName});
        }
        return (T)this.executeFindOneInternal(new FindAndModifyCallback(mappedQuery, fields, sort, mappedUpdate, options), new ReadDocumentCallback<Object>(readerToUse, entityClass, collectionName), collectionName);
    }

    protected void populateIdIfNecessary(Object savedObject, Object id) {
        if (id == null) {
            return;
        }
        if (savedObject instanceof Document) {
            Document document = (Document)savedObject;
            document.put(ID_FIELD, id);
            return;
        }
        MongoPersistentProperty idProperty = this.getIdPropertyFor(savedObject.getClass());
        if (idProperty != null) {
            ConversionService conversionService = this.mongoConverter.getConversionService();
            MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getRequiredPersistentEntity(savedObject.getClass());
            PersistentPropertyAccessor accessor = entity.getPropertyAccessor(savedObject);
            Object value = accessor.getProperty((PersistentProperty)idProperty);
            if (value == null) {
                new ConvertingPropertyAccessor(accessor, conversionService).setProperty((PersistentProperty)idProperty, id);
            }
        }
    }

    private MongoCollection<Document> getAndPrepareCollection(MongoDatabase db, String collectionName) {
        try {
            MongoCollection<Document> collection = db.getCollection(collectionName, Document.class);
            collection = this.prepareCollection(collection);
            return collection;
        }
        catch (RuntimeException e) {
            throw MongoTemplate.potentiallyConvertRuntimeException(e, this.exceptionTranslator);
        }
    }

    private <T> T executeFindOneInternal(CollectionCallback<Document> collectionCallback, DocumentCallback<T> objectCallback, String collectionName) {
        try {
            T result = objectCallback.doWith(collectionCallback.doInCollection(this.getAndPrepareCollection(this.getDb(), collectionName)));
            return result;
        }
        catch (RuntimeException e) {
            throw MongoTemplate.potentiallyConvertRuntimeException(e, this.exceptionTranslator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> List<T> executeFindMultiInternal(CollectionCallback<FindIterable<Document>> collectionCallback, @Nullable CursorPreparer preparer, DocumentCallback<T> objectCallback, String collectionName) {
        ArrayList<T> arrayList;
        block8: {
            MongoCursor cursor = null;
            try {
                FindIterable<Document> iterable = collectionCallback.doInCollection(this.getAndPrepareCollection(this.getDb(), collectionName));
                if (preparer != null) {
                    iterable = preparer.prepare(iterable);
                }
                cursor = iterable.iterator();
                ArrayList<T> result = new ArrayList<T>();
                while (cursor.hasNext()) {
                    Document object = (Document)cursor.next();
                    result.add(objectCallback.doWith(object));
                }
                arrayList = result;
                if (cursor == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (cursor != null) {
                        cursor.close();
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    throw MongoTemplate.potentiallyConvertRuntimeException(e, this.exceptionTranslator);
                }
            }
            cursor.close();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeQueryInternal(CollectionCallback<FindIterable<Document>> collectionCallback, @Nullable CursorPreparer preparer, DocumentCallbackHandler callbackHandler, String collectionName) {
        try (MongoCursor cursor = null;){
            FindIterable<Document> iterable = collectionCallback.doInCollection(this.getAndPrepareCollection(this.getDb(), collectionName));
            if (preparer != null) {
                iterable = preparer.prepare(iterable);
            }
            cursor = iterable.iterator();
            while (cursor.hasNext()) {
                callbackHandler.processDocument((Document)cursor.next());
            }
        }
        catch (RuntimeException e) {
            throw MongoTemplate.potentiallyConvertRuntimeException(e, this.exceptionTranslator);
        }
    }

    public PersistenceExceptionTranslator getExceptionTranslator() {
        return this.exceptionTranslator;
    }

    @Nullable
    private MongoPersistentEntity<?> getPersistentEntity(@Nullable Class<?> type) {
        return type != null ? (MongoPersistentEntity)this.mappingContext.getPersistentEntity(type) : null;
    }

    @Nullable
    private MongoPersistentProperty getIdPropertyFor(Class<?> type) {
        MongoPersistentEntity<?> persistentEntity = this.getPersistentEntity(type);
        return persistentEntity != null ? (MongoPersistentProperty)persistentEntity.getIdProperty() : null;
    }

    @Nullable
    private <T> String determineEntityCollectionName(@Nullable T obj) {
        if (null != obj) {
            return this.determineCollectionName(obj.getClass());
        }
        return null;
    }

    String determineCollectionName(@Nullable Class<?> entityClass) {
        if (entityClass == null) {
            throw new InvalidDataAccessApiUsageException("No class parameter provided, entity collection can't be determined!");
        }
        return ((MongoPersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass)).getCollection();
    }

    private static MongoConverter getDefaultMongoConverter(MongoDbFactory factory) {
        DefaultDbRefResolver dbRefResolver = new DefaultDbRefResolver(factory);
        MongoCustomConversions conversions = new MongoCustomConversions(Collections.emptyList());
        MongoMappingContext mappingContext = new MongoMappingContext();
        mappingContext.setSimpleTypeHolder(conversions.getSimpleTypeHolder());
        mappingContext.afterPropertiesSet();
        MappingMongoConverter converter = new MappingMongoConverter(dbRefResolver, (MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty>)mappingContext);
        converter.setCustomConversions(conversions);
        converter.afterPropertiesSet();
        return converter;
    }

    private Document getMappedSortObject(Query query, Class<?> type) {
        if (query == null || ObjectUtils.isEmpty((Object)query.getSortObject())) {
            return null;
        }
        return this.queryMapper.getMappedSort(query.getSortObject(), (MongoPersistentEntity)this.mappingContext.getPersistentEntity(type));
    }

    private Document getMappedFieldsObject(Document fields, MongoPersistentEntity<?> entity, Class<?> targetType) {
        return this.queryMapper.getMappedFields(this.addFieldsForProjection(fields, entity.getType(), targetType), entity);
    }

    private Document addFieldsForProjection(Document fields, Class<?> domainType, Class<?> targetType) {
        if (!fields.isEmpty() || !targetType.isInterface() || ClassUtils.isAssignable(domainType, targetType)) {
            return fields;
        }
        ProjectionInformation projectionInformation = this.projectionFactory.getProjectionInformation(targetType);
        if (projectionInformation.isClosed()) {
            projectionInformation.getInputProperties().forEach(it -> fields.append(it.getName(), (Object)1));
        }
        return fields;
    }

    static RuntimeException potentiallyConvertRuntimeException(RuntimeException ex, PersistenceExceptionTranslator exceptionTranslator) {
        DataAccessException resolved = exceptionTranslator.translateExceptionIfPossible(ex);
        return resolved == null ? ex : resolved;
    }

    public MongoDbFactory getMongoDbFactory() {
        return this.mongoDbFactory;
    }

    static {
        HashSet<String> iterableClasses = new HashSet<String>();
        iterableClasses.add(List.class.getName());
        iterableClasses.add(Collection.class.getName());
        iterableClasses.add(Iterator.class.getName());
        ITERABLE_CLASSES = Collections.unmodifiableCollection(iterableClasses);
    }

    static class CloseableIterableCursorAdapter<T>
    implements CloseableIterator<T> {
        @Nullable
        private volatile MongoCursor<Document> cursor;
        private PersistenceExceptionTranslator exceptionTranslator;
        private DocumentCallback<T> objectReadCallback;

        public CloseableIterableCursorAdapter(FindIterable<Document> cursor, PersistenceExceptionTranslator exceptionTranslator, DocumentCallback<T> objectReadCallback) {
            this.cursor = cursor.iterator();
            this.exceptionTranslator = exceptionTranslator;
            this.objectReadCallback = objectReadCallback;
        }

        public boolean hasNext() {
            MongoCursor<Document> cursor = this.cursor;
            if (cursor == null) {
                return false;
            }
            try {
                return cursor.hasNext();
            }
            catch (RuntimeException ex) {
                throw MongoTemplate.potentiallyConvertRuntimeException(ex, this.exceptionTranslator);
            }
        }

        @Nullable
        public T next() {
            if (this.cursor == null) {
                return null;
            }
            try {
                Document item = (Document)this.cursor.next();
                T converted = this.objectReadCallback.doWith(item);
                return converted;
            }
            catch (RuntimeException ex) {
                throw MongoTemplate.potentiallyConvertRuntimeException(ex, this.exceptionTranslator);
            }
        }

        public void close() {
            MongoCursor<Document> c = this.cursor;
            try {
                if (c != null) {
                    c.close();
                }
            }
            catch (RuntimeException ex) {
                throw MongoTemplate.potentiallyConvertRuntimeException(ex, this.exceptionTranslator);
            }
            finally {
                this.cursor = null;
                this.exceptionTranslator = null;
                this.objectReadCallback = null;
            }
        }

        @ConstructorProperties(value={"cursor", "exceptionTranslator", "objectReadCallback"})
        CloseableIterableCursorAdapter(@Nullable MongoCursor<Document> cursor, PersistenceExceptionTranslator exceptionTranslator, DocumentCallback<T> objectReadCallback) {
            this.cursor = cursor;
            this.exceptionTranslator = exceptionTranslator;
            this.objectReadCallback = objectReadCallback;
        }
    }

    static class GeoNearResultDocumentCallback<T>
    implements DocumentCallback<GeoResult<T>> {
        private final DocumentCallback<T> delegate;
        private final Metric metric;

        public GeoNearResultDocumentCallback(DocumentCallback<T> delegate, Metric metric) {
            Assert.notNull(delegate, (String)"DocumentCallback must not be null!");
            this.delegate = delegate;
            this.metric = metric;
        }

        @Override
        @Nullable
        public GeoResult<T> doWith(@Nullable Document object) {
            double distance = (Double)object.get((Object)"dis");
            Document content = (Document)object.get((Object)"obj");
            T doWith = this.delegate.doWith(content);
            return new GeoResult(doWith, new Distance(distance, this.metric));
        }
    }

    class QueryCursorPreparer
    implements CursorPreparer {
        @Nullable
        private final Query query;
        @Nullable
        private final Class<?> type;

        public QueryCursorPreparer(@Nullable Query query, Class<?> type) {
            this.query = query;
            this.type = type;
        }

        @Override
        public FindIterable<Document> prepare(FindIterable<Document> cursor) {
            if (this.query == null) {
                return cursor;
            }
            if (this.query.getSkip() <= 0L && this.query.getLimit() <= 0 && ObjectUtils.isEmpty((Object)this.query.getSortObject()) && !StringUtils.hasText((String)this.query.getHint()) && !this.query.getMeta().hasValues() && !this.query.getCollation().isPresent()) {
                return cursor;
            }
            FindIterable cursorToUse = this.query.getCollation().map(Collation::toMongoCollation).map(arg_0 -> cursor.collation(arg_0)).orElse(cursor);
            try {
                if (this.query.getSkip() > 0L) {
                    cursorToUse = cursorToUse.skip((int)this.query.getSkip());
                }
                if (this.query.getLimit() > 0) {
                    cursorToUse = cursorToUse.limit(this.query.getLimit());
                }
                if (!ObjectUtils.isEmpty((Object)this.query.getSortObject())) {
                    Document sort = this.type != null ? MongoTemplate.this.getMappedSortObject(this.query, this.type) : this.query.getSortObject();
                    cursorToUse = cursorToUse.sort((Bson)sort);
                }
                Document meta = new Document();
                if (StringUtils.hasText((String)this.query.getHint())) {
                    meta.put("$hint", (Object)this.query.getHint());
                }
                if (this.query.getMeta().hasValues()) {
                    for (Map.Entry<String, Object> entry : this.query.getMeta().values()) {
                        meta.put(entry.getKey(), entry.getValue());
                    }
                    block7: for (Meta.CursorOption option : this.query.getMeta().getFlags()) {
                        switch (option) {
                            case NO_TIMEOUT: {
                                cursorToUse = cursorToUse.noCursorTimeout(true);
                                continue block7;
                            }
                            case PARTIAL: {
                                cursorToUse = cursorToUse.partial(true);
                                continue block7;
                            }
                        }
                        throw new IllegalArgumentException(String.format("%s is no supported flag.", new Object[]{option}));
                    }
                }
                cursorToUse = cursorToUse.modifiers((Bson)meta);
            }
            catch (RuntimeException e) {
                throw MongoTemplate.potentiallyConvertRuntimeException(e, MongoTemplate.this.exceptionTranslator);
            }
            return cursorToUse;
        }
    }

    class UnwrapAndReadDocumentCallback<T>
    extends ReadDocumentCallback<T> {
        public UnwrapAndReadDocumentCallback(EntityReader<? super T, Bson> reader, Class<T> type, String collectionName) {
            super(reader, type, collectionName);
        }

        @Override
        public T doWith(@Nullable Document object) {
            if (object == null) {
                return null;
            }
            Object idField = object.get((Object)MongoTemplate.ID_FIELD);
            if (!(idField instanceof Document)) {
                return super.doWith(object);
            }
            Document toMap = new Document();
            Document nested = (Document)idField;
            toMap.putAll((Map)nested);
            for (String key : object.keySet()) {
                if (MongoTemplate.ID_FIELD.equals(key)) continue;
                toMap.put(key, object.get((Object)key));
            }
            return super.doWith(toMap);
        }
    }

    private class ProjectingReadCallback<S, T>
    implements DocumentCallback<T> {
        @NonNull
        private final EntityReader<Object, Bson> reader;
        @NonNull
        private final Class<S> entityType;
        @NonNull
        private final Class<T> targetType;
        @NonNull
        private final String collectionName;

        @Override
        @Nullable
        public T doWith(@Nullable Document object) {
            Object result;
            if (object == null) {
                return null;
            }
            Class<S> typeToRead = this.targetType.isInterface() || this.targetType.isAssignableFrom(this.entityType) ? this.entityType : this.targetType;
            Object source = this.reader.read(typeToRead, (Object)object);
            Object object2 = result = this.targetType.isInterface() ? MongoTemplate.this.projectionFactory.createProjection(this.targetType, source) : source;
            if (result == null) {
                MongoTemplate.this.maybeEmitEvent(new AfterConvertEvent<Object>(object, result, this.collectionName));
            }
            return (T)result;
        }

        @ConstructorProperties(value={"reader", "entityType", "targetType", "collectionName"})
        public ProjectingReadCallback(@NonNull EntityReader<Object, Bson> reader, @NonNull Class<S> entityType, @NonNull Class<T> targetType, String collectionName) {
            if (reader == null) {
                throw new IllegalArgumentException("reader is null");
            }
            if (entityType == null) {
                throw new IllegalArgumentException("entityType is null");
            }
            if (targetType == null) {
                throw new IllegalArgumentException("targetType is null");
            }
            if (collectionName == null) {
                throw new IllegalArgumentException("collectionName is null");
            }
            this.reader = reader;
            this.entityType = entityType;
            this.targetType = targetType;
            this.collectionName = collectionName;
        }
    }

    private class ReadDocumentCallback<T>
    implements DocumentCallback<T> {
        private final EntityReader<? super T, Bson> reader;
        private final Class<T> type;
        private final String collectionName;

        public ReadDocumentCallback(EntityReader<? super T, Bson> reader, Class<T> type, String collectionName) {
            Assert.notNull(reader, (String)"EntityReader must not be null!");
            Assert.notNull(type, (String)"Entity type must not be null!");
            this.reader = reader;
            this.type = type;
            this.collectionName = collectionName;
        }

        @Override
        @Nullable
        public T doWith(Document object) {
            Object source;
            if (null != object) {
                MongoTemplate.this.maybeEmitEvent(new AfterLoadEvent<T>(object, this.type, this.collectionName));
            }
            if (null != (source = this.reader.read(this.type, (Object)object))) {
                MongoTemplate.this.maybeEmitEvent(new AfterConvertEvent<Object>(object, source, this.collectionName));
            }
            return (T)source;
        }
    }

    static interface DocumentCallback<T> {
        @Nullable
        public T doWith(@Nullable Document var1);
    }

    private static class FindAndModifyCallback
    implements CollectionCallback<Document> {
        private final Document query;
        private final Document fields;
        private final Document sort;
        private final Document update;
        private final FindAndModifyOptions options;

        public FindAndModifyCallback(Document query, Document fields, Document sort, Document update, FindAndModifyOptions options) {
            this.query = query;
            this.fields = fields;
            this.sort = sort;
            this.update = update;
            this.options = options;
        }

        @Override
        public Document doInCollection(MongoCollection<Document> collection) throws MongoException, DataAccessException {
            FindOneAndUpdateOptions opts = new FindOneAndUpdateOptions();
            opts.sort((Bson)this.sort);
            if (this.options.isUpsert()) {
                opts.upsert(true);
            }
            opts.projection((Bson)this.fields);
            if (this.options.isReturnNew()) {
                opts.returnDocument(ReturnDocument.AFTER);
            }
            this.options.getCollation().map(Collation::toMongoCollation).ifPresent(arg_0 -> ((FindOneAndUpdateOptions)opts).collation(arg_0));
            return (Document)collection.findOneAndUpdate((Bson)this.query, (Bson)this.update, opts);
        }
    }

    private static class FindAndRemoveCallback
    implements CollectionCallback<Document> {
        private final Document query;
        private final Document fields;
        private final Document sort;
        private final Optional<Collation> collation;

        public FindAndRemoveCallback(Document query, Document fields, Document sort, @Nullable Collation collation) {
            this.query = query;
            this.fields = fields;
            this.sort = sort;
            this.collation = Optional.ofNullable(collation);
        }

        @Override
        public Document doInCollection(MongoCollection<Document> collection) throws MongoException, DataAccessException {
            FindOneAndDeleteOptions opts = new FindOneAndDeleteOptions().sort((Bson)this.sort).projection((Bson)this.fields);
            this.collation.map(Collation::toMongoCollation).ifPresent(arg_0 -> ((FindOneAndDeleteOptions)opts).collation(arg_0));
            return (Document)collection.findOneAndDelete((Bson)this.query, opts);
        }
    }

    private static class ExistsCallback
    implements CollectionCallback<Boolean> {
        private final Document mappedQuery;
        private final com.mongodb.client.model.Collation collation;

        @Override
        public Boolean doInCollection(MongoCollection<Document> collection) throws MongoException, DataAccessException {
            return collection.count((Bson)this.mappedQuery, new CountOptions().limit(1).collation(this.collation)) > 0L;
        }

        @ConstructorProperties(value={"mappedQuery", "collation"})
        public ExistsCallback(Document mappedQuery, com.mongodb.client.model.Collation collation) {
            this.mappedQuery = mappedQuery;
            this.collation = collation;
        }
    }

    private static class FindCallback
    implements CollectionCallback<FindIterable<Document>> {
        private final Document query;
        private final Document fields;

        public FindCallback(Document query) {
            this(query, new Document());
        }

        public FindCallback(Document query, Document fields) {
            Assert.notNull((Object)query, (String)"Query must not be null!");
            Assert.notNull((Object)fields, (String)"Fields must not be null!");
            this.query = query;
            this.fields = fields;
        }

        @Override
        public FindIterable<Document> doInCollection(MongoCollection<Document> collection) throws MongoException, DataAccessException {
            return collection.find((Bson)this.query).projection((Bson)this.fields);
        }
    }

    private static class FindOneCallback
    implements CollectionCallback<Document> {
        private final Document query;
        private final Optional<Document> fields;

        public FindOneCallback(Document query, Document fields) {
            this.query = query;
            this.fields = Optional.of(fields).filter(it -> !ObjectUtils.isEmpty((Object)fields));
        }

        @Override
        public Document doInCollection(MongoCollection<Document> collection) throws MongoException, DataAccessException {
            FindIterable iterable = collection.find((Bson)this.query);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("findOne using query: {} fields: {} in db.collection: {}", new Object[]{SerializationUtils.serializeToJsonSafely(this.query), SerializationUtils.serializeToJsonSafely(this.fields.orElseGet(Document::new)), collection.getNamespace().getFullName()});
            }
            if (this.fields.isPresent()) {
                iterable = iterable.projection((Bson)this.fields.get());
            }
            return (Document)iterable.first();
        }
    }
}

