/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.aspects.support;

import java.util.ArrayList;
import java.util.Iterator;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.junit.internal.matchers.TypeSafeMatcher;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

class HasRelationshipMatcher
extends TypeSafeMatcher<Node> {
    private final String relationshipTypeName;
    private Node other;
    private Iterable<Relationship> relationships;

    HasRelationshipMatcher(String relationshipTypeName, Node other) {
        this.relationshipTypeName = relationshipTypeName;
        this.other = other;
    }

    public boolean matchesSafely(Node item) {
        this.relationships = item.getRelationships();
        if (this.other == null) {
            return this.getRelationships(item).hasNext();
        }
        for (Relationship relationship : this.relationships) {
            if (!relationship.getOtherNode(item).equals(this.other)) continue;
            return true;
        }
        return false;
    }

    public Iterator<Relationship> getRelationships(Node node) {
        return node.getRelationships(new RelationshipType[]{DynamicRelationshipType.withName((String)this.relationshipTypeName)}).iterator();
    }

    public void describeTo(Description description) {
        description.appendText("Expected relationship named " + this.relationshipTypeName + " to " + (this.other == null ? "unspecified" : this.other) + "\r\n    got: ");
        if (this.relationships == null) {
            description.appendValue((Object)"[]");
            return;
        }
        ArrayList<String> types = new ArrayList<String>();
        for (Relationship rel : this.relationships) {
            types.add(this.describeRelationship(rel));
        }
        description.appendValueList("[", ", ", "]", types);
    }

    private String describeRelationship(Relationship rel) {
        return rel.getType().name();
    }

    @Factory
    public static HasRelationshipMatcher hasRelationship(String typeName) {
        return new HasRelationshipMatcher(typeName, null);
    }

    @Factory
    public static HasRelationshipMatcher hasRelationship(String typeName, Node other) {
        return new HasRelationshipMatcher(typeName, other);
    }

    @Factory
    public static Matcher<Node> hasNoRelationship(String typeName, Node other) {
        return CoreMatchers.not((Matcher)new HasRelationshipMatcher(typeName, other));
    }
}

