/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.aspects.support;

import java.util.Date;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.NotFoundException;
import org.springframework.data.neo4j.aspects.Friendship;
import org.springframework.data.neo4j.aspects.Group;
import org.springframework.data.neo4j.aspects.Person;
import org.springframework.data.neo4j.aspects.Personality;
import org.springframework.data.neo4j.aspects.core.NodeBacked;
import org.springframework.data.neo4j.aspects.support.EntityTestBase;
import org.springframework.data.neo4j.aspects.support.node.Neo4jNodeBacking;
import org.springframework.test.annotation.Rollback;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.aspectj.AnnotationTransactionAspect;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:org/springframework/data/neo4j/aspects/support/Neo4jGraphPersistenceTests-context.xml"})
public class PropertyTests
extends EntityTestBase {
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;

    @Test
    @Transactional
    public void testSetPropertyEnum() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_0);
                Person p = Person.persistedPerson("Michael", 35);
                p.setPersonality(Personality.EXTROVERT);
                Assert.assertEquals((String)"Wrong enum serialization.", (Object)"EXTROVERT", (Object)this.getNodeState(p).getProperty("personality"));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testGetPropertyEnum() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_1);
                Person p = Person.persistedPerson("Michael", 35);
                this.getNodeState(p).setProperty("personality", (Object)"EXTROVERT");
                Assert.assertEquals((String)"Did not deserialize property value properly.", (Object)((Object)Personality.EXTROVERT), (Object)((Object)p.getPersonality()));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test(expected=NotFoundException.class)
    @Transactional
    public void testSetTransientPropertyFieldNotManaged() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_2);
                Person p = Person.persistedPerson("Michael", 35);
                p.setThought("food");
                this.getNodeState(p).getProperty("thought");
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testGetTransientPropertyFieldNotManaged() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_3);
                Person p = Person.persistedPerson("Michael", 35);
                p.setThought("food");
                this.getNodeState(p).setProperty("thought", (Object)"sleep");
                Assert.assertEquals((String)"Should not have read transient value from graph.", (Object)"food", (Object)p.getThought());
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    @Rollback(value=false)
    public void testRelationshipSetPropertyDate() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_4);
                Person p = Person.persistedPerson("Michael", 35);
                Person p2 = Person.persistedPerson("David", 25);
                Friendship f = p.knows(p2);
                f.setFirstMeetingDate(new Date(3L));
                Assert.assertEquals((String)"Date not serialized properly.", (Object)"3", (Object)this.getRelationshipState(f).getProperty("Friendship.firstMeetingDate"));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testRelationshipGetPropertyDate() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_5);
                Person p = Person.persistedPerson("Michael", 35);
                Person p2 = Person.persistedPerson("David", 25);
                Friendship f = p.knows(p2);
                this.getRelationshipState(f).setProperty("Friendship.firstMeetingDate", (Object)"3");
                Assert.assertEquals((String)"Date not deserialized properly.", (Object)new Date(3L), (Object)f.getFirstMeetingDate());
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test(expected=NotFoundException.class)
    @Transactional
    public void testRelationshipSetTransientPropertyFieldNotManaged() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_6);
                Person p = Person.persistedPerson("Michael", 35);
                Person p2 = Person.persistedPerson("David", 25);
                Friendship f = p.knows(p2);
                f.setLatestLocation("Menlo Park");
                this.getRelationshipState(f).getProperty("Friendship.latestLocation");
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testRelationshipGetTransientPropertyFieldNotManaged() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_7);
                Person p = Person.persistedPerson("Michael", 35);
                Person p2 = Person.persistedPerson("David", 25);
                Friendship f = p.knows(p2);
                f.setLatestLocation("Menlo Park");
                this.getRelationshipState(f).setProperty("Friendship.latestLocation", (Object)"Palo Alto");
                Assert.assertEquals((String)"Should not have read transient value from graph.", (Object)"Menlo Park", (Object)f.getLatestLocation());
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testEntityIdField() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_8);
                Person p = Person.persistedPerson("Michael", 35);
                Assert.assertEquals((String)"Wrong ID.", (long)this.getNodeState(p).getId(), (long)p.getId());
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testRelationshipIdField() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_9);
                Person p = Person.persistedPerson("Michael", 35);
                Person p2 = Person.persistedPerson("David", 25);
                Friendship f = p.knows(p2);
                Assert.assertEquals((String)"Wrong ID.", (Object)this.getRelationshipState(f).getId(), (Object)this.getRelationshipId(f));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    public void testGetDefaultValues() {
        Person p = Person.persistedPerson("Michael", 35);
        Assert.assertEquals((Object)((Object)Personality.EXTROVERT), (Object)((Object)p.getDefaultedPersonality()));
        Assert.assertEquals((Object)"defaultValue", (Object)p.getDefaultedName());
        Assert.assertEquals((long)0L, (long)p.getHeight().shortValue());
        Assert.assertEquals(null, (Object)p.getBirthdate());
    }

    @Test
    @Transactional
    public void testStoreConvertedValueAsDeclaredType() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_10);
                Group group = this.persist(new Group());
                Date date = new Date(10000L);
                group.setCreationDate(date);
                Long nodeId = Neo4jNodeBacking.ajc$interMethodDispatch1$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getNodeId((NodeBacked)group);
                Group found = (Group)this.groupRepository.findOne(nodeId);
                Assert.assertEquals((Object)date, (Object)found.getCreationDate());
                Long dateAsLong = ((Number)this.neo4jTemplate.getNode(nodeId.longValue()).getProperty("creationDate")).longValue();
                Assert.assertEquals((long)date.getTime(), (long)dateAsLong);
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    static {
        PropertyTests.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("PropertyTests.java", PropertyTests.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testSetPropertyEnum", "org.springframework.data.neo4j.aspects.support.PropertyTests", "", "", "", "void"), 43);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testGetPropertyEnum", "org.springframework.data.neo4j.aspects.support.PropertyTests", "", "", "", "void"), 51);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testStoreConvertedValueAsDeclaredType", "org.springframework.data.neo4j.aspects.support.PropertyTests", "", "", "", "void"), 142);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testSetTransientPropertyFieldNotManaged", "org.springframework.data.neo4j.aspects.support.PropertyTests", "", "", "", "void"), 59);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testGetTransientPropertyFieldNotManaged", "org.springframework.data.neo4j.aspects.support.PropertyTests", "", "", "", "void"), 67);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testRelationshipSetPropertyDate", "org.springframework.data.neo4j.aspects.support.PropertyTests", "", "", "", "void"), 76);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testRelationshipGetPropertyDate", "org.springframework.data.neo4j.aspects.support.PropertyTests", "", "", "", "void"), 86);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testRelationshipSetTransientPropertyFieldNotManaged", "org.springframework.data.neo4j.aspects.support.PropertyTests", "", "", "", "void"), 96);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testRelationshipGetTransientPropertyFieldNotManaged", "org.springframework.data.neo4j.aspects.support.PropertyTests", "", "", "", "void"), 106);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testEntityIdField", "org.springframework.data.neo4j.aspects.support.PropertyTests", "", "", "", "void"), 117);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testRelationshipIdField", "org.springframework.data.neo4j.aspects.support.PropertyTests", "", "", "", "void"), 124);
    }
}

