/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.aspects.support.path;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.Path;
import org.springframework.data.neo4j.aspects.support.EntityTestBase;
import org.springframework.data.neo4j.support.path.IterationController;
import org.springframework.data.neo4j.support.path.PathMapper;
import org.springframework.data.neo4j.support.path.PathMappingIterator;

public class PathMappingIteratorTests
extends EntityTestBase {
    private static final int PATHS_COUNT = 3;

    @Test
    public void lazyIteratorShouldNotCallBackBeforeUse() {
        this.runAndCheckMode(0, 3, IterationController.IterationMode.LAZY);
    }

    @Test
    public void eagerIteratorShouldBeCalledImmediately() {
        this.runAndCheckMode(3, 3, IterationController.IterationMode.EAGER);
    }

    @Test
    public void eagerStopOnNullIteratorShouldBeCalledImmediatelyAndReturnReducedResult() {
        this.runAndCheckMode(2, 2, IterationController.IterationMode.EAGER_STOP_ON_NULL);
    }

    @Test
    public void eagerStopIgnoresResultIteratorShouldBeCalledImmediatelyAndReturnNoResult() {
        Iterable<Integer> result = this.runAndCheckMode(3, 3, IterationController.IterationMode.EAGER_IGNORE_RESULTS);
        Assert.assertNull((String)"no result", result);
    }

    @Test
    public void defaultPathMapperIsLazy() {
        final AtomicInteger counter = new AtomicInteger();
        PathMapper<Integer> pathMapper = new PathMapper<Integer>(){

            public Integer mapPath(Path path) {
                return counter.incrementAndGet();
            }
        };
        Iterable result = new PathMappingIterator().mapPaths(this.paths(), (PathMapper)pathMapper);
        Assert.assertEquals((long)0L, (long)counter.get());
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            Integer cfr_ignored_0 = (Integer)iterator.next();
        }
        Assert.assertEquals((long)3L, (long)counter.get());
    }

    @Test
    public void defaultPathCallbackIsEagerAndIgnoresResult() {
        final AtomicInteger counter = new AtomicInteger();
        PathMapper.WithoutResult pathMapper = new PathMapper.WithoutResult(){

            public void eachPath(Path path) {
                counter.incrementAndGet();
            }
        };
        Iterable result = new PathMappingIterator().mapPaths(this.paths(), (PathMapper)pathMapper);
        Assert.assertEquals((long)3L, (long)counter.get());
        Assert.assertNull((String)"no result", (Object)result);
        Assert.assertEquals((long)3L, (long)counter.get());
    }

    private List<Path> paths() {
        Path anyPath = (Path)Mockito.mock(Path.class);
        Object[] paths = new Path[3];
        Arrays.fill(paths, anyPath);
        return Arrays.asList(paths);
    }

    private Iterable<Integer> runAndCheckMode(int countAfterMap, int countAfterIteration, IterationController.IterationMode iterationMode) {
        TestPathMapper pathMapper = new TestPathMapper(iterationMode);
        Iterable result = new PathMappingIterator().mapPaths(this.paths(), (PathMapper)pathMapper);
        Assert.assertEquals((long)countAfterMap, (long)pathMapper.counter);
        if (result != null) {
            Iterator iterator = result.iterator();
            while (iterator.hasNext()) {
                Integer cfr_ignored_0 = (Integer)iterator.next();
            }
        }
        Assert.assertEquals((long)countAfterIteration, (long)pathMapper.counter);
        return result;
    }

    private static class TestPathMapper
    implements PathMapper<Integer>,
    IterationController {
        public int counter;
        private IterationController.IterationMode iterationMode;

        public TestPathMapper(IterationController.IterationMode iterationMode) {
            this.iterationMode = iterationMode;
        }

        public Integer mapPath(Path path) {
            ++this.counter;
            if (this.counter == 2) {
                return null;
            }
            return this.counter;
        }

        public IterationController.IterationMode getIterationMode() {
            return this.iterationMode;
        }
    }
}

