/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.aspects.support.typerepresentation;

import java.util.Map;
import javax.persistence.Transient;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.neo4j.annotation.NodeEntity;
import org.springframework.data.neo4j.annotation.RelationshipEntity;
import org.springframework.data.neo4j.aspects.core.NodeBacked;
import org.springframework.data.neo4j.aspects.core.RelationshipBacked;
import org.springframework.data.neo4j.aspects.support.EntityTestBase;
import org.springframework.data.neo4j.aspects.support.node.Neo4jNodeBacking;
import org.springframework.data.neo4j.aspects.support.relationship.Neo4jRelationshipBacking;
import org.springframework.data.neo4j.core.EntityPath;
import org.springframework.data.neo4j.core.EntityState;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.typerepresentation.NoopNodeTypeRepresentationStrategy;
import org.springframework.data.neo4j.support.typerepresentation.NoopRelationshipTypeRepresentationStrategy;
import org.springframework.test.context.CleanContextCacheTestExecutionListener;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.test.context.transaction.TransactionalTestExecutionListener;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:org/springframework/data/neo4j/aspects/support/Neo4jGraphPersistenceTests-context.xml", "classpath:org/springframework/data/neo4j/aspects/support/NoopTypeRepresentationStrategyOverride-context.xml"})
@TestExecutionListeners(value={CleanContextCacheTestExecutionListener.class, DependencyInjectionTestExecutionListener.class, TransactionalTestExecutionListener.class})
public class NoopTypeRepresentationStrategyTests
extends EntityTestBase {
    @Autowired
    private NoopNodeTypeRepresentationStrategy noopNodeStrategy;
    @Autowired
    private NoopRelationshipTypeRepresentationStrategy noopRelationshipStrategy;
    private Thing thing;
    private Link link;

    @Before
    public void setUp() throws Exception {
        this.createThing();
    }

    @Test
    public void testPostEntityCreation() throws Exception {
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testFindAllForNodeStrategy() throws Exception {
        this.noopNodeStrategy.findAll(this.typeOf(Thing.class));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testFindAllForRelationshipStrategy() throws Exception {
        this.noopRelationshipStrategy.findAll(this.typeOf(Link.class));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testCountForNodeStrategy() throws Exception {
        this.noopNodeStrategy.count(this.typeOf(Thing.class));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testCountForRelationshipStrategy() throws Exception {
        this.noopRelationshipStrategy.count(this.typeOf(Link.class));
    }

    @Test
    public void testGetJavaTypeOnNodeStrategy() throws Exception {
        Assert.assertNull((Object)this.noopNodeStrategy.readAliasFrom(null));
    }

    @Test
    public void testGetJavaTypeOnRelationshipStrategy() throws Exception {
        Assert.assertNull((Object)this.noopRelationshipStrategy.readAliasFrom(null));
    }

    @Test
    public void testPreEntityRemoval() throws Exception {
        this.noopNodeStrategy.preEntityRemoval(this.node(this.thing));
        this.noopRelationshipStrategy.preEntityRemoval(this.rel(this.link));
    }

    private Node node(Thing thing) {
        return this.getNodeState(thing);
    }

    private Relationship rel(Link link) {
        return this.getRelationshipState(link);
    }

    private Thing createThing() {
        Transaction tx = this.neo4jTemplate.getGraphDatabase().beginTx();
        try {
            Node node = this.neo4jTemplate.createNode();
            this.thing = new Thing();
            this.neo4jTemplate.setPersistentState((Object)this.thing, (PropertyContainer)node);
            this.noopNodeStrategy.writeTypeTo(node, this.typeOf(Thing.class));
            Relationship rel = node.createRelationshipTo(this.neo4jTemplate.createNode(), (RelationshipType)DynamicRelationshipType.withName((String)"link"));
            this.link = new Link();
            this.neo4jTemplate.setPersistentState((Object)this.link, (PropertyContainer)rel);
            this.noopRelationshipStrategy.writeTypeTo(rel, this.typeOf(Link.class));
            tx.success();
            Thing thing = this.thing;
            return thing;
        }
        finally {
            tx.finish();
        }
    }

    @RelationshipEntity
    public static class Link
    implements RelationshipBacked {
        @Transient
        public transient EntityState<Relationship> entityState;

        public Link() {
            Neo4jRelationshipBacking.ajc$interFieldInit$org_springframework_data_neo4j_aspects_support_relationship_Neo4jRelationshipBacking$org_springframework_data_neo4j_aspects_core_RelationshipBacked$entityState((RelationshipBacked)this);
            if (!Neo4jRelationshipBacking.ajc$cflowCounter$0.isValid()) {
                Neo4jRelationshipBacking.aspectOf().ajc$before$org_springframework_data_neo4j_aspects_support_relationship_Neo4jRelationshipBacking$1$a152bd2f((RelationshipBacked)this);
            }
        }

        public /* synthetic */ EntityState ajc$interFieldGet$org_springframework_data_neo4j_aspects_support_relationship_Neo4jRelationshipBacking$org_springframework_data_neo4j_aspects_core_RelationshipBacked$entityState() {
            return this.entityState;
        }

        public /* synthetic */ void ajc$interFieldSet$org_springframework_data_neo4j_aspects_support_relationship_Neo4jRelationshipBacking$org_springframework_data_neo4j_aspects_core_RelationshipBacked$entityState(EntityState entityState) {
            this.entityState = entityState;
        }

        public final boolean equals(Object object) {
            return Neo4jRelationshipBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_relationship_Neo4jRelationshipBacking$org_springframework_data_neo4j_aspects_core_RelationshipBacked$equals((RelationshipBacked)this, (Object)object);
        }

        public EntityState<Relationship> getEntityState() {
            return Neo4jRelationshipBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_relationship_Neo4jRelationshipBacking$org_springframework_data_neo4j_aspects_core_RelationshipBacked$getEntityState((RelationshipBacked)this);
        }

        public Relationship getPersistentState() {
            return Neo4jRelationshipBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_relationship_Neo4jRelationshipBacking$org_springframework_data_neo4j_aspects_core_RelationshipBacked$getPersistentState((RelationshipBacked)this);
        }

        public Long getRelationshipId() {
            return Neo4jRelationshipBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_relationship_Neo4jRelationshipBacking$org_springframework_data_neo4j_aspects_core_RelationshipBacked$getRelationshipId((RelationshipBacked)this);
        }

        public Neo4jTemplate getTemplate() {
            return Neo4jRelationshipBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_relationship_Neo4jRelationshipBacking$org_springframework_data_neo4j_aspects_core_RelationshipBacked$getTemplate((RelationshipBacked)this);
        }

        public boolean hasPersistentState() {
            return Neo4jRelationshipBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_relationship_Neo4jRelationshipBacking$org_springframework_data_neo4j_aspects_core_RelationshipBacked$hasPersistentState((RelationshipBacked)this);
        }

        public final int hashCode() {
            return Neo4jRelationshipBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_relationship_Neo4jRelationshipBacking$org_springframework_data_neo4j_aspects_core_RelationshipBacked$hashCode((RelationshipBacked)this);
        }

        public <T extends RelationshipBacked> T persist() {
            return (T)Neo4jRelationshipBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_relationship_Neo4jRelationshipBacking$org_springframework_data_neo4j_aspects_core_RelationshipBacked$persist((RelationshipBacked)this);
        }

        public <R extends RelationshipBacked> R projectTo(Class<R> clazz) {
            return (R)Neo4jRelationshipBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_relationship_Neo4jRelationshipBacking$org_springframework_data_neo4j_aspects_core_RelationshipBacked$projectTo((RelationshipBacked)this, clazz);
        }

        public void remove() {
            Neo4jRelationshipBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_relationship_Neo4jRelationshipBacking$org_springframework_data_neo4j_aspects_core_RelationshipBacked$remove((RelationshipBacked)this);
        }

        public void setPersistentState(Relationship relationship) {
            Neo4jRelationshipBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_relationship_Neo4jRelationshipBacking$org_springframework_data_neo4j_aspects_core_RelationshipBacked$setPersistentState((RelationshipBacked)this, (Relationship)relationship);
        }
    }

    @NodeEntity
    public static class Thing
    implements NodeBacked {
        String name;
        @Transient
        public transient EntityState<Node> entityState;

        public Thing() {
            Neo4jNodeBacking.ajc$interFieldInit$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)this);
            if (!Neo4jNodeBacking.ajc$cflowCounter$0.isValid()) {
                Neo4jNodeBacking.aspectOf().ajc$before$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$1$74591ff9((NodeBacked)this);
            }
        }

        public /* synthetic */ EntityState ajc$interFieldGet$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState() {
            return this.entityState;
        }

        public /* synthetic */ void ajc$interFieldSet$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState(EntityState entityState) {
            this.entityState = entityState;
        }

        public boolean equals(Object object) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$equals((NodeBacked)this, (Object)object);
        }

        public <T> Iterable<T> findAllByQuery(String string, Class<T> clazz, Map<String, Object> map) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$findAllByQuery((NodeBacked)this, (String)string, clazz, map);
        }

        public Iterable<Map<String, Object>> findAllByQuery(String string, Map<String, Object> map) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$findAllByQuery((NodeBacked)this, (String)string, map);
        }

        public <T> Iterable<T> findAllByTraversal(Class<T> clazz, TraversalDescription traversalDescription) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$findAllByTraversal((NodeBacked)this, clazz, (TraversalDescription)traversalDescription);
        }

        public <S extends NodeBacked, E extends NodeBacked> Iterable<EntityPath<S, E>> findAllPathsByTraversal(TraversalDescription traversalDescription) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$findAllPathsByTraversal((NodeBacked)this, (TraversalDescription)traversalDescription);
        }

        public <T> T findByQuery(String string, Class<T> clazz, Map<String, Object> map) {
            return (T)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$findByQuery((NodeBacked)this, (String)string, clazz, map);
        }

        public EntityState<Node> getEntityState() {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getEntityState((NodeBacked)this);
        }

        public Long getNodeId() {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getNodeId((NodeBacked)this);
        }

        public Node getPersistentState() {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getPersistentState((NodeBacked)this);
        }

        public <R extends RelationshipBacked> R getRelationshipTo(NodeBacked nodeBacked, Class<R> clazz, String string) {
            return (R)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getRelationshipTo((NodeBacked)this, (NodeBacked)nodeBacked, clazz, (String)string);
        }

        public Relationship getRelationshipTo(NodeBacked nodeBacked, String string) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getRelationshipTo((NodeBacked)this, (NodeBacked)nodeBacked, (String)string);
        }

        public Neo4jTemplate getTemplate() {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getTemplate((NodeBacked)this);
        }

        public boolean hasPersistentState() {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$hasPersistentState((NodeBacked)this);
        }

        public int hashCode() {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$hashCode((NodeBacked)this);
        }

        public <T extends NodeBacked> T persist() {
            return (T)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$persist((NodeBacked)this);
        }

        public <T extends NodeBacked> T projectTo(Class<T> clazz) {
            return (T)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$projectTo((NodeBacked)this, clazz);
        }

        public <R extends RelationshipBacked, N extends NodeBacked> R relateTo(N n, Class<R> clazz, String string) {
            return (R)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$relateTo((NodeBacked)this, n, clazz, (String)string);
        }

        public <R extends RelationshipBacked, N extends NodeBacked> R relateTo(N n, Class<R> clazz, String string, boolean bl) {
            return (R)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$relateTo((NodeBacked)this, n, clazz, (String)string, (boolean)bl);
        }

        public Relationship relateTo(NodeBacked nodeBacked, String string) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$relateTo((NodeBacked)this, (NodeBacked)nodeBacked, (String)string);
        }

        public Relationship relateTo(NodeBacked nodeBacked, String string, boolean bl) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$relateTo((NodeBacked)this, (NodeBacked)nodeBacked, (String)string, (boolean)bl);
        }

        public void remove() {
            Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$remove((NodeBacked)this);
        }

        public void removeRelationshipTo(NodeBacked nodeBacked, String string) {
            Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$removeRelationshipTo((NodeBacked)this, (NodeBacked)nodeBacked, (String)string);
        }

        public void setPersistentState(Node node) {
            Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$setPersistentState((NodeBacked)this, (Node)node);
        }
    }
}

