/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.aspects.support;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javax.persistence.Transient;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.helpers.collection.IteratorUtil;
import org.springframework.data.neo4j.annotation.Indexed;
import org.springframework.data.neo4j.annotation.NodeEntity;
import org.springframework.data.neo4j.aspects.Friendship;
import org.springframework.data.neo4j.aspects.Group;
import org.springframework.data.neo4j.aspects.Person;
import org.springframework.data.neo4j.aspects.SubGroup;
import org.springframework.data.neo4j.aspects.core.NodeBacked;
import org.springframework.data.neo4j.aspects.core.RelationshipBacked;
import org.springframework.data.neo4j.aspects.support.EntityTestBase;
import org.springframework.data.neo4j.aspects.support.node.Neo4jNodeBacking;
import org.springframework.data.neo4j.conversion.EndResult;
import org.springframework.data.neo4j.core.EntityPath;
import org.springframework.data.neo4j.core.EntityState;
import org.springframework.data.neo4j.repository.GraphRepository;
import org.springframework.data.neo4j.support.DoReturn;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.index.IndexType;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.aspectj.AnnotationTransactionAspect;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:org/springframework/data/neo4j/aspects/support/Neo4jGraphPersistenceTests-context.xml"})
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_EACH_TEST_METHOD)
public class IndexTests
extends EntityTestBase {
    private static final String NAME = "name";
    private static final String NAME_VALUE = "aName";
    private static final String NAME_VALUE2 = "aSecondName";
    private static final String NAME_VALUE3 = "aThirdName";
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;

    @Test
    @Transactional
    public void testCanIndexIntFieldsOnRelationshipEntities() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_0);
                Person p = Person.persistedPerson(NAME_VALUE, 35);
                Person p2 = Person.persistedPerson(NAME_VALUE2, 25);
                Friendship friendship = p.knows(p2);
                friendship.setYears(1);
                GraphRepository friendshipFinder = this.neo4jTemplate.repositoryFor(Friendship.class);
                Assert.assertEquals((Object)friendship, (Object)friendshipFinder.findByPropertyValue("Friendship.years", (Object)1));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testGetRelationshipFromLookedUpNode() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_1);
                Person me = Person.persistedPerson(NAME_VALUE, 35);
                Person spouse = Person.persistedPerson(NAME_VALUE3, 36);
                me.setSpouse(spouse);
                Person foundMe = (Person)this.personRepository.findByPropertyValue("name-index", NAME, NAME_VALUE);
                Assert.assertEquals((Object)spouse, (Object)foundMe.getSpouse());
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    public void testRemovePropertyFromIndex() {
        Transaction tx = this.neo4jTemplate.getGraphDatabase().beginTx();
        try {
            Group group = this.persist(new Group());
            group.setName(NAME_VALUE);
            this.getGroupIndex().remove((PropertyContainer)this.getNodeState(group), NAME);
            tx.success();
        }
        finally {
            tx.finish();
        }
        Group found = (Group)this.groupRepository.findByPropertyValue(NAME, NAME_VALUE);
        Assert.assertNull((String)"Group.name removed from index", (Object)found);
    }

    @Test
    public void testRemoveNodeFromIndex() {
        Transaction tx = this.neo4jTemplate.getGraphDatabase().beginTx();
        try {
            Group group = this.persist(new Group());
            group.setName(NAME_VALUE);
            this.getGroupIndex().remove((PropertyContainer)this.getNodeState(group));
            tx.success();
        }
        finally {
            tx.finish();
        }
        Group found = (Group)this.groupRepository.findByPropertyValue(NAME, NAME_VALUE);
        Assert.assertNull((String)"Group.name removed from index", (Object)found);
    }

    private Index<Node> getGroupIndex() {
        return this.neo4jTemplate.getIndex(Group.class);
    }

    @Test
    @Transactional
    public void testFindGroupByIndex() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_2);
                Group group = this.persist(new Group());
                group.setName(NAME_VALUE);
                Group found = (Group)this.groupRepository.findByPropertyValue(NAME, NAME_VALUE);
                Assert.assertEquals((Object)group, (Object)found);
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testFindGroupByInstanceIndex() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_3);
                Group group = this.persist(new SubGroup());
                group.setIndexLevelName("indexLevelNameValue");
                Index subGroupIndex = this.neo4jTemplate.getIndex(SubGroup.class);
                Node found = (Node)subGroupIndex.get("indexLevelName", (Object)"indexLevelNameValue").getSingle();
                SubGroup foundEntity = (SubGroup)this.neo4jTemplate.createEntityFromState((PropertyContainer)found, SubGroup.class, this.neo4jTemplate.getMappingPolicy(SubGroup.class));
                Assert.assertEquals((Object)group, (Object)foundEntity);
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testFindGroupByAlternativeFieldNameIndex() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_4);
                Group group = this.persist(new Group());
                group.setOtherName(NAME_VALUE);
                Group found = (Group)this.groupRepository.findByPropertyValue("other_name", NAME_VALUE);
                Assert.assertEquals((Object)group, (Object)found);
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test(expected=IllegalStateException.class)
    @Transactional
    public void indexAccessWithFullAndNoSpatialIndexNameShouldFail() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_5);
                InvalidSpatialIndexed1 invalidIndexed = this.persist(new InvalidSpatialIndexed1());
                String latlon = "POINT (55 15)";
                invalidIndexed.setWkt(latlon);
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test(expected=IllegalStateException.class)
    @Transactional
    public void indexAccessWithDefaultSpatialIndexNameShouldFail() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_6);
                InvalidSpatialIndexed2 invalidIndexed = this.persist(new InvalidSpatialIndexed2());
                String latlon = "POINT (55 15)";
                invalidIndexed.setWkt(latlon);
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void indexAccessWithValidSpatialIndexName() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_7);
                InvalidSpatialIndexed3 invalidIndexed = this.persist(new InvalidSpatialIndexed3());
                String latlon = "POINT (55 15)";
                invalidIndexed.setWkt(latlon);
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test(expected=IllegalStateException.class)
    @Transactional
    public void indexAccessWithFullAndNoIndexNameShouldFail() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_8);
                InvalidIndexed invalidIndexed = this.persist(new InvalidIndexed());
                invalidIndexed.setFulltextNoIndexName(NAME_VALUE);
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test(expected=IllegalStateException.class)
    @Transactional
    public void indexAccessWithFullAndDefaultIndexNameShouldFail() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_9);
                InvalidIndexed invalidIndexed = this.persist(new InvalidIndexed());
                invalidIndexed.setFullTextDefaultIndexName(NAME_VALUE);
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testDontFindGroupByNonIndexedFieldWithAnnotation() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_10);
                Group group = this.persist(new Group());
                group.setUnindexedName("value-unindexedName");
                Group found = (Group)this.groupRepository.findByPropertyValue("unindexedName", "value-unindexedName");
                Assert.assertNull((Object)found);
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testDontFindGroupByNonIndexedField() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_11);
                Group group = this.persist(new Group());
                group.setUnindexedName2("value-unindexedName2");
                Group found = (Group)this.groupRepository.findByPropertyValue("unindexedName2", "value-unindexedName2");
                Assert.assertNull((Object)found);
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testFindAllGroupsByIndex() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_12);
                Group group = this.persist(new Group());
                group.setName(NAME_VALUE);
                Group group2 = this.persist(new Group());
                group2.setName(NAME_VALUE);
                EndResult found = this.groupRepository.findAllByPropertyValue(NAME, NAME_VALUE);
                Collection result = IteratorUtil.addToCollection(found.iterator(), new HashSet());
                Assert.assertEquals(new HashSet<Group>(Arrays.asList(group, group2)), (Object)result);
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testFindAllGroupsByNonNumericIndexedNumber() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_13);
                Group group = new Group();
                group.setSecret((byte)100);
                this.groupRepository.save(group);
                PropertyContainer node = this.neo4jTemplate.getPersistentState((Object)group);
                EndResult found = this.groupRepository.findAllByPropertyValue("secret", (byte)100);
                Assert.assertEquals((long)1L, (long)IteratorUtil.count((Iterable)found));
                Node foundWithTemplate = (Node)this.neo4jTemplate.lookup("Group", "secret", (Object)100).to(Node.class).singleOrNull();
                Assert.assertEquals((Object)node, (Object)foundWithTemplate);
                Node foundGroup = (Node)this.neo4jTemplate.getGraphDatabaseService().index().forNodes("Group").get("secret", (Object)100).getSingle();
                Assert.assertEquals((Object)node, (Object)foundGroup);
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void shouldFindGroupyByQueryString() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_14);
                Group group = this.persist(new Group());
                group.setFullTextName("queryableName");
                EndResult found = this.groupRepository.findAllByQuery("search-groups", "fullTextName", "queryable*");
                Collection result = IteratorUtil.addToCollection(found.iterator(), new HashSet());
                Assert.assertEquals(new HashSet<Group>(Arrays.asList(group)), (Object)result);
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testFindAllPersonByIndexOnAnnotatedField() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_15);
                Person person = Person.persistedPerson(NAME_VALUE, 35);
                Person found = (Person)this.personRepository.findByPropertyValue("name-index", NAME, NAME_VALUE);
                Assert.assertEquals((Object)person, (Object)found);
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    public void findsPersonByIndexOnAnnotatedIntFieldInSeparateTransactions() {
        Person person = Person.persistedPerson(NAME_VALUE, 35);
        Person found = (Person)this.personRepository.findByPropertyValue("age", 35);
        Assert.assertEquals((String)"person found inside range", (Object)person, (Object)found);
    }

    @Test
    @Transactional
    public void testRangeQueryPersonByIndexOnAnnotatedField() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_16);
                Person person = Person.persistedPerson(NAME_VALUE, 35);
                Person found = (Person)this.personRepository.findAllByRange("age", 10, 40).iterator().next();
                Assert.assertEquals((String)"person found inside range", (Object)person, (Object)found);
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testOutsideRangeQueryPersonByIndexOnAnnotatedField() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_17);
                Person.persistedPerson(NAME_VALUE, 35);
                EndResult emptyResult = this.personRepository.findAllByRange("age", 0, 34);
                Assert.assertFalse((String)"nothing found outside range", (boolean)emptyResult.iterator().hasNext());
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testFindAllPersonByIndexOnAnnotatedFieldWithAtIndexed() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_18);
                Person person = Person.persistedPerson(NAME_VALUE, 35);
                person.setNickname("Mike");
                Person found = (Person)this.personRepository.findByPropertyValue("nickname", "Mike");
                Assert.assertEquals((Object)person, (Object)found);
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testNodeIsIndexed() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_19);
                Node node = this.neo4jTemplate.createNode();
                node.setProperty(NAME, (Object)NAME_VALUE);
                Index nodeIndex = this.neo4jTemplate.getGraphDatabaseService().index().forNodes("node");
                nodeIndex.add((PropertyContainer)node, NAME, (Object)NAME_VALUE);
                Assert.assertEquals((String)"indexed node found", (Object)node, (Object)nodeIndex.get(NAME, (Object)NAME_VALUE).next());
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testNodeCanbBeIndexedTwice() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_20);
                Person p = Person.persistedPerson(NAME_VALUE2, 30);
                Assert.assertEquals((Object)p, (Object)this.personRepository.findByPropertyValue("name-index", NAME, NAME_VALUE2));
                p.setName(NAME_VALUE);
                Assert.assertEquals((Object)p, (Object)this.personRepository.findByPropertyValue("name-index", NAME, NAME_VALUE));
                p.setName(NAME_VALUE2);
                Assert.assertEquals((Object)p, (Object)this.personRepository.findByPropertyValue("name-index", NAME, NAME_VALUE2));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    public void testNodeCanbBeIndexedTwiceInDifferentTransactions() {
        Person p;
        Transaction tx = null;
        try {
            tx = this.neo4jTemplate.getGraphDatabase().beginTx();
            p = Person.persistedPerson(NAME_VALUE2, 30);
            tx.success();
        }
        finally {
            if (tx != null) {
                tx.finish();
            }
        }
        Assert.assertEquals((Object)p, (Object)this.personRepository.findByPropertyValue("name-index", NAME, NAME_VALUE2));
        try {
            tx = this.neo4jTemplate.getGraphDatabase().beginTx();
            p.setName(NAME_VALUE);
            tx.success();
        }
        finally {
            tx.finish();
        }
        Assert.assertEquals((Object)p, (Object)this.personRepository.findByPropertyValue("name-index", NAME, NAME_VALUE));
        try {
            tx = this.neo4jTemplate.getGraphDatabase().beginTx();
            p.setName(NAME_VALUE2);
            tx.success();
        }
        finally {
            tx.finish();
        }
        Assert.assertEquals((Object)p, (Object)this.personRepository.findByPropertyValue("name-index", NAME, NAME_VALUE2));
    }

    @Test
    @Transactional
    public void testRelationshipIsIndexed() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_21);
                Node node = this.neo4jTemplate.createNode();
                Node node2 = this.neo4jTemplate.createNode();
                Relationship indexedRelationship = node.createRelationshipTo(node2, (RelationshipType)DynamicRelationshipType.withName((String)"relatesTo"));
                indexedRelationship.setProperty(NAME, (Object)NAME_VALUE);
                RelationshipIndex relationshipIndex = this.neo4jTemplate.getGraphDatabaseService().index().forRelationships("relationship");
                relationshipIndex.add((PropertyContainer)indexedRelationship, NAME, (Object)NAME_VALUE);
                Assert.assertEquals((String)"indexed relationship found", (Object)indexedRelationship, (Object)relationshipIndex.get(NAME, (Object)NAME_VALUE).next());
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testUpdateBooleanPropertyIsReflectedInIndex() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_22);
                Group group = this.persist(new Group());
                group.setAdmin(true);
                Assert.assertEquals((long)1L, (long)IteratorUtil.asCollection((Iterable)this.groupRepository.findAllByPropertyValue("admin", true)).size());
                group.setAdmin(false);
                Assert.assertEquals((long)0L, (long)IteratorUtil.asCollection((Iterable)this.groupRepository.findAllByPropertyValue("admin", true)).size());
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    static {
        IndexTests.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("IndexTests.java", IndexTests.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testCanIndexIntFieldsOnRelationshipEntities", "org.springframework.data.neo4j.aspects.support.IndexTests", "", "", "", "void"), 69);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testGetRelationshipFromLookedUpNode", "org.springframework.data.neo4j.aspects.support.IndexTests", "", "", "", "void"), 81);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testDontFindGroupByNonIndexedFieldWithAnnotation", "org.springframework.data.neo4j.aspects.support.IndexTests", "", "", "", "void"), 247);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testDontFindGroupByNonIndexedField", "org.springframework.data.neo4j.aspects.support.IndexTests", "", "", "", "void"), 256);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testFindAllGroupsByIndex", "org.springframework.data.neo4j.aspects.support.IndexTests", "", "", "", "void"), 265);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testFindAllGroupsByNonNumericIndexedNumber", "org.springframework.data.neo4j.aspects.support.IndexTests", "", "", "", "void"), 277);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "shouldFindGroupyByQueryString", "org.springframework.data.neo4j.aspects.support.IndexTests", "", "", "", "void"), 293);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testFindAllPersonByIndexOnAnnotatedField", "org.springframework.data.neo4j.aspects.support.IndexTests", "", "", "", "void"), 303);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testRangeQueryPersonByIndexOnAnnotatedField", "org.springframework.data.neo4j.aspects.support.IndexTests", "", "", "", "void"), 318);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testOutsideRangeQueryPersonByIndexOnAnnotatedField", "org.springframework.data.neo4j.aspects.support.IndexTests", "", "", "", "void"), 326);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testFindAllPersonByIndexOnAnnotatedFieldWithAtIndexed", "org.springframework.data.neo4j.aspects.support.IndexTests", "", "", "", "void"), 335);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testNodeIsIndexed", "org.springframework.data.neo4j.aspects.support.IndexTests", "", "", "", "void"), 344);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testFindGroupByIndex", "org.springframework.data.neo4j.aspects.support.IndexTests", "", "", "", "void"), 129);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testNodeCanbBeIndexedTwice", "org.springframework.data.neo4j.aspects.support.IndexTests", "", "", "", "void"), 354);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testRelationshipIsIndexed", "org.springframework.data.neo4j.aspects.support.IndexTests", "", "", "", "void"), 394);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testUpdateBooleanPropertyIsReflectedInIndex", "org.springframework.data.neo4j.aspects.support.IndexTests", "", "", "", "void"), 406);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testFindGroupByInstanceIndex", "org.springframework.data.neo4j.aspects.support.IndexTests", "", "", "", "void"), 138);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testFindGroupByAlternativeFieldNameIndex", "org.springframework.data.neo4j.aspects.support.IndexTests", "", "", "", "void"), 149);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "indexAccessWithFullAndNoSpatialIndexNameShouldFail", "org.springframework.data.neo4j.aspects.support.IndexTests", "", "", "", "void"), 208);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "indexAccessWithDefaultSpatialIndexNameShouldFail", "org.springframework.data.neo4j.aspects.support.IndexTests", "", "", "", "void"), 216);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "indexAccessWithValidSpatialIndexName", "org.springframework.data.neo4j.aspects.support.IndexTests", "", "", "", "void"), 224);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "indexAccessWithFullAndNoIndexNameShouldFail", "org.springframework.data.neo4j.aspects.support.IndexTests", "", "", "", "void"), 232);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "indexAccessWithFullAndDefaultIndexNameShouldFail", "org.springframework.data.neo4j.aspects.support.IndexTests", "", "", "", "void"), 239);
    }

    @NodeEntity
    static class InvalidIndexed
    implements NodeBacked {
        @Indexed(indexType=IndexType.FULLTEXT)
        String fulltextNoIndexName;
        @Indexed(indexType=IndexType.FULLTEXT, indexName="InvalidIndexed")
        String fullTextDefaultIndexName;
        @Transient
        public transient EntityState<Node> entityState;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

        InvalidIndexed() {
            Neo4jNodeBacking.ajc$interFieldInit$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)this);
            if (!Neo4jNodeBacking.ajc$cflowCounter$0.isValid()) {
                Neo4jNodeBacking.aspectOf().ajc$before$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$1$74591ff9((NodeBacked)this);
            }
        }

        public void setFulltextNoIndexName(String fulltextNoIndexName) {
            String string = fulltextNoIndexName;
            InvalidIndexed invalidIndexed = this;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)invalidIndexed, (Object)string);
            InvalidIndexed.fulltextNoIndexName_aroundBody1$advice(this, invalidIndexed, string, joinPoint, Neo4jNodeBacking.aspectOf(), this, string, null, joinPoint);
        }

        public void setFullTextDefaultIndexName(String fullTextDefaultIndexName) {
            String string = fullTextDefaultIndexName;
            InvalidIndexed invalidIndexed = this;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)invalidIndexed, (Object)string);
            InvalidIndexed.fullTextDefaultIndexName_aroundBody3$advice(this, invalidIndexed, string, joinPoint, Neo4jNodeBacking.aspectOf(), this, string, null, joinPoint);
        }

        public /* synthetic */ EntityState ajc$interFieldGet$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState() {
            return this.entityState;
        }

        public /* synthetic */ void ajc$interFieldSet$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState(EntityState entityState) {
            this.entityState = entityState;
        }

        static {
            InvalidIndexed.ajc$preClinit();
        }

        private static final /* synthetic */ Object fulltextNoIndexName_aroundBody1$advice(InvalidIndexed ajc$this, InvalidIndexed target, String fulltextNoIndexName, JoinPoint thisJoinPoint, Neo4jNodeBacking ajc$aspectInstance, NodeBacked entity, Object newVal, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint2) {
            if (Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity) == null) {
                AroundClosure aroundClosure = ajc$aroundClosure;
                Object object = newVal;
                NodeBacked nodeBacked = entity;
                target.fulltextNoIndexName = (String)object;
                return null;
            }
            Object result = Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity).setValue(Neo4jNodeBacking.ajc$inlineAccessMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$field((Neo4jNodeBacking)ajc$aspectInstance, (JoinPoint)thisJoinPoint2), newVal, null);
            if (result instanceof DoReturn) {
                return DoReturn.unwrap((Object)result);
            }
            AroundClosure aroundClosure = ajc$aroundClosure;
            Object object = result;
            NodeBacked nodeBacked = entity;
            target.fulltextNoIndexName = (String)object;
            return null;
        }

        private static final /* synthetic */ Object fullTextDefaultIndexName_aroundBody3$advice(InvalidIndexed ajc$this, InvalidIndexed target, String fullTextDefaultIndexName, JoinPoint thisJoinPoint, Neo4jNodeBacking ajc$aspectInstance, NodeBacked entity, Object newVal, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint2) {
            if (Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity) == null) {
                AroundClosure aroundClosure = ajc$aroundClosure;
                Object object = newVal;
                NodeBacked nodeBacked = entity;
                target.fullTextDefaultIndexName = (String)object;
                return null;
            }
            Object result = Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity).setValue(Neo4jNodeBacking.ajc$inlineAccessMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$field((Neo4jNodeBacking)ajc$aspectInstance, (JoinPoint)thisJoinPoint2), newVal, null);
            if (result instanceof DoReturn) {
                return DoReturn.unwrap((Object)result);
            }
            AroundClosure aroundClosure = ajc$aroundClosure;
            Object object = result;
            NodeBacked nodeBacked = entity;
            target.fullTextDefaultIndexName = (String)object;
            return null;
        }

        public boolean equals(Object object) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$equals((NodeBacked)this, (Object)object);
        }

        public <T> Iterable<T> findAllByQuery(String string, Class<T> clazz, Map<String, Object> map) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$findAllByQuery((NodeBacked)this, (String)string, clazz, map);
        }

        public Iterable<Map<String, Object>> findAllByQuery(String string, Map<String, Object> map) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$findAllByQuery((NodeBacked)this, (String)string, map);
        }

        public <T> Iterable<T> findAllByTraversal(Class<T> clazz, TraversalDescription traversalDescription) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$findAllByTraversal((NodeBacked)this, clazz, (TraversalDescription)traversalDescription);
        }

        public <S extends NodeBacked, E extends NodeBacked> Iterable<EntityPath<S, E>> findAllPathsByTraversal(TraversalDescription traversalDescription) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$findAllPathsByTraversal((NodeBacked)this, (TraversalDescription)traversalDescription);
        }

        public <T> T findByQuery(String string, Class<T> clazz, Map<String, Object> map) {
            return (T)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$findByQuery((NodeBacked)this, (String)string, clazz, map);
        }

        public EntityState<Node> getEntityState() {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getEntityState((NodeBacked)this);
        }

        public Long getNodeId() {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getNodeId((NodeBacked)this);
        }

        public Node getPersistentState() {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getPersistentState((NodeBacked)this);
        }

        public <R extends RelationshipBacked> R getRelationshipTo(NodeBacked nodeBacked, Class<R> clazz, String string) {
            return (R)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getRelationshipTo((NodeBacked)this, (NodeBacked)nodeBacked, clazz, (String)string);
        }

        public Relationship getRelationshipTo(NodeBacked nodeBacked, String string) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getRelationshipTo((NodeBacked)this, (NodeBacked)nodeBacked, (String)string);
        }

        public Neo4jTemplate getTemplate() {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getTemplate((NodeBacked)this);
        }

        public boolean hasPersistentState() {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$hasPersistentState((NodeBacked)this);
        }

        public int hashCode() {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$hashCode((NodeBacked)this);
        }

        public <T extends NodeBacked> T persist() {
            return (T)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$persist((NodeBacked)this);
        }

        public <T extends NodeBacked> T projectTo(Class<T> clazz) {
            return (T)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$projectTo((NodeBacked)this, clazz);
        }

        public <R extends RelationshipBacked, N extends NodeBacked> R relateTo(N n, Class<R> clazz, String string) {
            return (R)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$relateTo((NodeBacked)this, n, clazz, (String)string);
        }

        public <R extends RelationshipBacked, N extends NodeBacked> R relateTo(N n, Class<R> clazz, String string, boolean bl) {
            return (R)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$relateTo((NodeBacked)this, n, clazz, (String)string, (boolean)bl);
        }

        public Relationship relateTo(NodeBacked nodeBacked, String string) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$relateTo((NodeBacked)this, (NodeBacked)nodeBacked, (String)string);
        }

        public Relationship relateTo(NodeBacked nodeBacked, String string, boolean bl) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$relateTo((NodeBacked)this, (NodeBacked)nodeBacked, (String)string, (boolean)bl);
        }

        public void remove() {
            Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$remove((NodeBacked)this);
        }

        public void removeRelationshipTo(NodeBacked nodeBacked, String string) {
            Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$removeRelationshipTo((NodeBacked)this, (NodeBacked)nodeBacked, (String)string);
        }

        public void setPersistentState(Node node) {
            Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$setPersistentState((NodeBacked)this, (Node)node);
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("IndexTests.java", InvalidIndexed.class);
            ajc$tjp_0 = factory.makeSJP("field-set", (Signature)factory.makeFieldSig("0", "fulltextNoIndexName", "org.springframework.data.neo4j.aspects.support.IndexTests$InvalidIndexed", "java.lang.String"), 166);
            ajc$tjp_1 = factory.makeSJP("field-set", (Signature)factory.makeFieldSig("0", "fullTextDefaultIndexName", "org.springframework.data.neo4j.aspects.support.IndexTests$InvalidIndexed", "java.lang.String"), 170);
        }
    }

    @NodeEntity
    static class InvalidSpatialIndexed1
    implements NodeBacked {
        @Indexed(indexType=IndexType.POINT, indexName="InvalidSpatialIndexed1")
        String wkt;
        @Transient
        public transient EntityState<Node> entityState;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        InvalidSpatialIndexed1() {
            Neo4jNodeBacking.ajc$interFieldInit$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)this);
            if (!Neo4jNodeBacking.ajc$cflowCounter$0.isValid()) {
                Neo4jNodeBacking.aspectOf().ajc$before$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$1$74591ff9((NodeBacked)this);
            }
        }

        public void setWkt(String wkt) {
            String string = wkt;
            InvalidSpatialIndexed1 invalidSpatialIndexed1 = this;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)invalidSpatialIndexed1, (Object)string);
            InvalidSpatialIndexed1.wkt_aroundBody1$advice(this, invalidSpatialIndexed1, string, joinPoint, Neo4jNodeBacking.aspectOf(), this, string, null, joinPoint);
        }

        public /* synthetic */ EntityState ajc$interFieldGet$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState() {
            return this.entityState;
        }

        public /* synthetic */ void ajc$interFieldSet$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState(EntityState entityState) {
            this.entityState = entityState;
        }

        static {
            InvalidSpatialIndexed1.ajc$preClinit();
        }

        private static final /* synthetic */ Object wkt_aroundBody1$advice(InvalidSpatialIndexed1 ajc$this, InvalidSpatialIndexed1 target, String wkt, JoinPoint thisJoinPoint, Neo4jNodeBacking ajc$aspectInstance, NodeBacked entity, Object newVal, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint2) {
            if (Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity) == null) {
                AroundClosure aroundClosure = ajc$aroundClosure;
                Object object = newVal;
                NodeBacked nodeBacked = entity;
                target.wkt = (String)object;
                return null;
            }
            Object result = Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity).setValue(Neo4jNodeBacking.ajc$inlineAccessMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$field((Neo4jNodeBacking)ajc$aspectInstance, (JoinPoint)thisJoinPoint2), newVal, null);
            if (result instanceof DoReturn) {
                return DoReturn.unwrap((Object)result);
            }
            AroundClosure aroundClosure = ajc$aroundClosure;
            Object object = result;
            NodeBacked nodeBacked = entity;
            target.wkt = (String)object;
            return null;
        }

        public boolean equals(Object object) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$equals((NodeBacked)this, (Object)object);
        }

        public <T> Iterable<T> findAllByQuery(String string, Class<T> clazz, Map<String, Object> map) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$findAllByQuery((NodeBacked)this, (String)string, clazz, map);
        }

        public Iterable<Map<String, Object>> findAllByQuery(String string, Map<String, Object> map) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$findAllByQuery((NodeBacked)this, (String)string, map);
        }

        public <T> Iterable<T> findAllByTraversal(Class<T> clazz, TraversalDescription traversalDescription) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$findAllByTraversal((NodeBacked)this, clazz, (TraversalDescription)traversalDescription);
        }

        public <S extends NodeBacked, E extends NodeBacked> Iterable<EntityPath<S, E>> findAllPathsByTraversal(TraversalDescription traversalDescription) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$findAllPathsByTraversal((NodeBacked)this, (TraversalDescription)traversalDescription);
        }

        public <T> T findByQuery(String string, Class<T> clazz, Map<String, Object> map) {
            return (T)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$findByQuery((NodeBacked)this, (String)string, clazz, map);
        }

        public EntityState<Node> getEntityState() {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getEntityState((NodeBacked)this);
        }

        public Long getNodeId() {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getNodeId((NodeBacked)this);
        }

        public Node getPersistentState() {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getPersistentState((NodeBacked)this);
        }

        public <R extends RelationshipBacked> R getRelationshipTo(NodeBacked nodeBacked, Class<R> clazz, String string) {
            return (R)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getRelationshipTo((NodeBacked)this, (NodeBacked)nodeBacked, clazz, (String)string);
        }

        public Relationship getRelationshipTo(NodeBacked nodeBacked, String string) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getRelationshipTo((NodeBacked)this, (NodeBacked)nodeBacked, (String)string);
        }

        public Neo4jTemplate getTemplate() {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getTemplate((NodeBacked)this);
        }

        public boolean hasPersistentState() {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$hasPersistentState((NodeBacked)this);
        }

        public int hashCode() {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$hashCode((NodeBacked)this);
        }

        public <T extends NodeBacked> T persist() {
            return (T)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$persist((NodeBacked)this);
        }

        public <T extends NodeBacked> T projectTo(Class<T> clazz) {
            return (T)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$projectTo((NodeBacked)this, clazz);
        }

        public <R extends RelationshipBacked, N extends NodeBacked> R relateTo(N n, Class<R> clazz, String string) {
            return (R)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$relateTo((NodeBacked)this, n, clazz, (String)string);
        }

        public <R extends RelationshipBacked, N extends NodeBacked> R relateTo(N n, Class<R> clazz, String string, boolean bl) {
            return (R)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$relateTo((NodeBacked)this, n, clazz, (String)string, (boolean)bl);
        }

        public Relationship relateTo(NodeBacked nodeBacked, String string) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$relateTo((NodeBacked)this, (NodeBacked)nodeBacked, (String)string);
        }

        public Relationship relateTo(NodeBacked nodeBacked, String string, boolean bl) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$relateTo((NodeBacked)this, (NodeBacked)nodeBacked, (String)string, (boolean)bl);
        }

        public void remove() {
            Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$remove((NodeBacked)this);
        }

        public void removeRelationshipTo(NodeBacked nodeBacked, String string) {
            Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$removeRelationshipTo((NodeBacked)this, (NodeBacked)nodeBacked, (String)string);
        }

        public void setPersistentState(Node node) {
            Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$setPersistentState((NodeBacked)this, (Node)node);
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("IndexTests.java", InvalidSpatialIndexed1.class);
            ajc$tjp_0 = factory.makeSJP("field-set", (Signature)factory.makeFieldSig("0", "wkt", "org.springframework.data.neo4j.aspects.support.IndexTests$InvalidSpatialIndexed1", "java.lang.String"), 181);
        }
    }

    @NodeEntity
    static class InvalidSpatialIndexed2
    implements NodeBacked {
        @Indexed(indexType=IndexType.POINT)
        String wkt;
        @Transient
        public transient EntityState<Node> entityState;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        InvalidSpatialIndexed2() {
            Neo4jNodeBacking.ajc$interFieldInit$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)this);
            if (!Neo4jNodeBacking.ajc$cflowCounter$0.isValid()) {
                Neo4jNodeBacking.aspectOf().ajc$before$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$1$74591ff9((NodeBacked)this);
            }
        }

        public void setWkt(String wkt) {
            String string = wkt;
            InvalidSpatialIndexed2 invalidSpatialIndexed2 = this;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)invalidSpatialIndexed2, (Object)string);
            InvalidSpatialIndexed2.wkt_aroundBody1$advice(this, invalidSpatialIndexed2, string, joinPoint, Neo4jNodeBacking.aspectOf(), this, string, null, joinPoint);
        }

        public /* synthetic */ EntityState ajc$interFieldGet$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState() {
            return this.entityState;
        }

        public /* synthetic */ void ajc$interFieldSet$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState(EntityState entityState) {
            this.entityState = entityState;
        }

        static {
            InvalidSpatialIndexed2.ajc$preClinit();
        }

        private static final /* synthetic */ Object wkt_aroundBody1$advice(InvalidSpatialIndexed2 ajc$this, InvalidSpatialIndexed2 target, String wkt, JoinPoint thisJoinPoint, Neo4jNodeBacking ajc$aspectInstance, NodeBacked entity, Object newVal, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint2) {
            if (Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity) == null) {
                AroundClosure aroundClosure = ajc$aroundClosure;
                Object object = newVal;
                NodeBacked nodeBacked = entity;
                target.wkt = (String)object;
                return null;
            }
            Object result = Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity).setValue(Neo4jNodeBacking.ajc$inlineAccessMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$field((Neo4jNodeBacking)ajc$aspectInstance, (JoinPoint)thisJoinPoint2), newVal, null);
            if (result instanceof DoReturn) {
                return DoReturn.unwrap((Object)result);
            }
            AroundClosure aroundClosure = ajc$aroundClosure;
            Object object = result;
            NodeBacked nodeBacked = entity;
            target.wkt = (String)object;
            return null;
        }

        public boolean equals(Object object) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$equals((NodeBacked)this, (Object)object);
        }

        public <T> Iterable<T> findAllByQuery(String string, Class<T> clazz, Map<String, Object> map) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$findAllByQuery((NodeBacked)this, (String)string, clazz, map);
        }

        public Iterable<Map<String, Object>> findAllByQuery(String string, Map<String, Object> map) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$findAllByQuery((NodeBacked)this, (String)string, map);
        }

        public <T> Iterable<T> findAllByTraversal(Class<T> clazz, TraversalDescription traversalDescription) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$findAllByTraversal((NodeBacked)this, clazz, (TraversalDescription)traversalDescription);
        }

        public <S extends NodeBacked, E extends NodeBacked> Iterable<EntityPath<S, E>> findAllPathsByTraversal(TraversalDescription traversalDescription) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$findAllPathsByTraversal((NodeBacked)this, (TraversalDescription)traversalDescription);
        }

        public <T> T findByQuery(String string, Class<T> clazz, Map<String, Object> map) {
            return (T)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$findByQuery((NodeBacked)this, (String)string, clazz, map);
        }

        public EntityState<Node> getEntityState() {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getEntityState((NodeBacked)this);
        }

        public Long getNodeId() {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getNodeId((NodeBacked)this);
        }

        public Node getPersistentState() {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getPersistentState((NodeBacked)this);
        }

        public <R extends RelationshipBacked> R getRelationshipTo(NodeBacked nodeBacked, Class<R> clazz, String string) {
            return (R)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getRelationshipTo((NodeBacked)this, (NodeBacked)nodeBacked, clazz, (String)string);
        }

        public Relationship getRelationshipTo(NodeBacked nodeBacked, String string) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getRelationshipTo((NodeBacked)this, (NodeBacked)nodeBacked, (String)string);
        }

        public Neo4jTemplate getTemplate() {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getTemplate((NodeBacked)this);
        }

        public boolean hasPersistentState() {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$hasPersistentState((NodeBacked)this);
        }

        public int hashCode() {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$hashCode((NodeBacked)this);
        }

        public <T extends NodeBacked> T persist() {
            return (T)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$persist((NodeBacked)this);
        }

        public <T extends NodeBacked> T projectTo(Class<T> clazz) {
            return (T)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$projectTo((NodeBacked)this, clazz);
        }

        public <R extends RelationshipBacked, N extends NodeBacked> R relateTo(N n, Class<R> clazz, String string) {
            return (R)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$relateTo((NodeBacked)this, n, clazz, (String)string);
        }

        public <R extends RelationshipBacked, N extends NodeBacked> R relateTo(N n, Class<R> clazz, String string, boolean bl) {
            return (R)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$relateTo((NodeBacked)this, n, clazz, (String)string, (boolean)bl);
        }

        public Relationship relateTo(NodeBacked nodeBacked, String string) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$relateTo((NodeBacked)this, (NodeBacked)nodeBacked, (String)string);
        }

        public Relationship relateTo(NodeBacked nodeBacked, String string, boolean bl) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$relateTo((NodeBacked)this, (NodeBacked)nodeBacked, (String)string, (boolean)bl);
        }

        public void remove() {
            Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$remove((NodeBacked)this);
        }

        public void removeRelationshipTo(NodeBacked nodeBacked, String string) {
            Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$removeRelationshipTo((NodeBacked)this, (NodeBacked)nodeBacked, (String)string);
        }

        public void setPersistentState(Node node) {
            Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$setPersistentState((NodeBacked)this, (Node)node);
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("IndexTests.java", InvalidSpatialIndexed2.class);
            ajc$tjp_0 = factory.makeSJP("field-set", (Signature)factory.makeFieldSig("0", "wkt", "org.springframework.data.neo4j.aspects.support.IndexTests$InvalidSpatialIndexed2", "java.lang.String"), 191);
        }
    }

    @NodeEntity
    static class InvalidSpatialIndexed3
    implements NodeBacked {
        @Indexed(indexType=IndexType.POINT, indexName="pointLayer")
        String wkt;
        @Transient
        public transient EntityState<Node> entityState;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        InvalidSpatialIndexed3() {
            Neo4jNodeBacking.ajc$interFieldInit$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)this);
            if (!Neo4jNodeBacking.ajc$cflowCounter$0.isValid()) {
                Neo4jNodeBacking.aspectOf().ajc$before$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$1$74591ff9((NodeBacked)this);
            }
        }

        public void setWkt(String wkt) {
            String string = wkt;
            InvalidSpatialIndexed3 invalidSpatialIndexed3 = this;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)invalidSpatialIndexed3, (Object)string);
            InvalidSpatialIndexed3.wkt_aroundBody1$advice(this, invalidSpatialIndexed3, string, joinPoint, Neo4jNodeBacking.aspectOf(), this, string, null, joinPoint);
        }

        public /* synthetic */ EntityState ajc$interFieldGet$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState() {
            return this.entityState;
        }

        public /* synthetic */ void ajc$interFieldSet$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState(EntityState entityState) {
            this.entityState = entityState;
        }

        static {
            InvalidSpatialIndexed3.ajc$preClinit();
        }

        private static final /* synthetic */ Object wkt_aroundBody1$advice(InvalidSpatialIndexed3 ajc$this, InvalidSpatialIndexed3 target, String wkt, JoinPoint thisJoinPoint, Neo4jNodeBacking ajc$aspectInstance, NodeBacked entity, Object newVal, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint2) {
            if (Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity) == null) {
                AroundClosure aroundClosure = ajc$aroundClosure;
                Object object = newVal;
                NodeBacked nodeBacked = entity;
                target.wkt = (String)object;
                return null;
            }
            Object result = Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity).setValue(Neo4jNodeBacking.ajc$inlineAccessMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$field((Neo4jNodeBacking)ajc$aspectInstance, (JoinPoint)thisJoinPoint2), newVal, null);
            if (result instanceof DoReturn) {
                return DoReturn.unwrap((Object)result);
            }
            AroundClosure aroundClosure = ajc$aroundClosure;
            Object object = result;
            NodeBacked nodeBacked = entity;
            target.wkt = (String)object;
            return null;
        }

        public boolean equals(Object object) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$equals((NodeBacked)this, (Object)object);
        }

        public <T> Iterable<T> findAllByQuery(String string, Class<T> clazz, Map<String, Object> map) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$findAllByQuery((NodeBacked)this, (String)string, clazz, map);
        }

        public Iterable<Map<String, Object>> findAllByQuery(String string, Map<String, Object> map) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$findAllByQuery((NodeBacked)this, (String)string, map);
        }

        public <T> Iterable<T> findAllByTraversal(Class<T> clazz, TraversalDescription traversalDescription) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$findAllByTraversal((NodeBacked)this, clazz, (TraversalDescription)traversalDescription);
        }

        public <S extends NodeBacked, E extends NodeBacked> Iterable<EntityPath<S, E>> findAllPathsByTraversal(TraversalDescription traversalDescription) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$findAllPathsByTraversal((NodeBacked)this, (TraversalDescription)traversalDescription);
        }

        public <T> T findByQuery(String string, Class<T> clazz, Map<String, Object> map) {
            return (T)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$findByQuery((NodeBacked)this, (String)string, clazz, map);
        }

        public EntityState<Node> getEntityState() {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getEntityState((NodeBacked)this);
        }

        public Long getNodeId() {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getNodeId((NodeBacked)this);
        }

        public Node getPersistentState() {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getPersistentState((NodeBacked)this);
        }

        public <R extends RelationshipBacked> R getRelationshipTo(NodeBacked nodeBacked, Class<R> clazz, String string) {
            return (R)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getRelationshipTo((NodeBacked)this, (NodeBacked)nodeBacked, clazz, (String)string);
        }

        public Relationship getRelationshipTo(NodeBacked nodeBacked, String string) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getRelationshipTo((NodeBacked)this, (NodeBacked)nodeBacked, (String)string);
        }

        public Neo4jTemplate getTemplate() {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getTemplate((NodeBacked)this);
        }

        public boolean hasPersistentState() {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$hasPersistentState((NodeBacked)this);
        }

        public int hashCode() {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$hashCode((NodeBacked)this);
        }

        public <T extends NodeBacked> T persist() {
            return (T)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$persist((NodeBacked)this);
        }

        public <T extends NodeBacked> T projectTo(Class<T> clazz) {
            return (T)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$projectTo((NodeBacked)this, clazz);
        }

        public <R extends RelationshipBacked, N extends NodeBacked> R relateTo(N n, Class<R> clazz, String string) {
            return (R)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$relateTo((NodeBacked)this, n, clazz, (String)string);
        }

        public <R extends RelationshipBacked, N extends NodeBacked> R relateTo(N n, Class<R> clazz, String string, boolean bl) {
            return (R)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$relateTo((NodeBacked)this, n, clazz, (String)string, (boolean)bl);
        }

        public Relationship relateTo(NodeBacked nodeBacked, String string) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$relateTo((NodeBacked)this, (NodeBacked)nodeBacked, (String)string);
        }

        public Relationship relateTo(NodeBacked nodeBacked, String string, boolean bl) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$relateTo((NodeBacked)this, (NodeBacked)nodeBacked, (String)string, (boolean)bl);
        }

        public void remove() {
            Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$remove((NodeBacked)this);
        }

        public void removeRelationshipTo(NodeBacked nodeBacked, String string) {
            Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$removeRelationshipTo((NodeBacked)this, (NodeBacked)nodeBacked, (String)string);
        }

        public void setPersistentState(Node node) {
            Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$setPersistentState((NodeBacked)this, (Node)node);
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("IndexTests.java", InvalidSpatialIndexed3.class);
            ajc$tjp_0 = factory.makeSJP("field-set", (Signature)factory.makeFieldSig("0", "wkt", "org.springframework.data.neo4j.aspects.support.IndexTests$InvalidSpatialIndexed3", "java.lang.String"), 202);
        }
    }
}

