/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.aspects.support;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import javax.validation.ValidationException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.data.neo4j.aspects.Attribute;
import org.springframework.data.neo4j.aspects.Group;
import org.springframework.data.neo4j.aspects.Person;
import org.springframework.data.neo4j.aspects.core.NodeBacked;
import org.springframework.data.neo4j.aspects.support.EntityTestBase;
import org.springframework.data.neo4j.aspects.support.node.Neo4jNodeBacking;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.aspectj.AnnotationTransactionAspect;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:org/springframework/data/neo4j/aspects/support/Neo4jGraphPersistenceTests-context.xml"})
public class NodeEntityTests
extends EntityTestBase {
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;

    @Test
    @Transactional
    public void testUserConstructor() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_0);
                Person p = Person.persistedPerson("Rod", 39);
                Assert.assertEquals((Object)p.getName(), (Object)this.getNodeState(p).getProperty("name"));
                Assert.assertEquals((Object)p.getAge(), (Object)this.getNodeState(p).getProperty("age"));
                Person found = (Person)this.neo4jTemplate.createEntityFromState((PropertyContainer)this.neo4jTemplate.getNode(this.getNodeId(p).longValue()), Person.class, this.neo4jTemplate.getMappingPolicy((Object)p));
                Assert.assertEquals((Object)"Rod", (Object)this.getNodeState(found).getProperty("name"));
                Assert.assertEquals((Object)39, (Object)this.getNodeState(found).getProperty("age"));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testSetSimpleProperties() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_1);
                String name = "Michael";
                int age = 35;
                short height = 182;
                Person p = Person.persistedPerson("Foo", 2);
                p.setName(name);
                p.setAge(age);
                p.setHeight(height);
                Assert.assertEquals((Object)name, (Object)this.getNodeState(p).getProperty("name"));
                Assert.assertEquals((Object)age, (Object)this.getNodeState(p).getProperty("age"));
                Assert.assertEquals((Object)height, (Object)p.getHeight());
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    public void testEntityIsStillDetachedAfterValidationException() {
        Person p = new Person("Foo", 2);
        try {
            p.setName("A");
            Neo4jNodeBacking.ajc$interMethodDispatch1$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$persist((NodeBacked)p);
            Assert.fail((String)"should fail to validate");
        }
        catch (ValidationException ve) {
            System.out.println(((Object)((Object)ve)).getClass());
        }
        Assert.assertEquals((Object)"A", (Object)p.getName());
    }

    @Test
    @Transactional
    public void testArrayProperties() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_2);
                Group g = (Group)Neo4jNodeBacking.ajc$interMethodDispatch1$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$persist((NodeBacked)new Group());
                Object[] roleNames = new String[]{"a", "b", "c"};
                g.setRoleNames((String[])roleNames);
                Assert.assertArrayEquals((Object[])roleNames, (Object[])((String[])this.getNodeState(g).getProperty("roleNames")));
                Assert.assertArrayEquals((Object[])roleNames, (Object[])g.getRoleNames());
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testConvertedArrayProperties() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_3);
                Group g = (Group)Neo4jNodeBacking.ajc$interMethodDispatch1$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$persist((NodeBacked)new Group());
                g.setRoles(Group.Role.values());
                Assert.assertArrayEquals((Object[])new String[]{"ADMIN", "USER"}, (Object[])((String[])this.getNodeState(g).getProperty("roles")));
                Assert.assertArrayEquals((Object[])Group.Role.values(), (Object[])g.getRoles());
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testCollectionProperties() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_4);
                Group g = (Group)Neo4jNodeBacking.ajc$interMethodDispatch1$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$persist((NodeBacked)new Group());
                List<String> roleNames = Arrays.asList("a", "b", "c");
                g.setRoleNamesColl(roleNames);
                Assert.assertArrayEquals((Object[])roleNames.toArray(), (Object[])((String[])this.getNodeState(g).getProperty("roleNamesColl")));
                Assert.assertEquals(roleNames, g.getRoleNamesColl());
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testConvertedCollectionProperties() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_5);
                Group g = (Group)Neo4jNodeBacking.ajc$interMethodDispatch1$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$persist((NodeBacked)new Group());
                g.setRolesColl(Arrays.asList(Group.Role.values()));
                Assert.assertArrayEquals((Object[])new String[]{"ADMIN", "USER"}, (Object[])((String[])this.getNodeState(g).getProperty("rolesColl")));
                Assert.assertEquals(Arrays.asList(Group.Role.values()), g.getRolesColl());
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testIterableProperties() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_6);
                Group g = (Group)Neo4jNodeBacking.ajc$interMethodDispatch1$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$persist((NodeBacked)new Group());
                List<String> roleNames = Arrays.asList("a", "b", "c");
                g.setRoleNamesIterable(roleNames);
                Assert.assertArrayEquals((Object[])roleNames.toArray(), (Object[])((String[])this.getNodeState(g).getProperty("roleNamesIterable")));
                Assert.assertEquals(roleNames, g.getRoleNamesIterable());
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testConvertedIterableProperties() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_7);
                Group g = (Group)Neo4jNodeBacking.ajc$interMethodDispatch1$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$persist((NodeBacked)new Group());
                g.setRolesIterable(Arrays.asList(Group.Role.values()));
                Assert.assertArrayEquals((Object[])new String[]{"ADMIN", "USER"}, (Object[])((String[])this.getNodeState(g).getProperty("rolesIterable")));
                Assert.assertEquals(Arrays.asList(Group.Role.values()), g.getRolesIterable());
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testSetProperties() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_8);
                Group g = (Group)Neo4jNodeBacking.ajc$interMethodDispatch1$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$persist((NodeBacked)new Group());
                LinkedHashSet<String> roleNames = new LinkedHashSet<String>(Arrays.asList("a", "b", "c"));
                g.setRoleNamesSet(roleNames);
                Assert.assertArrayEquals((Object[])roleNames.toArray(), (Object[])((String[])this.getNodeState(g).getProperty("roleNamesSet")));
                Assert.assertEquals(roleNames, g.getRoleNamesSet());
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testConvertedSetProperties() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_9);
                Group g = (Group)Neo4jNodeBacking.ajc$interMethodDispatch1$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$persist((NodeBacked)new Group());
                LinkedHashSet<Group.Role> roles = new LinkedHashSet<Group.Role>(Arrays.asList(Group.Role.values()));
                g.setRolesSet(roles);
                Assert.assertArrayEquals((Object[])new String[]{"ADMIN", "USER"}, (Object[])((String[])this.getNodeState(g).getProperty("rolesSet")));
                Assert.assertEquals(roles, g.getRolesSet());
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testSetShortProperty() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_10);
                Person p = Person.persistedPerson("Foo", 2);
                p.setHeight((short)182);
                Assert.assertEquals((Object)182, (Object)p.getHeight());
                Assert.assertEquals((Object)182, (Object)this.getNodeState(p).getProperty("height"));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testSetShortNameProperty() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_11);
                Group group = this.persist(new Group());
                group.setName("developers");
                Assert.assertEquals((Object)"developers", (Object)this.getNodeState(group).getProperty("name"));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test(expected=DataRetrievalFailureException.class)
    public void testDeleteEntityFromGDC() {
        Transaction tx = this.neo4jTemplate.getGraphDatabase().beginTx();
        Person p = Person.persistedPerson("Michael", 35);
        Person spouse = Person.persistedPerson("Tina", 36);
        p.setSpouse(spouse);
        long id = spouse.getId();
        this.neo4jTemplate.delete((Object)spouse);
        tx.success();
        tx.finish();
        Assert.assertNull((String)("spouse removed " + p.getSpouse()), (Object)p.getSpouse());
        Person spouseFromIndex = (Person)this.personRepository.findByPropertyValue("name-index", "name", "Tina");
        Assert.assertNull((String)"spouse not found in index", (Object)spouseFromIndex);
        Assert.assertNull((String)("node deleted " + id), (Object)this.neo4jTemplate.getNode(id));
    }

    @Test(expected=DataRetrievalFailureException.class)
    public void testDeleteEntity() {
        Transaction tx = this.neo4jTemplate.getGraphDatabase().beginTx();
        Person p = Person.persistedPerson("Michael", 35);
        Person spouse = Person.persistedPerson("Tina", 36);
        p.setSpouse(spouse);
        long id = spouse.getId();
        this.neo4jTemplate.delete((Object)spouse);
        tx.success();
        tx.finish();
        Assert.assertNull((String)("spouse removed " + p.getSpouse()), (Object)p.getSpouse());
        Person spouseFromIndex = (Person)this.personRepository.findByPropertyValue("name-index", "name", "Tina");
        Assert.assertNull((String)"spouse not found in index", (Object)spouseFromIndex);
        Assert.assertNull((String)("node deleted " + id), (Object)this.neo4jTemplate.getNode(id));
    }

    @Test
    public void testPersistGenericEntity() {
        Attribute<String> attribute = new Attribute<String>();
        attribute.setValue("test");
        this.persist(attribute);
    }

    @Test
    @Ignore
    public void testNotEqualToNonNodebackedObject() {
        Attribute attribute = new Attribute();
        Assert.assertEquals((Object)false, (Object)((Object)this.persist(attribute)).equals("foo"));
    }

    @Test
    public void testAccessReadOnlyCollectionMakesEntityDirty() {
        Group g = new Group();
        g.getReadOnlyPersons();
        Neo4jNodeBacking.ajc$interMethodDispatch1$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$persist((NodeBacked)g);
    }

    static {
        NodeEntityTests.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("NodeEntityTests.java", NodeEntityTests.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testUserConstructor", "org.springframework.data.neo4j.aspects.support.NodeEntityTests", "", "", "", "void"), 50);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testSetSimpleProperties", "org.springframework.data.neo4j.aspects.support.NodeEntityTests", "", "", "", "void"), 61);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testSetShortProperty", "org.springframework.data.neo4j.aspects.support.NodeEntityTests", "", "", "", "void"), 164);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testSetShortNameProperty", "org.springframework.data.neo4j.aspects.support.NodeEntityTests", "", "", "", "void"), 172);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testArrayProperties", "org.springframework.data.neo4j.aspects.support.NodeEntityTests", "", "", "", "void"), 90);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testConvertedArrayProperties", "org.springframework.data.neo4j.aspects.support.NodeEntityTests", "", "", "", "void"), 100);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testCollectionProperties", "org.springframework.data.neo4j.aspects.support.NodeEntityTests", "", "", "", "void"), 108);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testConvertedCollectionProperties", "org.springframework.data.neo4j.aspects.support.NodeEntityTests", "", "", "", "void"), 118);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testIterableProperties", "org.springframework.data.neo4j.aspects.support.NodeEntityTests", "", "", "", "void"), 126);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testConvertedIterableProperties", "org.springframework.data.neo4j.aspects.support.NodeEntityTests", "", "", "", "void"), 136);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testSetProperties", "org.springframework.data.neo4j.aspects.support.NodeEntityTests", "", "", "", "void"), 144);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testConvertedSetProperties", "org.springframework.data.neo4j.aspects.support.NodeEntityTests", "", "", "", "void"), 154);
    }
}

