/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.aspects.support.query;

import java.util.Arrays;
import java.util.Collection;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.MapUtil;
import org.springframework.data.neo4j.annotation.QueryType;
import org.springframework.data.neo4j.aspects.Person;
import org.springframework.data.neo4j.aspects.support.EntityTestBase;
import org.springframework.data.neo4j.core.GraphDatabase;
import org.springframework.data.neo4j.support.DelegatingGraphDatabase;
import org.springframework.data.neo4j.support.query.QueryEngine;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.aspectj.AnnotationTransactionAspect;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:org/springframework/data/neo4j/aspects/support/Neo4jGraphPersistenceTests-context.xml"})
@Transactional
public class GremlinQueryEngineTests
extends EntityTestBase {
    private QueryEngine<Object> queryEngine;
    private Person michael;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    @Before
    public void setUp() throws Exception {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_0);
                GraphDatabase graphDatabase = this.createGraphDatabase();
                this.testTeam.createSDGTeam();
                this.queryEngine = graphDatabase.queryEngineFor(QueryType.Gremlin);
                this.michael = this.testTeam.michael;
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    protected GraphDatabase createGraphDatabase() throws Exception {
        DelegatingGraphDatabase graphDatabase = new DelegatingGraphDatabase(this.neo4jTemplate.getGraphDatabaseService());
        graphDatabase.setConversionService(this.conversionService);
        return graphDatabase;
    }

    @Test
    @Transactional
    public void testQueryList() throws Exception {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_1);
                Collection result = IteratorUtil.asCollection((Iterable)this.queryEngine.query("t = new Table(); [g.v(michael),g.v(david)].each{ n -> n.as('person.name').as('person.age').table(t,['person.name','person.age']){ it.age }{ it.name }.iterate()}; t;", MapUtil.map((Object[])new Object[]{"michael", this.getNodeId(this.michael), "david", this.getNodeId(this.testTeam.david)})));
                Assert.assertEquals(Arrays.asList(this.testTeam.simpleRowFor(this.michael, "person"), this.testTeam.simpleRowFor(this.testTeam.david, "person")), (Object)result);
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    static {
        GremlinQueryEngineTests.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("GremlinQueryEngineTests.java", GremlinQueryEngineTests.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setUp", "org.springframework.data.neo4j.aspects.support.query.GremlinQueryEngineTests", "", "", "java.lang.Exception", "void"), 52);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testQueryList", "org.springframework.data.neo4j.aspects.support.query.GremlinQueryEngineTests", "", "", "java.lang.Exception", "void"), 68);
    }
}

