/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.aspects.support.typerepresentation;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import javax.persistence.Transient;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.helpers.collection.IteratorUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.neo4j.annotation.NodeEntity;
import org.springframework.data.neo4j.aspects.core.NodeBacked;
import org.springframework.data.neo4j.aspects.core.RelationshipBacked;
import org.springframework.data.neo4j.aspects.support.EntityTestBase;
import org.springframework.data.neo4j.aspects.support.node.Neo4jNodeBacking;
import org.springframework.data.neo4j.core.EntityPath;
import org.springframework.data.neo4j.core.EntityState;
import org.springframework.data.neo4j.support.DoReturn;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.support.mapping.StoredEntityType;
import org.springframework.data.neo4j.support.typerepresentation.IndexingNodeTypeRepresentationStrategy;
import org.springframework.test.context.CleanContextCacheTestExecutionListener;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.test.context.transaction.BeforeTransaction;
import org.springframework.test.context.transaction.TransactionalTestExecutionListener;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.aspectj.AnnotationTransactionAspect;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:org/springframework/data/neo4j/aspects/support/Neo4jGraphPersistenceTests-context.xml", "classpath:org/springframework/data/neo4j/aspects/support/IndexingTypeRepresentationStrategyOverride-context.xml"})
@TestExecutionListeners(value={CleanContextCacheTestExecutionListener.class, DependencyInjectionTestExecutionListener.class, TransactionalTestExecutionListener.class})
public class IndexingNodeTypeRepresentationStrategyTests
extends EntityTestBase {
    @Autowired
    private IndexingNodeTypeRepresentationStrategy nodeTypeRepresentationStrategy;
    @Autowired
    Neo4jTemplate neo4jTemplate;
    @Autowired
    Neo4jMappingContext ctx;
    private Thing thing;
    private SubThing subThing;
    private StoredEntityType thingType;
    private StoredEntityType subThingType;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    @Override
    @BeforeTransaction
    public void cleanDb() {
        super.cleanDb();
    }

    @Before
    public void setUp() throws Exception {
        if (this.thing == null) {
            this.createThingsAndLinks();
        }
        this.thingType = this.typeOf(Thing.class);
        this.subThingType = this.typeOf(SubThing.class);
    }

    @Test
    @Transactional
    public void testPostEntityCreation() throws Exception {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_0);
                Index typesIndex = this.graphDatabaseService.index().forNodes("__types__");
                IndexHits thingHits = typesIndex.get("className", this.thingType.getAlias());
                Assert.assertEquals(this.set(this.node(this.thing), this.node(this.subThing)), (Object)IteratorUtil.addToCollection((Iterable)thingHits, new HashSet()));
                IndexHits subThingHits = typesIndex.get("className", this.subThingType.getAlias());
                Assert.assertEquals((Object)this.node(this.subThing), (Object)subThingHits.getSingle());
                Assert.assertEquals((Object)this.thingType.getAlias(), (Object)this.node(this.thing).getProperty("__type__"));
                Assert.assertEquals((Object)this.subThingType.getAlias(), (Object)this.node(this.subThing).getProperty("__type__"));
                thingHits.close();
                subThingHits.close();
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    public void testPreEntityRemoval() throws Exception {
        this.manualCleanDb();
        this.createThingsAndLinks();
        Index typesIndex = this.graphDatabaseService.index().forNodes("__types__");
        Transaction tx = this.graphDatabaseService.beginTx();
        try {
            this.nodeTypeRepresentationStrategy.preEntityRemoval((PropertyContainer)this.node(this.thing));
            tx.success();
        }
        finally {
            tx.finish();
        }
        IndexHits thingHits = typesIndex.get("className", this.thingType.getAlias());
        Assert.assertEquals((Object)this.node(this.subThing), (Object)thingHits.getSingle());
        IndexHits subThingHits = typesIndex.get("className", this.subThingType.getAlias());
        Assert.assertEquals((Object)this.node(this.subThing), (Object)subThingHits.getSingle());
        tx = this.graphDatabaseService.beginTx();
        try {
            this.nodeTypeRepresentationStrategy.preEntityRemoval((PropertyContainer)this.node(this.subThing));
            tx.success();
        }
        finally {
            tx.finish();
        }
        thingHits = typesIndex.get("className", this.thingType.getAlias());
        Assert.assertNull((Object)thingHits.getSingle());
        subThingHits = typesIndex.get("className", this.subThingType.getAlias());
        Assert.assertNull((Object)subThingHits.getSingle());
    }

    @Test
    @Transactional
    public void testFindAll() throws Exception {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_1);
                Assert.assertEquals((String)"Did not find all things.", new HashSet<PropertyContainer>(Arrays.asList(this.neo4jTemplate.getPersistentState((Object)this.subThing), this.neo4jTemplate.getPersistentState((Object)this.thing))), (Object)IteratorUtil.addToCollection((Iterable)this.nodeTypeRepresentationStrategy.findAll(this.thingType), new HashSet()));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testCount() throws Exception {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_2);
                Assert.assertEquals((long)2L, (long)this.nodeTypeRepresentationStrategy.count(this.thingType));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testGetJavaType() throws Exception {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_3);
                Assert.assertEquals((Object)this.thingType.getAlias(), (Object)this.nodeTypeRepresentationStrategy.readAliasFrom((PropertyContainer)this.node(this.thing)));
                Assert.assertEquals((Object)this.subThingType.getAlias(), (Object)this.nodeTypeRepresentationStrategy.readAliasFrom((PropertyContainer)this.node(this.subThing)));
                Assert.assertEquals(Thing.class, (Object)this.neo4jTemplate.getStoredJavaType((Object)this.node(this.thing)));
                Assert.assertEquals(SubThing.class, (Object)this.neo4jTemplate.getStoredJavaType((Object)this.node(this.subThing)));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testCreateEntityAndInferType() throws Exception {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_4);
                Thing newThing = (Thing)this.neo4jTemplate.createEntityFromStoredType((PropertyContainer)this.node(this.thing), this.neo4jTemplate.getMappingPolicy((Object)this.thing));
                Assert.assertEquals((Object)this.thing, (Object)newThing);
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testCreateEntityAndSpecifyType() throws Exception {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_5);
                Thing newThing = (Thing)this.neo4jTemplate.createEntityFromState((PropertyContainer)this.node(this.subThing), Thing.class, this.neo4jTemplate.getMappingPolicy((Object)this.subThing));
                Assert.assertEquals((Object)this.subThing, (Object)newThing);
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testProjectEntity() throws Exception {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_6);
                Unrelated other = (Unrelated)this.neo4jTemplate.projectTo((Object)this.node(this.thing), Unrelated.class);
                Assert.assertEquals((Object)"thing", (Object)other.getName());
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    private Node node(Thing thing) {
        return this.getNodeState(thing);
    }

    private Thing createThingsAndLinks() {
        Transaction tx = this.graphDatabaseService.beginTx();
        try {
            Node n1 = this.graphDatabaseService.createNode();
            this.thing = (Thing)this.neo4jTemplate.setPersistentState((Object)new Thing(), (PropertyContainer)n1);
            this.nodeTypeRepresentationStrategy.writeTypeTo((PropertyContainer)n1, this.neo4jTemplate.getEntityType(Thing.class));
            this.thing.setName("thing");
            Node n2 = this.graphDatabaseService.createNode();
            this.subThing = (SubThing)this.neo4jTemplate.setPersistentState((Object)new SubThing(), (PropertyContainer)n2);
            this.nodeTypeRepresentationStrategy.writeTypeTo((PropertyContainer)n2, this.neo4jTemplate.getEntityType(SubThing.class));
            this.subThing.setName("subThing");
            tx.success();
            Thing thing = this.thing;
            return thing;
        }
        finally {
            tx.finish();
        }
    }

    static {
        IndexingNodeTypeRepresentationStrategyTests.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("IndexingNodeTypeRepresentationStrategyTests.java", IndexingNodeTypeRepresentationStrategyTests.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testPostEntityCreation", "org.springframework.data.neo4j.aspects.support.typerepresentation.IndexingNodeTypeRepresentationStrategyTests", "", "", "java.lang.Exception", "void"), 85);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testFindAll", "org.springframework.data.neo4j.aspects.support.typerepresentation.IndexingNodeTypeRepresentationStrategyTests", "", "", "java.lang.Exception", "void"), 139);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testCount", "org.springframework.data.neo4j.aspects.support.typerepresentation.IndexingNodeTypeRepresentationStrategyTests", "", "", "java.lang.Exception", "void"), 148);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testGetJavaType", "org.springframework.data.neo4j.aspects.support.typerepresentation.IndexingNodeTypeRepresentationStrategyTests", "", "", "java.lang.Exception", "void"), 154);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testCreateEntityAndInferType", "org.springframework.data.neo4j.aspects.support.typerepresentation.IndexingNodeTypeRepresentationStrategyTests", "", "", "java.lang.Exception", "void"), 163);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testCreateEntityAndSpecifyType", "org.springframework.data.neo4j.aspects.support.typerepresentation.IndexingNodeTypeRepresentationStrategyTests", "", "", "java.lang.Exception", "void"), 170);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testProjectEntity", "org.springframework.data.neo4j.aspects.support.typerepresentation.IndexingNodeTypeRepresentationStrategyTests", "", "", "java.lang.Exception", "void"), 177);
    }

    public static class SubThing
    extends Thing {
        public SubThing() {
            if (!Neo4jNodeBacking.ajc$cflowCounter$0.isValid()) {
                Neo4jNodeBacking.aspectOf().ajc$before$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$1$74591ff9((NodeBacked)this);
            }
        }
    }

    @NodeEntity
    public static class Thing
    implements NodeBacked {
        String name;
        @Transient
        public transient EntityState<Node> entityState;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

        public Thing() {
            Neo4jNodeBacking.ajc$interFieldInit$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)this);
            if (!Neo4jNodeBacking.ajc$cflowCounter$0.isValid()) {
                Neo4jNodeBacking.aspectOf().ajc$before$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$1$74591ff9((NodeBacked)this);
            }
        }

        public void setName(String name) {
            String string = name;
            Thing thing = this;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)thing, (Object)string);
            Thing.name_aroundBody1$advice(this, thing, string, joinPoint, Neo4jNodeBacking.aspectOf(), this, string, null, joinPoint);
        }

        public String getName() {
            Thing thing = this;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)thing);
            return (String)Thing.name_aroundBody3$advice(this, thing, joinPoint, Neo4jNodeBacking.aspectOf(), this, null, joinPoint);
        }

        public /* synthetic */ EntityState ajc$interFieldGet$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState() {
            return this.entityState;
        }

        public /* synthetic */ void ajc$interFieldSet$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState(EntityState entityState) {
            this.entityState = entityState;
        }

        static {
            Thing.ajc$preClinit();
        }

        private static final /* synthetic */ Object name_aroundBody1$advice(Thing ajc$this, Thing target, String name, JoinPoint thisJoinPoint, Neo4jNodeBacking ajc$aspectInstance, NodeBacked entity, Object newVal, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint2) {
            if (Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity) == null) {
                AroundClosure aroundClosure = ajc$aroundClosure;
                Object object = newVal;
                NodeBacked nodeBacked = entity;
                target.name = (String)object;
                return null;
            }
            Object result = Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity).setValue(Neo4jNodeBacking.ajc$inlineAccessMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$field((Neo4jNodeBacking)ajc$aspectInstance, (JoinPoint)thisJoinPoint2), newVal, null);
            if (result instanceof DoReturn) {
                return DoReturn.unwrap((Object)result);
            }
            AroundClosure aroundClosure = ajc$aroundClosure;
            Object object = result;
            NodeBacked nodeBacked = entity;
            target.name = (String)object;
            return null;
        }

        private static final /* synthetic */ Object name_aroundBody3$advice(Thing ajc$this, Thing target, JoinPoint name, Neo4jNodeBacking ajc$aspectInstance, NodeBacked entity, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint) {
            if (Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity) == null) {
                AroundClosure aroundClosure = ajc$aroundClosure;
                NodeBacked nodeBacked = entity;
                return target.name;
            }
            Object result = Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity).getValue(Neo4jNodeBacking.ajc$inlineAccessMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$field((Neo4jNodeBacking)ajc$aspectInstance, (JoinPoint)thisJoinPoint), null);
            if (result instanceof DoReturn) {
                return DoReturn.unwrap((Object)result);
            }
            AroundClosure aroundClosure = ajc$aroundClosure;
            NodeBacked nodeBacked = entity;
            return target.name;
        }

        public boolean equals(Object object) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$equals((NodeBacked)this, (Object)object);
        }

        public <T> Iterable<T> findAllByQuery(String string, Class<T> clazz, Map<String, Object> map) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$findAllByQuery((NodeBacked)this, (String)string, clazz, map);
        }

        public Iterable<Map<String, Object>> findAllByQuery(String string, Map<String, Object> map) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$findAllByQuery((NodeBacked)this, (String)string, map);
        }

        public <T> Iterable<T> findAllByTraversal(Class<T> clazz, TraversalDescription traversalDescription) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$findAllByTraversal((NodeBacked)this, clazz, (TraversalDescription)traversalDescription);
        }

        public <S extends NodeBacked, E extends NodeBacked> Iterable<EntityPath<S, E>> findAllPathsByTraversal(TraversalDescription traversalDescription) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$findAllPathsByTraversal((NodeBacked)this, (TraversalDescription)traversalDescription);
        }

        public <T> T findByQuery(String string, Class<T> clazz, Map<String, Object> map) {
            return (T)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$findByQuery((NodeBacked)this, (String)string, clazz, map);
        }

        public EntityState<Node> getEntityState() {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getEntityState((NodeBacked)this);
        }

        public Long getNodeId() {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getNodeId((NodeBacked)this);
        }

        public Node getPersistentState() {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getPersistentState((NodeBacked)this);
        }

        public <R extends RelationshipBacked> R getRelationshipTo(NodeBacked nodeBacked, Class<R> clazz, String string) {
            return (R)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getRelationshipTo((NodeBacked)this, (NodeBacked)nodeBacked, clazz, (String)string);
        }

        public Relationship getRelationshipTo(NodeBacked nodeBacked, String string) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getRelationshipTo((NodeBacked)this, (NodeBacked)nodeBacked, (String)string);
        }

        public Neo4jTemplate getTemplate() {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getTemplate((NodeBacked)this);
        }

        public boolean hasPersistentState() {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$hasPersistentState((NodeBacked)this);
        }

        public int hashCode() {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$hashCode((NodeBacked)this);
        }

        public <T extends NodeBacked> T persist() {
            return (T)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$persist((NodeBacked)this);
        }

        public <T extends NodeBacked> T projectTo(Class<T> clazz) {
            return (T)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$projectTo((NodeBacked)this, clazz);
        }

        public <R extends RelationshipBacked, N extends NodeBacked> R relateTo(N n, Class<R> clazz, String string) {
            return (R)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$relateTo((NodeBacked)this, n, clazz, (String)string);
        }

        public <R extends RelationshipBacked, N extends NodeBacked> R relateTo(N n, Class<R> clazz, String string, boolean bl) {
            return (R)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$relateTo((NodeBacked)this, n, clazz, (String)string, (boolean)bl);
        }

        public Relationship relateTo(NodeBacked nodeBacked, String string) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$relateTo((NodeBacked)this, (NodeBacked)nodeBacked, (String)string);
        }

        public Relationship relateTo(NodeBacked nodeBacked, String string, boolean bl) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$relateTo((NodeBacked)this, (NodeBacked)nodeBacked, (String)string, (boolean)bl);
        }

        public void remove() {
            Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$remove((NodeBacked)this);
        }

        public void removeRelationshipTo(NodeBacked nodeBacked, String string) {
            Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$removeRelationshipTo((NodeBacked)this, (NodeBacked)nodeBacked, (String)string);
        }

        public void setPersistentState(Node node) {
            Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$setPersistentState((NodeBacked)this, (Node)node);
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("IndexingNodeTypeRepresentationStrategyTests.java", Thing.class);
            ajc$tjp_0 = factory.makeSJP("field-set", (Signature)factory.makeFieldSig("0", "name", "org.springframework.data.neo4j.aspects.support.typerepresentation.IndexingNodeTypeRepresentationStrategyTests$Thing", "java.lang.String"), 218);
            ajc$tjp_1 = factory.makeSJP("field-get", (Signature)factory.makeFieldSig("0", "name", "org.springframework.data.neo4j.aspects.support.typerepresentation.IndexingNodeTypeRepresentationStrategyTests$Thing", "java.lang.String"), 222);
        }
    }

    @NodeEntity
    public static class Unrelated
    implements NodeBacked {
        String name;
        @Transient
        public transient EntityState<Node> entityState;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        public Unrelated() {
            Neo4jNodeBacking.ajc$interFieldInit$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)this);
            if (!Neo4jNodeBacking.ajc$cflowCounter$0.isValid()) {
                Neo4jNodeBacking.aspectOf().ajc$before$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$1$74591ff9((NodeBacked)this);
            }
        }

        public String getName() {
            Unrelated unrelated = this;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)unrelated);
            return (String)Unrelated.name_aroundBody1$advice(this, unrelated, joinPoint, Neo4jNodeBacking.aspectOf(), this, null, joinPoint);
        }

        public /* synthetic */ EntityState ajc$interFieldGet$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState() {
            return this.entityState;
        }

        public /* synthetic */ void ajc$interFieldSet$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState(EntityState entityState) {
            this.entityState = entityState;
        }

        static {
            Unrelated.ajc$preClinit();
        }

        private static final /* synthetic */ Object name_aroundBody1$advice(Unrelated ajc$this, Unrelated target, JoinPoint name, Neo4jNodeBacking ajc$aspectInstance, NodeBacked entity, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint) {
            if (Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity) == null) {
                AroundClosure aroundClosure = ajc$aroundClosure;
                NodeBacked nodeBacked = entity;
                return target.name;
            }
            Object result = Neo4jNodeBacking.ajc$interFieldGetDispatch$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$entityState((NodeBacked)entity).getValue(Neo4jNodeBacking.ajc$inlineAccessMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$field((Neo4jNodeBacking)ajc$aspectInstance, (JoinPoint)thisJoinPoint), null);
            if (result instanceof DoReturn) {
                return DoReturn.unwrap((Object)result);
            }
            AroundClosure aroundClosure = ajc$aroundClosure;
            NodeBacked nodeBacked = entity;
            return target.name;
        }

        public boolean equals(Object object) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$equals((NodeBacked)this, (Object)object);
        }

        public <T> Iterable<T> findAllByQuery(String string, Class<T> clazz, Map<String, Object> map) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$findAllByQuery((NodeBacked)this, (String)string, clazz, map);
        }

        public Iterable<Map<String, Object>> findAllByQuery(String string, Map<String, Object> map) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$findAllByQuery((NodeBacked)this, (String)string, map);
        }

        public <T> Iterable<T> findAllByTraversal(Class<T> clazz, TraversalDescription traversalDescription) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$findAllByTraversal((NodeBacked)this, clazz, (TraversalDescription)traversalDescription);
        }

        public <S extends NodeBacked, E extends NodeBacked> Iterable<EntityPath<S, E>> findAllPathsByTraversal(TraversalDescription traversalDescription) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$findAllPathsByTraversal((NodeBacked)this, (TraversalDescription)traversalDescription);
        }

        public <T> T findByQuery(String string, Class<T> clazz, Map<String, Object> map) {
            return (T)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$findByQuery((NodeBacked)this, (String)string, clazz, map);
        }

        public EntityState<Node> getEntityState() {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getEntityState((NodeBacked)this);
        }

        public Long getNodeId() {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getNodeId((NodeBacked)this);
        }

        public Node getPersistentState() {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getPersistentState((NodeBacked)this);
        }

        public <R extends RelationshipBacked> R getRelationshipTo(NodeBacked nodeBacked, Class<R> clazz, String string) {
            return (R)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getRelationshipTo((NodeBacked)this, (NodeBacked)nodeBacked, clazz, (String)string);
        }

        public Relationship getRelationshipTo(NodeBacked nodeBacked, String string) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getRelationshipTo((NodeBacked)this, (NodeBacked)nodeBacked, (String)string);
        }

        public Neo4jTemplate getTemplate() {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getTemplate((NodeBacked)this);
        }

        public boolean hasPersistentState() {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$hasPersistentState((NodeBacked)this);
        }

        public int hashCode() {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$hashCode((NodeBacked)this);
        }

        public <T extends NodeBacked> T persist() {
            return (T)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$persist((NodeBacked)this);
        }

        public <T extends NodeBacked> T projectTo(Class<T> clazz) {
            return (T)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$projectTo((NodeBacked)this, clazz);
        }

        public <R extends RelationshipBacked, N extends NodeBacked> R relateTo(N n, Class<R> clazz, String string) {
            return (R)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$relateTo((NodeBacked)this, n, clazz, (String)string);
        }

        public <R extends RelationshipBacked, N extends NodeBacked> R relateTo(N n, Class<R> clazz, String string, boolean bl) {
            return (R)Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$relateTo((NodeBacked)this, n, clazz, (String)string, (boolean)bl);
        }

        public Relationship relateTo(NodeBacked nodeBacked, String string) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$relateTo((NodeBacked)this, (NodeBacked)nodeBacked, (String)string);
        }

        public Relationship relateTo(NodeBacked nodeBacked, String string, boolean bl) {
            return Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$relateTo((NodeBacked)this, (NodeBacked)nodeBacked, (String)string, (boolean)bl);
        }

        public void remove() {
            Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$remove((NodeBacked)this);
        }

        public void removeRelationshipTo(NodeBacked nodeBacked, String string) {
            Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$removeRelationshipTo((NodeBacked)this, (NodeBacked)nodeBacked, (String)string);
        }

        public void setPersistentState(Node node) {
            Neo4jNodeBacking.ajc$interMethod$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$setPersistentState((NodeBacked)this, (Node)node);
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("IndexingNodeTypeRepresentationStrategyTests.java", Unrelated.class);
            ajc$tjp_0 = factory.makeSJP("field-get", (Signature)factory.makeFieldSig("0", "name", "org.springframework.data.neo4j.aspects.support.typerepresentation.IndexingNodeTypeRepresentationStrategyTests$Unrelated", "java.lang.String"), 209);
        }
    }
}

