/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.config;

import java.io.File;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.transaction.PlatformTransactionManager;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(value={"classpath:org/springframework/data/neo4j/config/DataGraphNamespaceHandlerTest-cross-store-context.xml"})
public class DataGraphNamespaceHandlerCrossStoreTest {
    @Autowired
    GraphDatabaseService graphDatabaseService;
    @Autowired
    Neo4jTemplate template;
    @Autowired
    PlatformTransactionManager transactionManager;

    @Test
    public void injectionForCrossStore() {
        Assert.assertNotNull((String)"template", (Object)this.template);
        EmbeddedGraphDatabase graphDatabaseService = (EmbeddedGraphDatabase)this.template.getGraphDatabaseService();
        File directory = new File("target", "config-test");
        Assert.assertTrue((String)"store-dir", (boolean)graphDatabaseService.getStoreDir().equals(directory.getAbsolutePath()));
        Assert.assertNotNull((String)"graphDatabaseService", (Object)graphDatabaseService);
        Assert.assertNotNull((String)"transactionManager", (Object)this.transactionManager);
    }
}

