/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.cross_store.fieldaccess;

import javax.persistence.Id;
import org.springframework.data.neo4j.fieldaccess.FieldAccessListener;
import org.springframework.data.neo4j.fieldaccess.FieldAccessorListenerFactory;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.support.Neo4jTemplate;

public class JpaIdFieldAccessListenerFactory
implements FieldAccessorListenerFactory {
    private final Neo4jTemplate template;

    public JpaIdFieldAccessListenerFactory(Neo4jTemplate template) {
        this.template = template;
    }

    public boolean accept(Neo4jPersistentProperty property) {
        return property.isAnnotationPresent(Id.class);
    }

    public FieldAccessListener forField(Neo4jPersistentProperty property) {
        return new JpaIdFieldListener(property, this.template);
    }

    public static class JpaIdFieldListener
    implements FieldAccessListener {
        protected final Neo4jPersistentProperty property;
        private final Neo4jTemplate template;

        public JpaIdFieldListener(Neo4jPersistentProperty property, Neo4jTemplate template) {
            this.property = property;
            this.template = template;
        }

        public void valueChanged(Object entity, Object oldVal, Object newVal) {
            if (newVal != null) {
                this.template.save(entity);
            }
        }
    }
}

