/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.cross_store.support.node;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.neo4j.graphdb.Node;
import org.springframework.data.neo4j.aspects.core.NodeBacked;
import org.springframework.data.neo4j.aspects.support.node.Neo4jNodeBacking;
import org.springframework.data.neo4j.mapping.EntityInstantiator;
import org.springframework.data.neo4j.mapping.MappingPolicy;
import org.springframework.data.neo4j.support.node.NodeEntityInstantiator;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;
import org.springframework.orm.jpa.aspectj.JpaExceptionTranslatorAspect;

public class CrossStoreNodeEntityInstantiator
implements EntityInstantiator<Node> {
    private final NodeEntityInstantiator delegate;
    private EntityManagerFactory entityManagerFactory;

    public CrossStoreNodeEntityInstantiator(NodeEntityInstantiator delegate, EntityManagerFactory entityManagerFactory) {
        this.delegate = delegate;
        this.entityManagerFactory = entityManagerFactory;
    }

    public <T> T createEntityFromState(Node n, Class<T> entityClass, MappingPolicy mappingPolicy) {
        if (n.hasProperty("foreignId")) {
            Object object;
            Object foreignId = n.getProperty("foreignId");
            try {
                object = this.entityManager().find(entityClass, foreignId);
            }
            catch (RuntimeException runtimeException) {
                JpaExceptionTranslatorAspect.aspectOf().ajc$afterThrowing$org_springframework_orm_jpa_aspectj_JpaExceptionTranslatorAspect$1$18a1ac9(runtimeException);
                throw runtimeException;
            }
            Object result = object;
            Neo4jNodeBacking.ajc$interMethodDispatch1$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$setPersistentState((NodeBacked)((NodeBacked)result), (Node)n);
            return (T)result;
        }
        return (T)this.delegate.createEntityFromState((Object)n, entityClass, mappingPolicy);
    }

    private EntityManager entityManager() {
        return EntityManagerFactoryUtils.getTransactionalEntityManager((EntityManagerFactory)this.entityManagerFactory);
    }
}

