/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.cross_store.support.node;

import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnitUtil;
import org.neo4j.graphdb.Node;
import org.springframework.data.neo4j.annotation.NodeEntity;
import org.springframework.data.neo4j.aspects.core.NodeBacked;
import org.springframework.data.neo4j.core.EntityState;
import org.springframework.data.neo4j.cross_store.support.node.CrossStoreNodeEntityState;
import org.springframework.data.neo4j.fieldaccess.DelegatingFieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.DetachedEntityState;
import org.springframework.data.neo4j.fieldaccess.FieldAccessorFactoryFactory;
import org.springframework.data.neo4j.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.support.node.NodeEntityStateFactory;
import org.springframework.orm.jpa.aspectj.JpaExceptionTranslatorAspect;

public class CrossStoreNodeEntityStateFactory
extends NodeEntityStateFactory {
    private final EntityManagerFactory entityManagerFactory;

    public CrossStoreNodeEntityStateFactory(Neo4jMappingContext neo4jMappingContext, FieldAccessorFactoryFactory factory, EntityManagerFactory entityManagerFactory) {
        super(neo4jMappingContext, factory);
        this.entityManagerFactory = entityManagerFactory;
    }

    public EntityState<Node> getEntityState(final Object entity, boolean detachable, Neo4jTemplate template) {
        Class<?> entityType = entity.getClass();
        if (this.isPartial(entityType)) {
            Neo4jPersistentEntity persistentEntity = (Neo4jPersistentEntity)this.mappingContext.getPersistentEntity(entityType);
            DelegatingFieldAccessorFactory fieldAccessorFactory = this.nodeDelegatingFieldAccessorFactory.provideFactoryFor(template);
            final CrossStoreNodeEntityState partialNodeEntityState = new CrossStoreNodeEntityState(null, (NodeBacked)entity, entityType, template, this.getPersistenceUnitUtils(), fieldAccessorFactory, persistentEntity);
            if (!detachable) {
                return partialNodeEntityState;
            }
            return new DetachedEntityState<Node>(partialNodeEntityState, template){

                protected boolean isDetached() {
                    return super.isDetached() || partialNodeEntityState.getId(entity) == null;
                }
            };
        }
        return super.getEntityState(entity, detachable, template);
    }

    private boolean isPartial(Class<?> entityType) {
        NodeEntity graphEntityAnnotation = entityType.getAnnotation(NodeEntity.class);
        return graphEntityAnnotation.partial();
    }

    private PersistenceUnitUtil getPersistenceUnitUtils() {
        PersistenceUnitUtil persistenceUnitUtil;
        block7: {
            block6: {
                boolean bl;
                if (this.entityManagerFactory == null) break block6;
                try {
                    bl = this.entityManagerFactory.isOpen();
                }
                catch (RuntimeException runtimeException) {
                    JpaExceptionTranslatorAspect.aspectOf().ajc$afterThrowing$org_springframework_orm_jpa_aspectj_JpaExceptionTranslatorAspect$1$18a1ac9(runtimeException);
                    throw runtimeException;
                }
                if (bl) break block7;
            }
            return null;
        }
        try {
            persistenceUnitUtil = this.entityManagerFactory.getPersistenceUnitUtil();
        }
        catch (RuntimeException runtimeException) {
            JpaExceptionTranslatorAspect.aspectOf().ajc$afterThrowing$org_springframework_orm_jpa_aspectj_JpaExceptionTranslatorAspect$1$18a1ac9(runtimeException);
            throw runtimeException;
        }
        return persistenceUnitUtil;
    }
}

