/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.rest.support;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.helpers.collection.MapUtil;
import org.springframework.data.neo4j.rest.support.IsRelationshipToNodeMatcher;
import org.springframework.data.neo4j.rest.support.RestTestBase;
import org.springframework.data.neo4j.rest.support.Type;

public class RestEntityTests
extends RestTestBase {
    @Test
    public void testSetProperty() {
        this.restGraphDatabase.getReferenceNode().setProperty("name", (Object)"test");
        Node node = this.restGraphDatabase.getReferenceNode();
        Assert.assertEquals((Object)"test", (Object)node.getProperty("name"));
    }

    @Test
    public void testSetStringArrayProperty() {
        this.restGraphDatabase.getReferenceNode().setProperty("name", (Object)new String[]{"test"});
        Node node = this.restGraphDatabase.getReferenceNode();
        Assert.assertArrayEquals((Object[])new String[]{"test"}, (Object[])((String[])node.getProperty("name")));
    }

    @Test
    public void testSetDoubleArrayProperty() {
        double[] data = new double[]{0.0, 1.0, 2.0};
        this.restGraphDatabase.getReferenceNode().setProperty("data", (Object)data);
        Node node = this.restGraphDatabase.getReferenceNode();
        Assert.assertTrue((String)"same double array", (boolean)Arrays.equals(data, (double[])node.getProperty("data")));
    }

    @Test
    public void testRemoveProperty() {
        Node node = this.restGraphDatabase.getReferenceNode();
        node.setProperty("name", (Object)"test");
        Assert.assertEquals((Object)"test", (Object)node.getProperty("name"));
        node.removeProperty("name");
        Assert.assertEquals((Object)false, (Object)node.hasProperty("name"));
    }

    @Test(expected=NotFoundException.class)
    public void testRemoveNode() {
        Node node = this.restGraphDatabase.createNode();
        node.setProperty("name", (Object)"test");
        long nodeId = node.getId();
        Assert.assertEquals((Object)"test", (Object)node.getProperty("name"));
        this.restGraphDatabase.remove(node);
        Assert.assertEquals(null, (Object)this.restGraphDatabase.getNodeById(nodeId));
    }

    @Test(expected=NotFoundException.class)
    public void testRemoveRelationship() {
        Node refNode = this.restGraphDatabase.getReferenceNode();
        Node node = this.restGraphDatabase.createNode();
        Relationship rel = this.restGraphDatabase.createRelationship(refNode, node, (RelationshipType)Type.TEST, MapUtil.map((Object[])new Object[]{"name", "test"}));
        long relId = rel.getId();
        Assert.assertEquals((Object)"test", (Object)rel.getProperty("name"));
        this.restGraphDatabase.remove(rel);
        Assert.assertEquals(null, (Object)this.restGraphDatabase.getRelationshipById(relId));
    }

    @Test
    public void testSetPropertyOnRelationship() {
        Node refNode = this.restGraphDatabase.getReferenceNode();
        Node node = this.restGraphDatabase.createNode();
        Relationship rel = refNode.createRelationshipTo(node, (RelationshipType)Type.TEST);
        rel.setProperty("name", (Object)"test");
        Assert.assertEquals((Object)"test", (Object)rel.getProperty("name"));
        Relationship foundRelationship = IsRelationshipToNodeMatcher.relationshipFromTo(refNode.getRelationships((RelationshipType)Type.TEST, Direction.OUTGOING), refNode, node);
        Assert.assertEquals((Object)"test", (Object)foundRelationship.getProperty("name"));
    }

    @Test
    public void testRemovePropertyOnRelationship() {
        Node refNode = this.restGraphDatabase.getReferenceNode();
        Node node = this.restGraphDatabase.createNode();
        Relationship rel = refNode.createRelationshipTo(node, (RelationshipType)Type.TEST);
        rel.setProperty("name", (Object)"test");
        Assert.assertEquals((Object)"test", (Object)rel.getProperty("name"));
        Relationship foundRelationship = IsRelationshipToNodeMatcher.relationshipFromTo(refNode.getRelationships((RelationshipType)Type.TEST, Direction.OUTGOING), refNode, node);
        Assert.assertEquals((Object)"test", (Object)foundRelationship.getProperty("name"));
        rel.removeProperty("name");
        Assert.assertEquals((Object)false, (Object)rel.hasProperty("name"));
        Relationship foundRelationship2 = IsRelationshipToNodeMatcher.relationshipFromTo(refNode.getRelationships((RelationshipType)Type.TEST, Direction.OUTGOING), refNode, node);
        Assert.assertEquals((Object)false, (Object)foundRelationship2.hasProperty("name"));
    }
}

