/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.rest.support;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.springframework.data.neo4j.rest.support.RestTestBase;

public class RestIndexTests
extends RestTestBase {
    private static final String NODE_INDEX_NAME = "NODE_INDEX";
    private static final String REL_INDEX_NAME = "REL_INDEX";

    @Test
    public void testAddToNodeIndex() {
        this.nodeIndex().add((PropertyContainer)this.node(), "name", (Object)"test");
        IndexHits hits = this.nodeIndex().get("name", (Object)"test");
        Assert.assertEquals((String)"index results", (Object)true, (Object)hits.hasNext());
        Assert.assertEquals((Object)this.node(), (Object)hits.next());
        hits.close();
    }

    @Test
    public void testAdvancedQuery() {
        this.nodeIndex().add((PropertyContainer)this.node(), "name", (Object)"test");
        IndexHits hits = this.nodeIndex().query("name", (Object)"tes*");
        Assert.assertEquals((String)"index results", (Object)true, (Object)hits.hasNext());
        Assert.assertEquals((Object)this.node(), (Object)hits.next());
        hits.close();
    }

    @Test
    public void testRangeQuery() {
        this.nodeIndex().add((PropertyContainer)this.node(), "age", (Object)35);
        IndexHits hits = this.nodeIndex().query("age", (Object)"age:[30 TO 40]");
        Assert.assertEquals((String)"index results", (Object)true, (Object)hits.hasNext());
        Assert.assertEquals((Object)this.node(), (Object)hits.next());
        hits.close();
    }

    @Test
    public void testNotFoundInNodeIndex() {
        IndexHits hits = this.nodeIndex().get("foo", (Object)"bar");
        Assert.assertEquals((String)"no index results", (Object)false, (Object)hits.hasNext());
        hits.close();
    }

    @Test
    public void testAddToRelationshipIndex() {
        long value = System.currentTimeMillis();
        this.relationshipIndex().add((PropertyContainer)this.relationship(), "name", (Object)value);
        IndexHits hits = this.relationshipIndex().get("name", (Object)value);
        Assert.assertEquals((String)"index results", (Object)true, (Object)hits.hasNext());
        Assert.assertEquals((Object)this.relationship(), (Object)hits.next());
        hits.close();
    }

    @Test
    public void testNotFoundInRelationshipIndex() {
        IndexHits hits = this.relationshipIndex().get("foo", (Object)"bar");
        Assert.assertEquals((String)"no index results", (Object)false, (Object)hits.hasNext());
        hits.close();
    }

    @Test
    public void testDeleteFromNodeIndex() {
        String value = String.valueOf(System.currentTimeMillis());
        this.nodeIndex().add((PropertyContainer)this.node(), "time", (Object)value);
        IndexHits hits = this.nodeIndex().get("time", (Object)value);
        Assert.assertEquals((String)"found in index results", (Object)true, (Object)hits.hasNext());
        Assert.assertEquals((String)"found in index results", (Object)this.node(), (Object)hits.next());
        this.nodeIndex().remove((PropertyContainer)this.node(), "time", (Object)value);
        IndexHits hitsAfterRemove = this.nodeIndex().get("time", (Object)value);
        Assert.assertEquals((String)"not found in index results", (Object)false, (Object)hitsAfterRemove.hasNext());
        hits.close();
        hitsAfterRemove.close();
    }

    @Test
    public void testDeleteFromRelationshipIndex() {
        String value = String.valueOf(System.currentTimeMillis());
        this.relationshipIndex().add((PropertyContainer)this.relationship(), "time", (Object)value);
        IndexHits hits = this.relationshipIndex().get("time", (Object)value);
        Assert.assertEquals((String)"found in index results", (Object)true, (Object)hits.hasNext());
        Assert.assertEquals((String)"found in index results", (Object)this.relationship(), (Object)hits.next());
        this.relationshipIndex().remove((PropertyContainer)this.relationship(), "time", (Object)value);
        IndexHits hitsAfterRemove = this.relationshipIndex().get("time", (Object)value);
        Assert.assertEquals((String)"not found in index results", (Object)false, (Object)hitsAfterRemove.hasNext());
        hits.close();
        hitsAfterRemove.close();
    }

    private Index<Node> nodeIndex() {
        return this.restGraphDatabase.index().forNodes(NODE_INDEX_NAME);
    }

    private RelationshipIndex relationshipIndex() {
        return this.restGraphDatabase.index().forRelationships(REL_INDEX_NAME);
    }

    @Test
    public void testNodeIndexIsListed() {
        this.nodeIndex().add((PropertyContainer)this.node(), "name", (Object)"test");
        Assert.assertTrue((String)"node index name listed", (boolean)Arrays.asList(this.restGraphDatabase.index().nodeIndexNames()).contains(NODE_INDEX_NAME));
    }

    @Test
    public void testRelationshipIndexIsListed() {
        this.relationshipIndex().add((PropertyContainer)this.relationship(), "name", (Object)"test");
        Assert.assertTrue((String)"relationship index name listed", (boolean)Arrays.asList(this.restGraphDatabase.index().relationshipIndexNames()).contains(REL_INDEX_NAME));
    }
}

