/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.rest.support;

import java.util.Iterator;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.rest.graphdb.ExecutingRestRequest;
import org.neo4j.rest.graphdb.RequestResult;
import org.neo4j.server.NeoServer;
import org.neo4j.server.WrappingNeoServerBootstrapper;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.configuration.ServerConfigurator;
import org.neo4j.test.ImpermanentGraphDatabase;
import org.springframework.data.neo4j.rest.SpringRestGraphDatabase;
import org.springframework.data.neo4j.rest.support.Neo4jDatabaseCleaner;
import org.springframework.data.neo4j.rest.support.Type;

public class RestTestBase {
    protected static ImpermanentGraphDatabase db;
    protected SpringRestGraphDatabase restGraphDatabase;
    private static final String HOSTNAME = "127.0.0.1";
    public static final int PORT = 7470;
    protected static NeoServer neoServer;
    public static final String SERVER_ROOT_URI = "http://127.0.0.1:7470/db/data/";

    @BeforeClass
    public static void startDb() throws Exception {
        db = new ImpermanentGraphDatabase();
        ServerConfigurator configurator = new ServerConfigurator((GraphDatabaseAPI)db);
        configurator.configuration().setProperty("org.neo4j.server.webserver.port", (Object)7470);
        WrappingNeoServerBootstrapper bootstrapper = new WrappingNeoServerBootstrapper((GraphDatabaseAPI)db, (Configurator)configurator);
        bootstrapper.start();
        neoServer = bootstrapper.getServer();
        RestTestBase.tryConnect();
    }

    private static void tryConnect() throws InterruptedException {
        int retryCount = 3;
        for (int i = 0; i < retryCount; ++i) {
            try {
                RequestResult result = new ExecutingRestRequest(SERVER_ROOT_URI).get("");
                Assert.assertEquals((long)200L, (long)result.getStatus());
                System.err.println("Successful HTTP connection to http://127.0.0.1:7470/db/data/");
                return;
            }
            catch (Exception e) {
                System.err.println("Error retrieving ROOT URI " + e.getMessage());
                Thread.sleep(500L);
                continue;
            }
        }
    }

    @Before
    public void setUp() throws Exception {
        RestTestBase.cleanDb();
        this.restGraphDatabase = new SpringRestGraphDatabase(SERVER_ROOT_URI);
    }

    public static void cleanDb() {
        new Neo4jDatabaseCleaner((GraphDatabaseService)db).cleanDb();
    }

    @AfterClass
    public static void shutdownDb() {
        neoServer.stop();
    }

    public GraphDatabaseService getGraphDatabase() {
        return db;
    }

    protected Relationship relationship() {
        Iterator it = this.node().getRelationships(Direction.OUTGOING).iterator();
        if (it.hasNext()) {
            return (Relationship)it.next();
        }
        return this.node().createRelationshipTo(this.restGraphDatabase.createNode(null), (RelationshipType)Type.TEST);
    }

    protected Node node() {
        return this.restGraphDatabase.getReferenceNode();
    }

    static {
        neoServer = null;
    }
}

