/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.rest.support;

import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.traversal.UniquenessFactory;
import org.neo4j.kernel.Uniqueness;
import org.neo4j.rest.graphdb.traversal.RestTraversal;
import org.neo4j.rest.graphdb.traversal.RestTraversalDescription;

public class RestTraversalDescriptionTests {
    private RestTraversal traversalDescription;

    @Before
    public void setUp() throws Exception {
        this.traversalDescription = (RestTraversal)RestTraversal.description();
    }

    @Test
    public void testUniqueness() throws Exception {
        this.traversalDescription.uniqueness((UniquenessFactory)Uniqueness.NODE_PATH);
        Assert.assertEquals((Object)"node path", (Object)this.getPostData("uniqueness"));
    }

    @Test
    public void testUniquenessWithValue() throws Exception {
        this.traversalDescription.uniqueness((UniquenessFactory)Uniqueness.NODE_PATH, (Object)"test");
        String param = "uniqueness";
        Map uniquenessMap = (Map)this.getPostData(param);
        Assert.assertEquals((Object)"node path", uniquenessMap.get("name"));
        Assert.assertEquals((Object)"test", uniquenessMap.get("value"));
    }

    private Object getPostData(String param) {
        return this.traversalDescription.getPostData().get(param);
    }

    @Test
    public void testPruneScript() throws Exception {
        this.traversalDescription.prune(RestTraversalDescription.ScriptLanguage.JAVASCRIPT, "return true;");
        Map pruneEvaluator = (Map)this.getPostData("prune_evaluator");
        Assert.assertEquals((Object)"javascript", pruneEvaluator.get("language"));
        Assert.assertEquals((Object)"return true;", pruneEvaluator.get("body"));
    }

    @Test
    public void testFilterScript() throws Exception {
        this.traversalDescription.filter(RestTraversalDescription.ScriptLanguage.JAVASCRIPT, "return true;");
        Map pruneEvaluator = (Map)this.getPostData("return_filter");
        Assert.assertEquals((Object)"javascript", pruneEvaluator.get("language"));
        Assert.assertEquals((Object)"return true;", pruneEvaluator.get("body"));
    }

    @Test
    public void testEvaluator() throws Exception {
    }

    @Test
    public void testPrune() throws Exception {
    }

    @Test
    public void testFilter() throws Exception {
    }

    @Test
    public void testMaxDepth() throws Exception {
    }

    @Test
    public void testOrder() throws Exception {
    }

    @Test
    public void testDepthFirst() throws Exception {
    }

    @Test
    public void testBreadthFirst() throws Exception {
    }

    @Test
    public void testRelationships() throws Exception {
    }

    @Test
    public void testRelationshipsAndDirection() throws Exception {
    }

    @Test
    public void testExpand() throws Exception {
    }

    @Test
    public void testComplexTraversal() throws Exception {
    }
}

