/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.rest.support;

import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.server.plugins.Description;
import org.neo4j.server.plugins.Name;
import org.neo4j.server.plugins.Parameter;
import org.neo4j.server.plugins.PluginTarget;
import org.neo4j.server.plugins.ServerPlugin;
import org.neo4j.server.plugins.Source;
import org.springframework.context.ApplicationContext;
import org.springframework.data.neo4j.aspects.Friendship;
import org.springframework.data.neo4j.aspects.Person;
import org.springframework.data.neo4j.aspects.PersonRepository;
import org.springframework.data.neo4j.server.ProvidedClassPathXmlApplicationContext;
import org.springframework.data.neo4j.support.Neo4jTemplate;

@Description(value="A test plugin for spring data graph usage")
public class TestServerPlugin
extends ServerPlugin {
    private ApplicationContext ctx;
    private PersonRepository personRepository;
    private Neo4jTemplate template;

    public TestServerPlugin() {
        System.out.println("Initializing ServerPlugin");
    }

    @Name(value="person")
    @PluginTarget(value=GraphDatabaseService.class)
    public Node person(@Source GraphDatabaseService graphDb, @Parameter(name="name") String name) {
        this.context(graphDb);
        Person result = (Person)this.personRepository.findByPropertyValue("name-index", "name", (Object)name);
        return result != null ? result.getPersistentState() : null;
    }

    private synchronized ApplicationContext context(GraphDatabaseService graphDb) {
        try {
            if (this.ctx == null) {
                this.ctx = new ProvidedClassPathXmlApplicationContext(graphDb, new String[]{"Plugin-context.xml"});
                this.personRepository = (PersonRepository)this.ctx.getBean(PersonRepository.class);
                this.template = (Neo4jTemplate)this.ctx.getBean(Neo4jTemplate.class);
            }
            return this.ctx;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Name(value="get_all_friends")
    @Description(value="gets all friends of the given node")
    @PluginTarget(value=Node.class)
    public Iterable<Node> allFriendsOf(@Source Node target) {
        this.context(target.getGraphDatabase());
        Person person = (Person)this.template.load((PropertyContainer)target, Person.class);
        return new IterableWrapper<Node, Friendship>(person.getFriendships()){

            protected Node underlyingObjectToObject(Friendship friendship) {
                return friendship.getPerson2().getPersistentState();
            }
        };
    }
}

