/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.transaction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.neo4j.transaction.DefaultSynchronizationManager;
import org.springframework.data.neo4j.transaction.MultiTransactionStatus;
import org.springframework.data.neo4j.transaction.SynchronizationManager;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.HeuristicCompletionException;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.UnexpectedRollbackException;

public class ChainedTransactionManager
implements PlatformTransactionManager {
    private static final Logger logger = LoggerFactory.getLogger(ChainedTransactionManager.class);
    private final List<PlatformTransactionManager> transactionManagers;
    private final SynchronizationManager synchronizationManager;

    public ChainedTransactionManager(PlatformTransactionManager ... transactionManagers) {
        this(new DefaultSynchronizationManager(), transactionManagers);
    }

    public ChainedTransactionManager(SynchronizationManager synchronizationManager, PlatformTransactionManager ... transactionManagers) {
        this.synchronizationManager = synchronizationManager;
        this.transactionManagers = Arrays.asList(transactionManagers);
    }

    /*
     * Unable to fully structure code
     */
    public MultiTransactionStatus getTransaction(TransactionDefinition definition) throws TransactionException {
        block8: {
            mts = new MultiTransactionStatus(this.transactionManagers.get(0));
            if (!this.synchronizationManager.isSynchronizationActive()) {
                this.synchronizationManager.initSynchronization();
                mts.setNewSynchonization();
            }
            try {
                for (PlatformTransactionManager transactionManager : this.transactionManagers) {
                    mts.registerTransactionManager(definition, transactionManager);
                }
                break block8;
            }
            catch (Exception ex) {
                transactionStatuses = mts.getTransactionStatuses();
                ** for (transactionManager : this.transactionManagers)
            }
lbl-1000:
            // 1 sources

            {
                try {
                    if (transactionStatuses.get(transactionManager) == null) continue;
                    transactionManager.rollback(transactionStatuses.get(transactionManager));
                }
                catch (Exception ex2) {
                    ChainedTransactionManager.logger.warn("Rollback exception (" + transactionManager + ") " + ex2.getMessage(), (Throwable)ex2);
                }
                continue;
            }
lbl20:
            // 1 sources

            if (mts.isNewSynchonization()) {
                this.synchronizationManager.clearSynchronization();
            }
            throw new CannotCreateTransactionException(ex.getMessage(), (Throwable)ex);
        }
        return mts;
    }

    public void commit(TransactionStatus status) throws TransactionException {
        MultiTransactionStatus multiTransactionStatus = (MultiTransactionStatus)status;
        boolean commit = true;
        Exception commitException = null;
        PlatformTransactionManager commitExceptionTransactionManager = null;
        for (PlatformTransactionManager transactionManager : this.reverse(this.transactionManagers)) {
            if (commit) {
                try {
                    multiTransactionStatus.commit(transactionManager);
                }
                catch (Exception ex) {
                    commit = false;
                    commitException = ex;
                    commitExceptionTransactionManager = transactionManager;
                }
                continue;
            }
            try {
                multiTransactionStatus.rollback(transactionManager);
            }
            catch (Exception ex) {
                logger.warn("Rollback exception (after commit) (" + transactionManager + ") " + ex.getMessage(), (Throwable)ex);
            }
        }
        if (multiTransactionStatus.isNewSynchonization()) {
            this.synchronizationManager.clearSynchronization();
        }
        if (commitException != null) {
            boolean firstTransactionManagerFailed = commitExceptionTransactionManager == this.getLastTransactionManager();
            int transactionState = firstTransactionManagerFailed ? 2 : 3;
            throw new HeuristicCompletionException(transactionState, (Throwable)commitException);
        }
    }

    public void rollback(TransactionStatus status) throws TransactionException {
        Exception rollbackException = null;
        PlatformTransactionManager rollbackExceptionTransactionManager = null;
        MultiTransactionStatus multiTransactionStatus = (MultiTransactionStatus)status;
        for (PlatformTransactionManager transactionManager : this.reverse(this.transactionManagers)) {
            try {
                multiTransactionStatus.rollback(transactionManager);
            }
            catch (Exception ex) {
                if (rollbackException == null) {
                    rollbackException = ex;
                    rollbackExceptionTransactionManager = transactionManager;
                    continue;
                }
                logger.warn("Rollback exception (" + transactionManager + ") " + ex.getMessage(), (Throwable)ex);
            }
        }
        if (multiTransactionStatus.isNewSynchonization()) {
            this.synchronizationManager.clearSynchronization();
        }
        if (rollbackException != null) {
            throw new UnexpectedRollbackException("Rollback exception, originated at (" + rollbackExceptionTransactionManager + ") " + rollbackException.getMessage(), (Throwable)rollbackException);
        }
    }

    private <T> Iterable<T> reverse(Collection<T> collection) {
        ArrayList<T> list = new ArrayList<T>(collection);
        Collections.reverse(list);
        return list;
    }

    private PlatformTransactionManager getLastTransactionManager() {
        return this.transactionManagers.get(this.lastTransactionManagerIndex());
    }

    private int lastTransactionManagerIndex() {
        return this.transactionManagers.size() - 1;
    }
}

