/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.query;

import java.util.Map;
import org.neo4j.cypher.javacompat.ExecutionEngine;
import org.neo4j.cypher.javacompat.ExecutionResult;
import org.neo4j.graphdb.GraphDatabaseService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.data.neo4j.conversion.DefaultConverter;
import org.springframework.data.neo4j.conversion.QueryResultBuilder;
import org.springframework.data.neo4j.conversion.Result;
import org.springframework.data.neo4j.conversion.ResultConverter;
import org.springframework.data.neo4j.support.query.QueryEngine;
import org.springframework.data.neo4j.support.query.QueryParameterConverter;

public class CypherQueryEngine
implements QueryEngine<Map<String, Object>> {
    private static final Logger log = LoggerFactory.getLogger(CypherQueryEngine.class);
    private final ExecutionEngine executionEngine;
    private final ResultConverter resultConverter;
    private final QueryParameterConverter queryParameterConverter = new QueryParameterConverter();

    public CypherQueryEngine(GraphDatabaseService graphDatabaseService, ResultConverter resultConverter) {
        this.resultConverter = resultConverter != null ? resultConverter : new DefaultConverter();
        this.executionEngine = new ExecutionEngine(graphDatabaseService);
    }

    @Override
    public Result<Map<String, Object>> query(String statement, Map<String, Object> params) {
        try {
            ExecutionResult result = this.parseAndExecuteQuery(statement, params);
            return new QueryResultBuilder<Map<String, Object>>((Iterable<Map<String, Object>>)result, this.resultConverter);
        }
        catch (Exception e) {
            throw new InvalidDataAccessResourceUsageException("Error executing statement " + statement, (Throwable)e);
        }
    }

    private ExecutionResult parseAndExecuteQuery(String statement, Map<String, Object> params) {
        try {
            Map<String, Object> queryParams = this.queryParams(params);
            if (log.isDebugEnabled()) {
                log.debug(String.format("Executing cypher query: %s params %s", statement, queryParams));
            }
            return this.executionEngine.execute(statement, queryParams);
        }
        catch (Exception e) {
            throw new InvalidDataAccessResourceUsageException("Error executing statement " + statement, (Throwable)e);
        }
    }

    private Map<String, Object> queryParams(Map<String, Object> params) {
        return this.queryParameterConverter.convert(params);
    }
}

