/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.annotation.relatedto;

import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.Direction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.neo4j.annotation.EndNode;
import org.springframework.data.neo4j.annotation.Fetch;
import org.springframework.data.neo4j.annotation.GraphId;
import org.springframework.data.neo4j.annotation.NodeEntity;
import org.springframework.data.neo4j.annotation.RelatedTo;
import org.springframework.data.neo4j.annotation.RelatedToVia;
import org.springframework.data.neo4j.annotation.RelationshipEntity;
import org.springframework.data.neo4j.annotation.StartNode;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:related-to-test-context.xml"})
@Transactional
public class BiDirectionalRelatedToViaWithSingleFetchMappingTests {
    @Autowired
    Neo4jTemplate template;

    @Test
    public void testLoadBidirectionalRelationship() throws Exception {
        TestEntity one = (TestEntity)this.template.save((Object)new TestEntity());
        TestEntity kid = (TestEntity)this.template.save((Object)new TestEntity());
        TestEntity kid2 = (TestEntity)this.template.save((Object)new TestEntity());
        TestRelationship rel1 = (TestRelationship)this.template.save((Object)new TestRelationship(one, kid));
        this.template.save((Object)new TestRelationship(one, kid2));
        TestEntity anotherOne = (TestEntity)this.template.findOne(kid.id.longValue(), TestEntity.class);
        Assert.assertSame((Object)rel1.id, (Object)anotherOne.parent.id);
        Assert.assertSame((Object)anotherOne, (Object)anotherOne.parent.kid);
        Assert.assertSame((Object)one.id, (Object)anotherOne.parent.parent.id);
        Assert.assertSame((Object)anotherOne.directParent, (Object)anotherOne.parent.parent);
    }

    @RelationshipEntity(type="test")
    static class TestRelationship {
        @GraphId
        Long id;
        @Fetch
        @StartNode
        TestEntity parent;
        @Fetch
        @EndNode
        TestEntity kid;

        TestRelationship() {
        }

        public TestRelationship(TestEntity parent, TestEntity kid) {
            this.parent = parent;
            this.kid = kid;
        }
    }

    @NodeEntity
    static class TestEntity {
        @GraphId
        Long id;
        @RelatedTo(type="test", direction=Direction.INCOMING)
        TestEntity directParent;
        @RelatedToVia(type="test")
        Set<TestRelationship> kids;
        @Fetch
        @RelatedToVia(type="test", direction=Direction.INCOMING)
        TestRelationship parent;

        TestEntity() {
        }
    }
}

