/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.annotation.relatedto;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.springframework.data.neo4j.annotation.IdentifiableEntity;
import org.springframework.data.neo4j.annotation.NodeEntity;
import org.springframework.data.neo4j.annotation.RelatedTo;

@NodeEntity
public class Town
extends IdentifiableEntity {
    private String name;
    @RelatedTo
    private Town twin;
    @RelatedTo
    private Set<Town> neighbours = new HashSet<Town>();

    public Town() {
    }

    public Town(String name) {
        this.name = name;
    }

    public void isTwinnedWith(Town twin) {
        this.twin = twin;
    }

    public Town getTwin() {
        return this.twin;
    }

    public void hasNeighbours(Town ... towns) {
        this.neighbours.addAll(Arrays.asList(towns));
    }

    public Set<Town> getNeighbours() {
        return this.neighbours;
    }
}

