/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.annotation.relatedto;

import java.util.HashSet;
import java.util.Set;
import org.springframework.data.neo4j.annotation.IdentifiableEntity;
import org.springframework.data.neo4j.annotation.NodeEntity;
import org.springframework.data.neo4j.annotation.RelatedTo;
import org.springframework.data.neo4j.annotation.relatedto.Animal;
import org.springframework.data.neo4j.annotation.relatedto.Carnivore;
import org.springframework.data.neo4j.annotation.relatedto.Herbivore;

@NodeEntity
public class Zoo
extends IdentifiableEntity {
    private String name;
    @RelatedTo(type="exhibit", enforceTargetType=true)
    private Iterable<Animal> animals;
    @RelatedTo(type="exhibit", enforceTargetType=true)
    private Set<Herbivore> herbivores = new HashSet<Herbivore>();
    @RelatedTo(type="exhibit", enforceTargetType=true)
    private Set<Carnivore> carnivores = new HashSet<Carnivore>();

    public Zoo() {
    }

    public Zoo(String name) {
        this.name = name;
    }

    public void exhibits(Herbivore herbivore) {
        this.herbivores.add(herbivore);
    }

    public void exhibits(Carnivore carnivore) {
        this.carnivores.add(carnivore);
    }

    public Iterable<Animal> getAllAnimals() {
        return this.animals;
    }

    public Set<Herbivore> getHerbivores() {
        return this.herbivores;
    }

    public Set<Carnivore> getCarnivores() {
        return this.carnivores;
    }
}

