/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.annotation.relatedtovia;

import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.Relationship;
import org.neo4j.helpers.collection.IteratorUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.neo4j.SetHelper;
import org.springframework.data.neo4j.annotation.RelationshipDelegates;
import org.springframework.data.neo4j.annotation.relatedtovia.City;
import org.springframework.data.neo4j.annotation.relatedtovia.CityRepository;
import org.springframework.data.neo4j.annotation.relatedtovia.Country;
import org.springframework.data.neo4j.annotation.relatedtovia.CountryRepository;
import org.springframework.data.neo4j.annotation.relatedtovia.Line;
import org.springframework.data.neo4j.annotation.relatedtovia.MetroLine;
import org.springframework.data.neo4j.annotation.relatedtovia.MetroLineRepository;
import org.springframework.data.neo4j.annotation.relatedtovia.Player;
import org.springframework.data.neo4j.annotation.relatedtovia.PlayerRepository;
import org.springframework.data.neo4j.annotation.relatedtovia.PlayerStatus;
import org.springframework.data.neo4j.annotation.relatedtovia.SuperState;
import org.springframework.data.neo4j.annotation.relatedtovia.SuperStateRepository;
import org.springframework.data.neo4j.annotation.relatedtovia.Team;
import org.springframework.data.neo4j.annotation.relatedtovia.TeamRepository;
import org.springframework.data.neo4j.annotation.relatedtovia.TubeStation;
import org.springframework.data.neo4j.annotation.relatedtovia.UndergroundRepository;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:related-to-via-test-context.xml"})
@Transactional
public class RelatedToViaTests {
    public static final String DISTRICT_LINE = "District Line";
    public static final String CENTRAL_LINE = "Central Line";
    @Autowired
    private UndergroundRepository tfl;
    @Autowired
    private CountryRepository countries;
    @Autowired
    private SuperStateRepository dystopia;
    @Autowired
    private MetroLineRepository metroLines;
    @Autowired
    private CityRepository cities;
    @Autowired
    private PlayerRepository players;
    @Autowired
    private TeamRepository teams;
    @Autowired
    private Neo4jTemplate template;

    @Before
    public void before() {
        this.tfl.deleteAll();
        this.countries.deleteAll();
        this.dystopia.deleteAll();
        this.metroLines.deleteAll();
        this.cities.deleteAll();
        this.players.deleteAll();
        this.teams.deleteAll();
    }

    @Test
    public void shouldMapRelationshipAsFirstClassCitizen() throws Exception {
        TubeStation westHam = (TubeStation)this.tfl.save(new TubeStation("West Ham"));
        TubeStation stratford = (TubeStation)this.tfl.save(new TubeStation("Stratford"));
        TubeStation mileEnd = new TubeStation("Mile End");
        mileEnd.connectsTo(westHam, DISTRICT_LINE);
        mileEnd.connectsTo(stratford, CENTRAL_LINE);
        this.tfl.save(mileEnd);
        Assert.assertThat((Object)((Relationship)IteratorUtil.first((Iterable)this.template.getNode(mileEnd.getId().longValue()).getRelationships())).getType().name(), (Matcher)Is.is((Object)"route"));
        mileEnd = (TubeStation)this.tfl.findOne(mileEnd.getId());
        Line line = (Line)IteratorUtil.first(mileEnd.getLines());
        Assert.assertThat((Object)mileEnd, (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)line.getOrigin())));
        Assert.assertThat(Arrays.asList(DISTRICT_LINE, CENTRAL_LINE), (Matcher)JUnitMatchers.hasItem((Object)line.getName()));
        Assert.assertThat(Arrays.asList(westHam, stratford), (Matcher)JUnitMatchers.hasItem((Object)line.getDestination()));
    }

    @Test
    public void shouldGivePrecedenceToAnnotationProvidedRelationshipTypeOverDefault() throws Exception {
        Country france = (Country)this.countries.save(new Country("R\u00e9publique fran\u00e7aise"));
        Country usa = (Country)this.countries.save(new Country("United States of America"));
        Country uk = new Country("United Kingdom of Great Britain and Northern Ireland");
        uk.hasCordialRelationsWith(france, "Entente Cordiale");
        uk.hasSpecialRelationsWith(usa);
        this.countries.save(uk);
        Assert.assertThat(RelationshipDelegates.getRelationshipNames(this.template, uk), (Matcher)Is.is((Matcher)IsEqual.equalTo(SetHelper.asSet("cordial", "special"))));
    }

    @Test
    public void shouldGivePrecedenceToAnnotationProvidedRelationshipTypeOverDefaultForCollections() throws Exception {
        MetroLine m1 = (MetroLine)this.metroLines.save(new MetroLine("M1 - Vanl\u00f8se to Vestamager"));
        MetroLine m2 = (MetroLine)this.metroLines.save(new MetroLine("M2 - Vanl\u00f8se to Lufthavnen"));
        MetroLine m3 = (MetroLine)this.metroLines.save(new MetroLine("M3 - Cityringen"));
        MetroLine m4 = (MetroLine)this.metroLines.save(new MetroLine("M4 - N\u00f8rrebro to K\u00f8benhavn H"));
        City copenhagen = new City("Copenhagen");
        copenhagen.has(m1, m2);
        copenhagen.plans(m3, m4);
        this.cities.save(copenhagen);
        Assert.assertThat(RelationshipDelegates.getRelationshipNames(this.template, copenhagen), (Matcher)Is.is((Matcher)IsEqual.equalTo(SetHelper.asSet("existing", "planned"))));
        Assert.assertThat(copenhagen.getCurrentMetroLines(), (Matcher)Is.is((Matcher)IsEqual.equalTo(SetHelper.asSet(m1, m2))));
        Assert.assertThat(copenhagen.getFutureMetroLines(), (Matcher)Is.is((Matcher)IsEqual.equalTo(SetHelper.asSet(m3, m4))));
    }

    @Test
    public void shouldGivePrecedenceToDynamicRelationshipTypeOverAnnotationProvidedRelationshipType() throws Exception {
        SuperState eastasia = (SuperState)this.dystopia.save(new SuperState("Eastasia"));
        SuperState eurasia = (SuperState)this.dystopia.save(new SuperState("Eurasia"));
        SuperState oceania = new SuperState("Oceania");
        oceania.isAlliedWith(eastasia);
        this.dystopia.save(oceania);
        Assert.assertThat(RelationshipDelegates.getRelationshipNames(this.template, oceania), (Matcher)Is.is((Matcher)IsEqual.equalTo(SetHelper.asSet("alliedWith"))));
        oceania = (SuperState)this.dystopia.findOne(oceania.getId());
        oceania.isAtWarWith(eurasia);
        this.dystopia.save(oceania);
        Assert.assertThat(RelationshipDelegates.getRelationshipNames(this.template, oceania), (Matcher)Is.is((Matcher)IsEqual.equalTo(SetHelper.asSet("atWarWith"))));
    }

    @Test
    public void shouldGivePrecedenceToDynamicRelationshipTypeOverAnnotationProvidedRelationshipTypeForCollections() throws Exception {
        Player jordan = (Player)this.players.save(new Player("Michael Jordan"));
        Player pippen = (Player)this.players.save(new Player("Scottie Pippen"));
        Team bulls = new Team("Chicago Bulls");
        bulls.add(new PlayerStatus(bulls, jordan));
        bulls.add(new PlayerStatus(bulls, pippen, "substitute"));
        this.teams.save(bulls);
        Assert.assertThat(RelationshipDelegates.getRelationshipNames(this.template, bulls), (Matcher)Is.is((Matcher)IsEqual.equalTo(SetHelper.asSet("starter", "substitute"))));
    }

    @Test
    public void shouldValidateEndNode() throws Exception {
        TubeStation mileEnd = new TubeStation("East Ham");
        mileEnd.connectsTo(null, DISTRICT_LINE);
        try {
            this.tfl.save(mileEnd);
            Assert.fail();
        }
        catch (InvalidDataAccessApiUsageException e) {
            Assert.assertThat((Object)e.getCause().getMessage(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)("End node must not be null (" + Line.class.getName() + ")"))));
        }
    }
}

