/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.conversion;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.MapUtil;
import org.springframework.data.neo4j.annotation.ResultColumn;
import org.springframework.data.neo4j.conversion.QueryMapResultConverter;
import org.springframework.data.neo4j.mapping.Neo4jPersistentTestBase;
import org.springframework.data.neo4j.model.Friendship;
import org.springframework.data.neo4j.model.Person;
import org.springframework.data.neo4j.support.conversion.NoSuchColumnFoundException;
import org.springframework.data.neo4j.template.Neo4jOperations;

public class QueryMapResultConverterTests
extends Neo4jPersistentTestBase {
    private Map<String, Object> simpleMap;
    private List<String> friends;
    private Map<String, Object> advancedMap;

    @Before
    public void init() throws Exception {
        this.storeInGraph(this.michael);
        this.storeInGraph(this.andres);
        this.storeInGraph(this.emil);
        this.makeFriends(this.michaelNode(), this.andresNode(), 19);
        this.makeFriends(this.michaelNode(), this.emilNode(), 6);
        this.friends = Arrays.asList("Michael", "Emil", "Anders");
        this.simpleMap = MapUtil.map((Object[])new Object[]{"name", "Andres", "age", 36L, "friends", this.friends});
        this.advancedMap = MapUtil.map((Object[])new Object[]{"person", this.michaelNode(), "collect(r)", this.michaelNode().getRelationships(new RelationshipType[]{KNOWS})});
        this.michael = this.readPerson(this.michaelNode());
    }

    @Test
    public void shouldBeAbleToGetAStringFromAResultMap() throws Exception {
        QueryMapResultConverter<SimplestQuery> converter = this.getConverter();
        SimplestQuery query = (SimplestQuery)converter.convert(this.simpleMap, SimplestQuery.class);
        Assert.assertThat((Object)query.getName(), (Matcher)CoreMatchers.equalTo((Object)"Andres"));
        Assert.assertThat((Object)query.getAge(), (Matcher)CoreMatchers.equalTo((Object)36));
    }

    @Test
    public void shouldBeAbleToHandleAnIterableOfString() throws Exception {
        QueryMapResultConverter<SimplestQuery> converter = this.getConverter();
        SimplestQuery query = (SimplestQuery)converter.convert(this.simpleMap, SimplestQuery.class);
        Assert.assertThat(query.getFriendNames(), (Matcher)JUnitMatchers.hasItems((Object[])new String[]{"Michael", "Emil", "Anders"}));
    }

    @Test
    public void shouldHandleANodeBackedEntity() throws Exception {
        QueryMapResultConverter converter = new QueryMapResultConverter((Neo4jOperations)this.template);
        PersonAndFriendsData result = (PersonAndFriendsData)converter.convert(this.advancedMap, PersonAndFriendsData.class);
        Assert.assertThat((Object)result.getPerson(), (Matcher)CoreMatchers.equalTo((Object)this.michael));
        Assert.assertThat((Object)IteratorUtil.asCollection(result.getFriends()), (Matcher)CoreMatchers.equalTo((Object)IteratorUtil.asCollection(this.michael.getFriendships())));
    }

    @Test(expected=NoSuchColumnFoundException.class)
    public void shouldThrowNiceException() throws Exception {
        QueryMapResultConverter converter = new QueryMapResultConverter((Neo4jOperations)this.template);
        PersonAndFriendsData convert = (PersonAndFriendsData)converter.convert(MapUtil.map((Object[])new Object[0]), PersonAndFriendsData.class);
        convert.getFriends();
    }

    @Test
    public void testShouldBeAbleToCompareTwoResults() throws Exception {
        QueryMapResultConverter<SimplestQuery> converter = this.getConverter();
        SimplestQuery query1 = (SimplestQuery)converter.convert(this.simpleMap, SimplestQuery.class);
        SimplestQuery query2 = (SimplestQuery)converter.convert(this.simpleMap, SimplestQuery.class);
        SimplestQuery query1Clone = (SimplestQuery)converter.convert(new HashMap<String, Object>(this.simpleMap), SimplestQuery.class);
        HashMap<String, Object> copy = new HashMap<String, Object>(this.simpleMap);
        copy.put("name", "Michael");
        SimplestQuery otherQuery = (SimplestQuery)converter.convert(copy, SimplestQuery.class);
        Assert.assertEquals((long)query1.hashCode(), (long)query2.hashCode());
        Assert.assertEquals((Object)query1, (Object)query2);
        Assert.assertEquals((Object)query1, (Object)query1Clone);
        Assert.assertEquals((long)query1.hashCode(), (long)query1Clone.hashCode());
        Assert.assertEquals((Object)false, (Object)query1.equals(otherQuery));
        Assert.assertEquals((Object)false, (Object)(query1.hashCode() == otherQuery.hashCode() ? 1 : 0));
    }

    @Test
    public void testPutQueryResultsInSet() throws Exception {
        QueryMapResultConverter<SimplestQuery> converter = this.getConverter();
        SimplestQuery query1 = (SimplestQuery)converter.convert(this.simpleMap, SimplestQuery.class);
        SimplestQuery query2 = (SimplestQuery)converter.convert(this.simpleMap, SimplestQuery.class);
        HashSet<SimplestQuery> set = new HashSet<SimplestQuery>();
        set.add(query1);
        Assert.assertEquals((Object)true, (Object)set.contains(query1));
        Assert.assertEquals((Object)true, (Object)set.contains(query2));
    }

    private QueryMapResultConverter<SimplestQuery> getConverter() {
        return new QueryMapResultConverter((Neo4jOperations)this.template);
    }

    public static interface SimplestQuery {
        @ResultColumn(value="name")
        public String getName();

        @ResultColumn(value="age")
        public Integer getAge();

        @ResultColumn(value="friends")
        public Iterable<String> getFriendNames();
    }

    public static interface PersonAndFriendsData {
        @ResultColumn(value="person")
        public Person getPerson();

        @ResultColumn(value="collect(r)")
        public Iterable<Friendship> getFriends();
    }
}

