/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.equality;

import org.springframework.data.neo4j.annotation.GraphId;
import org.springframework.data.neo4j.annotation.NodeEntity;

@NodeEntity
class HashCodeCachingEntity {
    @GraphId
    Long id;
    private transient Integer hash;

    HashCodeCachingEntity() {
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (this.hashCode() != other.hashCode()) {
            return false;
        }
        if (this.id == null) {
            return false;
        }
        if (!(other instanceof HashCodeCachingEntity)) {
            return false;
        }
        return this.id.equals(((HashCodeCachingEntity)other).id);
    }

    public int hashCode() {
        if (this.hash == null) {
            this.hash = this.id == null ? System.identityHashCode(this) : this.id.hashCode();
        }
        return this.hash.hashCode();
    }

    public String toString() {
        return String.format("%s[%d, #%d]", this.getClass().getSimpleName(), this.id, this.hashCode());
    }
}

