/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.lifecycle;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.test.ImpermanentGraphDatabase;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.neo4j.config.EnableNeo4jRepositories;
import org.springframework.data.neo4j.config.Neo4jConfiguration;
import org.springframework.data.neo4j.lifecycle.BeforeSaveEvent;
import org.springframework.data.neo4j.lifecycle.Foo;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration
@Transactional
public class BeforeSaveEventTests {
    @Autowired
    private Neo4jTemplate template;

    @Test
    public void shouldFireBeforeEntityIsSaved() throws Exception {
        Assert.assertThat((Object)((Foo)this.template.save((Object)new Foo())).generatedId, (Matcher)CoreMatchers.is((Object)"before event"));
        Assert.assertThat((Object)((Foo)IteratorUtil.single((Iterable)this.template.findAll(Foo.class))).generatedId, (Matcher)CoreMatchers.is((Object)"before event"));
    }

    @Configuration
    @EnableNeo4jRepositories
    static class TestConfig
    extends Neo4jConfiguration {
        TestConfig() {
        }

        @Bean
        GraphDatabaseService graphDatabaseService() {
            return new ImpermanentGraphDatabase();
        }

        @Bean
        ApplicationListener<BeforeSaveEvent> beforeSaveEventApplicationListener() {
            return new ApplicationListener<BeforeSaveEvent>(){

                public void onApplicationEvent(BeforeSaveEvent event) {
                    Foo foo = (Foo)event.getEntity();
                    foo.generatedId = "before event";
                }
            };
        }
    }
}

