/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.mapping;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.index.Index;
import org.neo4j.helpers.collection.IteratorUtil;
import org.springframework.data.neo4j.mapping.Neo4jPersistentTestBase;
import org.springframework.data.neo4j.model.Friendship;
import org.springframework.data.neo4j.model.Group;
import org.springframework.data.neo4j.model.Person;
import org.springframework.data.neo4j.model.Personality;

public class Neo4jEntityConverterTests
extends Neo4jPersistentTestBase {
    @Test
    public void testWriteEntityToNewNode() {
        this.storeInGraph(this.michael);
        Assert.assertEquals((Object)"Michael", (Object)this.michaelNode().getProperty("name"));
    }

    @Test
    public void testLoadPolicy() {
        this.storeInGraph(this.emil);
        this.michael.setHeight((short)182);
        this.michael.setPersonality(Personality.EXTROVERT);
        this.michael.setBoss(this.emil);
        this.storeInGraph(this.michael);
        Person loaded = (Person)this.template.findOne(this.michael.getId().longValue(), Person.class);
        Assert.assertEquals((String)"loaded id", (Object)this.michael.getId(), (Object)loaded.getId());
        Assert.assertEquals((String)"loaded simple property", (Object)this.michael.getName(), (Object)loaded.getName());
        Assert.assertEquals((String)"loaded simple short property", (Object)this.michael.getHeight(), (Object)loaded.getHeight());
        Assert.assertEquals((String)"loaded simple converted property", (Object)((Object)this.michael.getPersonality()), (Object)((Object)loaded.getPersonality()));
        Person boss = loaded.getBoss();
        Assert.assertNotNull((String)"instance non-fetch relationship", (Object)boss);
        Assert.assertEquals((String)"id of non-fetch relationship", (Object)this.emil.getId(), (Object)boss.getId());
        Assert.assertNull((String)"no properties of non-fetch relationship", (Object)boss.getName());
    }

    @Test
    public void testFindNewlyWrittenNodeInIndex() {
        this.storeInGraph(this.michael);
        Node createdNode = this.michaelNode();
        Index index = this.template.getIndex("name-index", Person.class);
        Node found = (Node)index.get("name", (Object)"Michael").getSingle();
        Assert.assertEquals((String)"node found in index", (Object)createdNode, (Object)found);
        Assert.assertEquals((String)"node property loaded", (Object)this.michael.getName(), (Object)found.getProperty("name"));
    }

    @Test
    public void testWriteEntityToExistingNode() {
        Node existingNode = this.createNewNode();
        this.write(this.michael, existingNode);
        Assert.assertEquals((String)"Entity uses provided node", (Object)existingNode.getId(), (Object)this.michael.getId());
        Assert.assertEquals((Object)"Michael", (Object)existingNode.getProperty("name"));
    }

    @Test
    public void testUpdateExistingNode() {
        Node existingNode = this.createNewNode();
        existingNode.setProperty("name", (Object)"Test");
        Assert.assertEquals((Object)"Test", (Object)existingNode.getProperty("name"));
        this.write(this.michael, existingNode);
        Assert.assertEquals((Object)"Michael", (Object)existingNode.getProperty("name"));
        this.michael.setName("Emil");
        this.write(this.michael, existingNode);
        Assert.assertEquals((Object)"Emil", (Object)existingNode.getProperty("name"));
    }

    @Test
    public void testWriteConvertedPropertiesToExistingNode() {
        Node existingNode = this.createNewNode();
        this.michael.setBirthdate(new Date(100L));
        this.michael.setPersonality(Personality.EXTROVERT);
        this.write(this.michael, existingNode);
        Assert.assertEquals((Object)"100", (Object)existingNode.getProperty("birthdate"));
        Assert.assertEquals((Object)"EXTROVERT", (Object)existingNode.getProperty("personality"));
    }

    @Test
    public void testReadConvertedPropertiesFromExistingNode() {
        Node existingNode = this.createNewNode();
        existingNode.setProperty("name", (Object)"Michael");
        existingNode.setProperty("age", (Object)36);
        existingNode.setProperty("personality", (Object)"EXTROVERT");
        existingNode.setProperty("birthdate", (Object)"100");
        Person p = this.readPerson(existingNode);
        Assert.assertEquals((Object)"Michael", (Object)p.getName());
        Assert.assertEquals((long)36L, (long)p.getAge());
        Assert.assertEquals((Object)new Date(100L), (Object)p.getBirthdate());
        Assert.assertEquals((Object)((Object)Personality.EXTROVERT), (Object)((Object)p.getPersonality()));
    }

    private <T> void neo4jPropertyTest(T value) {
        this.michael.setDynamicProperty(value);
        this.storeInGraph(this.michael);
        Person loaded = (Person)this.template.findOne(this.michael.getId().longValue(), Person.class);
        Assert.assertEquals(value, (Object)loaded.getDynamicProperty());
    }

    @Test
    public void testIntProperty() {
        this.neo4jPropertyTest(123);
    }

    @Test
    public void testDoubleProperty() {
        this.neo4jPropertyTest(3.1415);
    }

    @Test
    public void testBooleanProperty() {
        this.neo4jPropertyTest(true);
    }

    @Test
    public void testIntegerProperty() {
        this.neo4jPropertyTest(3);
    }

    @Test
    public void testDeleteProperty() {
        Node existingNode = this.createNewNode();
        this.write(this.michael, existingNode);
        this.michael.setName(null);
        this.write(this.michael, existingNode);
        Assert.assertEquals((Object)false, (Object)existingNode.hasProperty("name"));
    }

    @Test
    public void testReadEntityFromExistingNode() {
        Node node = this.createNewNode();
        node.setProperty("name", (Object)"Emil");
        Person p = this.readPerson(node);
        Assert.assertEquals((Object)"Emil", (Object)p.getName());
    }

    @Test
    public void testSetRelationshipWithPreExistingNode() {
        Person emil1 = this.emil;
        this.storeInGraph(emil1);
        this.michael.setBoss(this.emil);
        this.storeInGraph(this.michael);
        Node boss = this.getRelatedNodes(this.michaelNode(), "boss", Direction.INCOMING).get(0);
        Assert.assertEquals((String)"added additional relationship end node", (Object)this.emil.getId(), (Object)boss.getId());
    }

    @Test
    public void testAddRelationshipWithPreExistingNode() {
        this.storeInGraph(this.michael);
        this.group.setPersons(Collections.singleton(this.michael));
        this.storeInGraph(this.group);
        Collection persons = IteratorUtil.asCollection((Iterable)this.groupNode().getRelationships(PERSONS, Direction.OUTGOING));
        Node michaelNode = ((Relationship)persons.iterator().next()).getOtherNode(this.groupNode());
        Assert.assertEquals((String)"added michaelNode to group", (Object)this.michael.getId(), (Object)michaelNode.getId());
    }

    @Test
    public void testAddRelationshipWithTwoExistingNodes() {
        this.storeInGraph(this.michael);
        this.storeInGraph(this.andres);
        this.group.setPersons(this.set(this.andres, this.michael));
        this.storeInGraph(this.group);
        List<Node> persons = this.groupMemberNodes();
        Assert.assertEquals((long)2L, (long)persons.size());
        Assert.assertEquals(Arrays.asList(this.michaelNode(), this.andresNode()), persons);
    }

    @Test
    public void testAddRelationshipWithTwoPeopleButJustOneExistingNodes() {
        this.storeInGraph(this.michael);
        this.group.setPersons(this.set(this.andres, this.michael));
        this.storeInGraph(this.group);
        List<Node> persons = this.groupMemberNodes();
        Assert.assertEquals((long)2L, (long)persons.size());
        Assert.assertEquals(Arrays.asList(this.michaelNode(), this.andresNode()), persons);
    }

    @Test
    public void testAddRelationshipCascadeOverTwoSteps() {
        this.andres.setBoss(this.emil);
        this.group.setPersons(Collections.singleton(this.andres));
        this.storeInGraph(this.group);
        List<Node> persons = this.groupMemberNodes();
        Assert.assertEquals((long)1L, (long)persons.size());
        Assert.assertEquals(Arrays.asList(this.andresNode()), persons);
        Assert.assertEquals((Object)this.emil.getId(), (Object)this.getRelatedNodes(this.andresNode(), "boss", Direction.INCOMING).get(0).getId());
    }

    @Test
    public void testDeleteSingleRelationship() {
        this.emil.setBoss(this.andres);
        this.storeInGraph(this.emil);
        this.emil.setBoss(null);
        this.storeInGraph(this.emil);
        Assert.assertEquals((long)0L, (long)this.getRelatedNodes(this.emilNode(), "boss", Direction.INCOMING).size());
    }

    @Test
    public void testDeleteMultipleRelationships() {
        this.group.setPersons(this.set(this.storeInGraph(this.emil), this.storeInGraph(this.michael), this.storeInGraph(this.andres)));
        this.storeInGraph(this.group);
        Assert.assertTrue((boolean)this.group.getPersons().remove(this.emil));
        this.storeInGraph(this.group);
        Assert.assertEquals(this.set(this.andresNode(), this.michaelNode()), this.set(this.groupMemberNodes()));
    }

    @Test
    public void testReadRelationshipCollectionFromGraph() {
        Node groupNode = this.createNewNode();
        Node p1 = this.createNewNode();
        Node p2 = this.createNewNode();
        groupNode.createRelationshipTo(p1, PERSONS);
        groupNode.createRelationshipTo(p2, PERSONS);
        Group g = this.readGroup(groupNode);
        Assert.assertEquals(this.set(this.readPerson(p1), this.readPerson(p2)), this.set(g.getPersons()));
    }

    @Test
    public void testReadRelationshipIterableFromGraph() {
        Node groupNode = this.createNewNode();
        Node p1 = this.createNewNode();
        Node p2 = this.createNewNode();
        groupNode.createRelationshipTo(p1, PERSONS);
        groupNode.createRelationshipTo(p2, PERSONS);
        Group g = this.readGroup(groupNode);
        Assert.assertEquals(this.set(this.readPerson(p1), this.readPerson(p2)), this.set(g.getReadOnlyPersons()));
    }

    @Test
    public void testRelationshipCollectionModificationIsReflectedInGraph() {
        this.group.setPersons(this.set(this.storeInGraph(this.emil), this.storeInGraph(this.andres)));
        this.storeInGraph(this.group);
        this.group.getPersons().remove(this.emil);
        this.group.getPersons().add(this.storeInGraph(this.michael));
        this.storeInGraph(this.group);
        Assert.assertEquals(this.set(this.andresNode(), this.michaelNode()), this.set(this.groupMemberNodes()));
    }

    @Test
    public void testNullValuesForRelationshipCollectionsAreIgnored() {
        this.group.setPersons(this.set(this.storeInGraph(this.emil)));
        this.storeInGraph(this.group);
        Assert.assertEquals(this.set(this.emilNode()), this.set(this.groupMemberNodes()));
        this.group.setPersons(null);
        this.storeInGraph(this.group);
        Assert.assertEquals(this.set(this.emilNode()), this.set(this.groupMemberNodes()));
    }

    @Test
    public void testSetRelationshipWithNonExistingNode() {
        this.michael.setBoss(this.emil);
        this.storeInGraph(this.michael);
        Node node = this.michaelNode();
        Node boss = this.getRelatedNodes(node, "boss", Direction.INCOMING).get(0);
        Assert.assertEquals((String)"added additional relationship end node", (Object)this.emil.getId(), (Object)boss.getId());
    }

    @Test
    public void testAddRelationshipWithNonExistingNode() {
        this.group.setPersons(Collections.singleton(this.michael));
        this.storeInGraph(this.group);
        Node groupNode = this.groupNode();
        Node michaelNode = this.getRelatedNodes(groupNode, "persons", Direction.OUTGOING).get(0);
        Assert.assertEquals((String)"added member to group", (Object)this.michael.getId(), (Object)michaelNode.getId());
    }

    @Test
    public void testCascadingReadWithOutProperties() {
        Node groupNode = this.createNewNode();
        Node julianNode = this.createNewNode();
        julianNode.setProperty("name", (Object)"Julian");
        groupNode.createRelationshipTo(julianNode, PERSONS);
        Group g = this.readGroup(groupNode);
        Assert.assertNull((Object)((Person)IteratorUtil.first(g.getPersons())).getName());
    }

    @Test
    public void testCascadingReadWithProperties() {
        Node groupNode = this.createNewNode();
        Node julianNode = this.createNewNode();
        julianNode.setProperty("name", (Object)"Julian");
        groupNode.createRelationshipTo(julianNode, (RelationshipType)DynamicRelationshipType.withName((String)"fetchedPersons"));
        Group g = this.readGroup(groupNode);
        Assert.assertEquals((Object)"Julian", (Object)((Person)IteratorUtil.first(g.getFetchedPersons())).getName());
    }

    @Test
    public void testLoadFriendShipsFromPersons() throws Exception {
        this.storeInGraph(this.michael);
        this.storeInGraph(this.andres);
        Relationship friendshipRelationship = this.makeFriends(this.michaelNode(), this.andresNode(), 19);
        Person m = this.readPerson(this.michaelNode());
        Friendship friendship = (Friendship)IteratorUtil.first(m.getFriendships());
        Assert.assertEquals((Object)friendshipRelationship.getId(), (Object)friendship.getId());
        Assert.assertEquals((long)19L, (long)friendship.getYears());
        Assert.assertEquals((Object)friendship.getPerson1(), (Object)this.michael);
        Assert.assertEquals((Object)friendship.getPerson2(), (Object)this.andres);
    }
}

