/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.mapping.invalid;

import org.junit.Test;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.neo4j.annotation.GraphId;
import org.springframework.data.neo4j.annotation.NodeEntity;
import org.springframework.data.neo4j.annotation.RelatedTo;
import org.springframework.data.neo4j.annotation.RelatedToVia;
import org.springframework.data.neo4j.annotation.RelationshipEntity;
import org.springframework.data.neo4j.support.mapping.Neo4jMappingContext;

public class InvalidMappingTests {
    @Test(expected=MappingException.class)
    public void testFailInvalidRelatedTo() throws Exception {
        Neo4jMappingContext context = new Neo4jMappingContext();
        context.getPersistentEntity(TestEntityRelatedTo.class);
    }

    @Test(expected=MappingException.class)
    public void testFailInvalidRelatedToVia() throws Exception {
        Neo4jMappingContext context = new Neo4jMappingContext();
        context.getPersistentEntity(TestEntityRelatedToVia.class);
    }

    @NodeEntity
    static class TestEntityRelatedToVia {
        @GraphId
        Long id;
        @RelatedTo
        TestRelationship test;

        TestEntityRelatedToVia() {
        }
    }

    @RelationshipEntity
    static class TestRelationship {
        @GraphId
        Long id;

        TestRelationship() {
        }
    }

    @NodeEntity
    static class TestEntityRelatedTo {
        @GraphId
        Long id;
        @RelatedToVia
        TestEntityRelatedTo test;

        TestEntityRelatedTo() {
        }
    }
}

