/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.model;

import org.springframework.data.neo4j.annotation.EndNode;
import org.springframework.data.neo4j.annotation.GraphId;
import org.springframework.data.neo4j.annotation.Indexed;
import org.springframework.data.neo4j.annotation.RelationshipEntity;
import org.springframework.data.neo4j.annotation.StartNode;
import org.springframework.data.neo4j.model.Person;

@RelationshipEntity(type="BEST_FRIEND")
public class BestFriend {
    @GraphId
    private Long id;
    @Indexed(unique=true)
    private String secretName;
    @StartNode
    private Person p1;
    @EndNode
    private Person p2;

    public BestFriend() {
    }

    public BestFriend(Person p1, Person p2, String secretName) {
        this.p1 = p1;
        this.p2 = p2;
        this.secretName = secretName;
    }

    public Person getPerson1() {
        return this.p1;
    }

    public Person getPerson2() {
        return this.p2;
    }

    public String getSecretName() {
        return this.secretName;
    }

    public Long getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BestFriend friendship = (BestFriend)o;
        if (this.id == null) {
            return super.equals(o);
        }
        return this.id.equals(friendship.id);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : super.hashCode();
    }
}

